/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.List;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;

public class ToTextTool
implements Tool {
    private static final String TEXT_FILE_SCHEMA = "\"bytes\"";
    private static final byte[] LINE_SEPARATOR = System.getProperty("line.separator").getBytes();

    @Override
    public String getName() {
        return "totext";
    }

    @Override
    public String getShortDescription() {
        return "Converts an Avro data file to a text file.";
    }

    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser p = new OptionParser();
        OptionSet opts = p.parse(args.toArray(new String[0]));
        if (opts.nonOptionArguments().size() != 2) {
            err.println("Expected 2 args: from_file to_file (local filenames, Hadoop URI's, or '-' for stdin/stdout");
            p.printHelpOn(err);
            return 1;
        }
        BufferedInputStream inStream = Util.fileOrStdin(args.get(0), stdin);
        BufferedOutputStream outStream = Util.fileOrStdout(args.get(1), out);
        GenericDatumReader reader = new GenericDatumReader();
        DataFileStream fileReader = new DataFileStream(inStream, reader);
        if (!fileReader.getSchema().equals(Schema.parse(TEXT_FILE_SCHEMA))) {
            err.println("Avro file is not generic text schema");
            p.printHelpOn(err);
            return 1;
        }
        while (fileReader.hasNext()) {
            ByteBuffer outBuff = (ByteBuffer)fileReader.next();
            outStream.write(outBuff.array());
            outStream.write(LINE_SEPARATOR);
        }
        outStream.close();
        inStream.close();
        return 0;
    }
}

