/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.avro.mapred.AvroAsTextRecordReader;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class AvroAsTextInputFormat
extends FileInputFormat<Text, Text> {
    @Override
    protected FileStatus[] listStatus(JobConf job) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        for (FileStatus file : super.listStatus(job)) {
            if (!file.getPath().getName().endsWith(".avro")) continue;
            result.add(file);
        }
        return result.toArray(new FileStatus[0]);
    }

    @Override
    public RecordReader<Text, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(split.toString());
        return new AvroAsTextRecordReader(job, (FileSplit)split);
    }
}

