/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.IOException;
import org.apache.avro.mapred.AvroCollector;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroMapper;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapred.Pair;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;

class HadoopMapper<IN, OUT, K, V, KO, VO>
extends MapReduceBase
implements Mapper<AvroWrapper<IN>, NullWritable, KO, VO> {
    private AvroMapper<IN, OUT> mapper;
    private MapCollector out;
    private boolean isMapOnly;

    HadoopMapper() {
    }

    @Override
    public void configure(JobConf conf) {
        this.mapper = ReflectionUtils.newInstance(conf.getClass("avro.mapper", AvroMapper.class, AvroMapper.class), conf);
        this.isMapOnly = conf.getNumReduceTasks() == 0;
    }

    @Override
    public void map(AvroWrapper<IN> wrapper, NullWritable value, OutputCollector<KO, VO> collector, Reporter reporter) throws IOException {
        if (this.out == null) {
            this.out = new MapCollector(collector);
        }
        this.mapper.map(wrapper.datum(), this.out, reporter);
    }

    @Override
    public void close() throws IOException {
        this.mapper.close();
    }

    private class MapCollector
    extends AvroCollector<OUT> {
        private final AvroWrapper<OUT> wrapper = new AvroWrapper<Object>(null);
        private final AvroKey<K> keyWrapper = new AvroKey<Object>(null);
        private final AvroValue<V> valueWrapper = new AvroValue<Object>(null);
        private OutputCollector<KO, VO> collector;

        public MapCollector(OutputCollector<KO, VO> collector) {
            this.collector = collector;
        }

        @Override
        public void collect(OUT datum) throws IOException {
            if (HadoopMapper.this.isMapOnly) {
                this.wrapper.datum(datum);
                this.collector.collect(this.wrapper, NullWritable.get());
            } else {
                Pair pair = (Pair)datum;
                this.keyWrapper.datum(pair.key());
                this.valueWrapper.datum(pair.value());
                this.collector.collect(this.keyWrapper, this.valueWrapper);
            }
        }
    }
}

