/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.avro.Schema;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.util.ReflectionUtils;

public class AvroMultipleOutputs {
    private static final String MULTIPLE_OUTPUTS = "avro.mapreduce.multipleoutputs";
    private static final String MO_PREFIX = "avro.mapreduce.multipleoutputs.namedOutput.";
    private static final String FORMAT = ".format";
    private static final String COUNTERS_ENABLED = "avro.mapreduce.multipleoutputs.counters";
    private static final String COUNTERS_GROUP = AvroMultipleOutputs.class.getName();
    private Map<String, TaskAttemptContext> taskContexts = new HashMap<String, TaskAttemptContext>();
    private TaskInputOutputContext<?, ?, ?, ?> context;
    private Set<String> namedOutputs;
    private Map<String, RecordWriter<?, ?>> recordWriters;
    private boolean countersEnabled;

    private static void checkTokenName(String namedOutput) {
        if (namedOutput == null || namedOutput.length() == 0) {
            throw new IllegalArgumentException("Name cannot be NULL or empty");
        }
        for (char ch : namedOutput.toCharArray()) {
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') continue;
            throw new IllegalArgumentException("Name cannot have a '" + ch + "' char");
        }
    }

    private static void checkBaseOutputPath(String outputPath) {
        if (outputPath.equals("part")) {
            throw new IllegalArgumentException("output name cannot be 'part'");
        }
    }

    private static void checkNamedOutputName(JobContext job, String namedOutput, boolean alreadyDefined) {
        AvroMultipleOutputs.checkTokenName(namedOutput);
        AvroMultipleOutputs.checkBaseOutputPath(namedOutput);
        List<String> definedChannels = AvroMultipleOutputs.getNamedOutputsList(job);
        if (alreadyDefined && definedChannels.contains(namedOutput)) {
            throw new IllegalArgumentException("Named output '" + namedOutput + "' already alreadyDefined");
        }
        if (!alreadyDefined && !definedChannels.contains(namedOutput)) {
            throw new IllegalArgumentException("Named output '" + namedOutput + "' not defined");
        }
    }

    private static List<String> getNamedOutputsList(JobContext job) {
        ArrayList<String> names = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(job.getConfiguration().get(MULTIPLE_OUTPUTS, ""), " ");
        while (st.hasMoreTokens()) {
            names.add(st.nextToken());
        }
        return names;
    }

    private static Class<? extends OutputFormat<?, ?>> getNamedOutputFormatClass(JobContext job, String namedOutput) {
        return job.getConfiguration().getClass(MO_PREFIX + namedOutput + FORMAT, null, OutputFormat.class);
    }

    public static void addNamedOutput(Job job, String namedOutput, Class<? extends OutputFormat> outputFormatClass, Schema keySchema) {
        AvroMultipleOutputs.addNamedOutput(job, namedOutput, outputFormatClass, keySchema, null);
    }

    public static void addNamedOutput(Job job, String namedOutput, Class<? extends OutputFormat> outputFormatClass, Schema keySchema, Schema valueSchema) {
        AvroMultipleOutputs.checkNamedOutputName(job, namedOutput, true);
        Configuration conf = job.getConfiguration();
        conf.set(MULTIPLE_OUTPUTS, conf.get(MULTIPLE_OUTPUTS, "") + " " + namedOutput);
        conf.setClass(MO_PREFIX + namedOutput + FORMAT, outputFormatClass, OutputFormat.class);
        conf.set(MO_PREFIX + namedOutput + ".keyschema", keySchema.toString());
        if (valueSchema != null) {
            conf.set(MO_PREFIX + namedOutput + ".valueschema", valueSchema.toString());
        }
    }

    public static void setCountersEnabled(Job job, boolean enabled) {
        job.getConfiguration().setBoolean(COUNTERS_ENABLED, enabled);
    }

    public static boolean getCountersEnabled(JobContext job) {
        return job.getConfiguration().getBoolean(COUNTERS_ENABLED, false);
    }

    public AvroMultipleOutputs(TaskInputOutputContext<?, ?, ?, ?> context) {
        this.context = context;
        this.namedOutputs = Collections.unmodifiableSet(new HashSet<String>(AvroMultipleOutputs.getNamedOutputsList(context)));
        this.recordWriters = new HashMap();
        this.countersEnabled = AvroMultipleOutputs.getCountersEnabled(context);
    }

    public void write(String namedOutput, Object key) throws IOException, InterruptedException {
        this.write(namedOutput, key, NullWritable.get(), namedOutput);
    }

    public void write(String namedOutput, Object key, Object value) throws IOException, InterruptedException {
        this.write(namedOutput, key, value, namedOutput);
    }

    public void write(String namedOutput, Object key, Object value, String baseOutputPath) throws IOException, InterruptedException {
        AvroMultipleOutputs.checkNamedOutputName(this.context, namedOutput, false);
        AvroMultipleOutputs.checkBaseOutputPath(baseOutputPath);
        if (!this.namedOutputs.contains(namedOutput)) {
            throw new IllegalArgumentException("Undefined named output '" + namedOutput + "'");
        }
        TaskAttemptContext taskContext = this.getContext(namedOutput);
        this.getRecordWriter(taskContext, baseOutputPath).write(key, value);
    }

    public void write(Object key, Object value, String baseOutputPath) throws IOException, InterruptedException {
        this.write(key, value, null, null, baseOutputPath);
    }

    public void write(Object key, Object value, Schema keySchema, Schema valSchema, String baseOutputPath) throws IOException, InterruptedException {
        AvroMultipleOutputs.checkBaseOutputPath(baseOutputPath);
        Job job = new Job(this.context.getConfiguration());
        this.setSchema(job, keySchema, valSchema);
        TaskAttemptContext taskContext = this.createTaskAttemptContext(job.getConfiguration(), this.context.getTaskAttemptID());
        this.getRecordWriter(taskContext, baseOutputPath).write(key, value);
    }

    private synchronized RecordWriter getRecordWriter(TaskAttemptContext taskContext, String baseFileName) throws IOException, InterruptedException {
        RecordWriterWithCounter writer = this.recordWriters.get(baseFileName);
        if (writer == null) {
            taskContext.getConfiguration().set("avro.mo.config.namedOutput", baseFileName);
            try {
                writer = ReflectionUtils.newInstance(taskContext.getOutputFormatClass(), taskContext.getConfiguration()).getRecordWriter(taskContext);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            if (this.countersEnabled) {
                writer = new RecordWriterWithCounter(writer, baseFileName, this.context);
            }
            this.recordWriters.put(baseFileName, writer);
        }
        return writer;
    }

    private void setSchema(Job job, Schema keySchema, Schema valSchema) {
        boolean isMaponly;
        boolean bl = isMaponly = job.getNumReduceTasks() == 0;
        if (keySchema != null) {
            if (isMaponly) {
                AvroJob.setMapOutputKeySchema(job, keySchema);
            } else {
                AvroJob.setOutputKeySchema(job, keySchema);
            }
        }
        if (valSchema != null) {
            if (isMaponly) {
                AvroJob.setMapOutputValueSchema(job, valSchema);
            } else {
                AvroJob.setOutputValueSchema(job, valSchema);
            }
        }
    }

    private TaskAttemptContext getContext(String nameOutput) throws IOException {
        TaskAttemptContext taskContext = this.taskContexts.get(nameOutput);
        if (taskContext != null) {
            return taskContext;
        }
        Job job = new Job(this.context.getConfiguration());
        job.setOutputFormatClass(AvroMultipleOutputs.getNamedOutputFormatClass(this.context, nameOutput));
        Schema keySchema = null;
        Schema valSchema = null;
        if (job.getConfiguration().get(MO_PREFIX + nameOutput + ".keyschema", null) != null) {
            keySchema = Schema.parse(job.getConfiguration().get(MO_PREFIX + nameOutput + ".keyschema"));
        }
        if (job.getConfiguration().get(MO_PREFIX + nameOutput + ".valueschema", null) != null) {
            valSchema = Schema.parse(job.getConfiguration().get(MO_PREFIX + nameOutput + ".valueschema"));
        }
        this.setSchema(job, keySchema, valSchema);
        taskContext = this.createTaskAttemptContext(job.getConfiguration(), this.context.getTaskAttemptID());
        this.taskContexts.put(nameOutput, taskContext);
        return taskContext;
    }

    private TaskAttemptContext createTaskAttemptContext(Configuration conf, TaskAttemptID taskId) {
        try {
            Class<?> c = this.getTaskAttemptContextClass();
            Constructor<?> cons = c.getConstructor(Configuration.class, TaskAttemptID.class);
            return (TaskAttemptContext)cons.newInstance(conf, taskId);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Class<?> getTaskAttemptContextClass() {
        try {
            return Class.forName("org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl");
        }
        catch (Exception e) {
            try {
                return Class.forName("org.apache.hadoop.mapreduce.TaskAttemptContext");
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public void close() throws IOException, InterruptedException {
        for (RecordWriter<?, ?> writer : this.recordWriters.values()) {
            writer.close(this.context);
        }
    }

    private static class RecordWriterWithCounter
    extends RecordWriter {
        private RecordWriter writer;
        private String counterName;
        private TaskInputOutputContext context;

        public RecordWriterWithCounter(RecordWriter writer, String counterName, TaskInputOutputContext context) {
            this.writer = writer;
            this.counterName = counterName;
            this.context = context;
        }

        public void write(Object key, Object value) throws IOException, InterruptedException {
            this.context.getCounter(COUNTERS_GROUP, this.counterName).increment(1L);
            this.writer.write(key, value);
        }

        @Override
        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.writer.close(context);
        }
    }
}

