/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.avro.tool.BinaryFragmentToJsonTool;
import org.apache.avro.tool.ConcatTool;
import org.apache.avro.tool.DataFileGetMetaTool;
import org.apache.avro.tool.DataFileGetSchemaTool;
import org.apache.avro.tool.DataFileReadTool;
import org.apache.avro.tool.DataFileWriteTool;
import org.apache.avro.tool.FromTextTool;
import org.apache.avro.tool.IdlTool;
import org.apache.avro.tool.InduceSchemaTool;
import org.apache.avro.tool.JsonToBinaryFragmentTool;
import org.apache.avro.tool.RecodecTool;
import org.apache.avro.tool.RpcProtocolTool;
import org.apache.avro.tool.RpcReceiveTool;
import org.apache.avro.tool.RpcSendTool;
import org.apache.avro.tool.SpecificCompilerTool;
import org.apache.avro.tool.TetherTool;
import org.apache.avro.tool.ToTextTool;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.TrevniCreateRandomTool;
import org.apache.avro.tool.TrevniMetadataTool;
import org.apache.avro.tool.TrevniToJsonTool;

public class Main {
    final Map<String, Tool> tools = new TreeMap<String, Tool>();
    int maxLen = 0;

    Main() {
        for (Tool tool : new Tool[]{new SpecificCompilerTool(), new InduceSchemaTool(), new JsonToBinaryFragmentTool(), new BinaryFragmentToJsonTool(), new DataFileReadTool(), new DataFileWriteTool(), new DataFileGetMetaTool(), new DataFileGetSchemaTool(), new IdlTool(), new RecodecTool(), new ConcatTool(), new RpcReceiveTool(), new RpcSendTool(), new RpcProtocolTool(), new FromTextTool(), new ToTextTool(), new TetherTool(), new TrevniCreateRandomTool(), new TrevniMetadataTool(), new TrevniToJsonTool()}) {
            Tool prev = this.tools.put(tool.getName(), tool);
            if (prev != null) {
                throw new AssertionError((Object)("Two tools with identical names: " + tool + ", " + prev));
            }
            this.maxLen = Math.max(tool.getName().length(), this.maxLen);
        }
    }

    public static void main(String[] args) throws Exception {
        int rc = new Main().run(args);
        System.exit(rc);
    }

    private int run(String[] args) throws Exception {
        Tool tool;
        if (args.length != 0 && (tool = this.tools.get(args[0])) != null) {
            return tool.run(System.in, System.out, System.err, Arrays.asList(args).subList(1, args.length));
        }
        System.err.print("Version ");
        Main.printStream(Main.class.getClassLoader().getResourceAsStream("VERSION.txt"));
        System.err.print(" of ");
        Main.printStream(Main.class.getClassLoader().getResourceAsStream("NOTICE.txt"));
        System.err.println("----------------");
        System.err.println("Available tools:");
        for (Tool k : this.tools.values()) {
            System.err.printf("%" + this.maxLen + "s  %s\n", k.getName(), k.getShortDescription());
        }
        return 1;
    }

    private static void printStream(InputStream in) throws Exception {
        byte[] buffer = new byte[1024];
        int i = in.read(buffer);
        while (i != -1) {
            System.err.write(buffer, 0, i);
            i = in.read(buffer);
        }
    }
}

