/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclUtil;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.ScopedAclEntries;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AclTransformation;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;

@InterfaceAudience.Private
final class AclStorage {
    public static void copyINodeDefaultAcl(INode child) {
        FsPermission newPerm;
        List<AclEntry> defaultEntries;
        INodeDirectory parent = child.getParent();
        AclFeature parentAclFeature = parent.getAclFeature();
        if (parentAclFeature == null || !child.isFile() && !child.isDirectory()) {
            return;
        }
        ImmutableList<AclEntry> featureEntries = parent.getAclFeature().getEntries();
        ScopedAclEntries scopedEntries = new ScopedAclEntries(featureEntries);
        List<AclEntry> parentDefaultEntries = scopedEntries.getDefaultEntries();
        if (parentDefaultEntries.isEmpty()) {
            return;
        }
        ArrayList<AclEntry> accessEntries = Lists.newArrayListWithCapacity(parentDefaultEntries.size());
        FsPermission childPerm = child.getFsPermission();
        boolean parentDefaultIsMinimal = AclUtil.isMinimalAcl(parentDefaultEntries);
        for (AclEntry entry : parentDefaultEntries) {
            AclEntryType type = entry.getType();
            String name = entry.getName();
            AclEntry.Builder builder = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(type).setName(name);
            FsAction permission = type == AclEntryType.USER && name == null ? entry.getPermission().and(childPerm.getUserAction()) : (type == AclEntryType.GROUP && parentDefaultIsMinimal ? entry.getPermission().and(childPerm.getGroupAction()) : (type == AclEntryType.MASK ? entry.getPermission().and(childPerm.getGroupAction()) : (type == AclEntryType.OTHER ? entry.getPermission().and(childPerm.getOtherAction()) : entry.getPermission())));
            builder.setPermission(permission);
            accessEntries.add(builder.build());
        }
        List<AclEntry> list = defaultEntries = child.isDirectory() ? parentDefaultEntries : Collections.emptyList();
        if (!AclUtil.isMinimalAcl(accessEntries) || !defaultEntries.isEmpty()) {
            child.addAclFeature(AclStorage.createAclFeature(accessEntries, defaultEntries));
            newPerm = AclStorage.createFsPermissionForExtendedAcl(accessEntries, childPerm);
        } else {
            newPerm = AclStorage.createFsPermissionForMinimalAcl(accessEntries, childPerm);
        }
        child.setPermission(newPerm);
    }

    public static List<AclEntry> readINodeAcl(INode inode, int snapshotId) {
        AclFeature f = inode.getAclFeature(snapshotId);
        return f == null ? ImmutableList.of() : f.getEntries();
    }

    public static List<AclEntry> readINodeLogicalAcl(INode inode) {
        FsPermission perm = inode.getFsPermission();
        AclFeature f = inode.getAclFeature();
        if (f == null) {
            return AclUtil.getMinimalAcl(perm);
        }
        ImmutableList<AclEntry> featureEntries = f.getEntries();
        ScopedAclEntries scoped = new ScopedAclEntries(featureEntries);
        List<AclEntry> accessEntries = scoped.getAccessEntries();
        List<AclEntry> defaultEntries = scoped.getDefaultEntries();
        ArrayList<AclEntry> existingAcl = Lists.newArrayListWithCapacity(featureEntries.size() + 3);
        if (!accessEntries.isEmpty()) {
            existingAcl.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).setPermission(perm.getUserAction()).build());
            existingAcl.addAll(accessEntries);
            existingAcl.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.MASK).setPermission(perm.getGroupAction()).build());
            existingAcl.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.OTHER).setPermission(perm.getOtherAction()).build());
        } else {
            existingAcl.addAll(AclUtil.getMinimalAcl(perm));
        }
        existingAcl.addAll(defaultEntries);
        return existingAcl;
    }

    public static void removeINodeAcl(INode inode, int snapshotId) throws QuotaExceededException {
        AclFeature f = inode.getAclFeature();
        if (f == null) {
            return;
        }
        FsPermission perm = inode.getFsPermission();
        ImmutableList<AclEntry> featureEntries = f.getEntries();
        if (((AclEntry)featureEntries.get(0)).getScope() == AclEntryScope.ACCESS) {
            AclEntry groupEntryKey = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.GROUP).build();
            int groupEntryIndex = Collections.binarySearch(featureEntries, groupEntryKey, AclTransformation.ACL_ENTRY_COMPARATOR);
            assert (groupEntryIndex >= 0);
            FsAction groupPerm = ((AclEntry)featureEntries.get(groupEntryIndex)).getPermission();
            FsPermission newPerm = new FsPermission(perm.getUserAction(), groupPerm, perm.getOtherAction(), perm.getStickyBit());
            inode.setPermission(newPerm, snapshotId);
        }
        inode.removeAclFeature(snapshotId);
    }

    public static void updateINodeAcl(INode inode, List<AclEntry> newAcl, int snapshotId) throws AclException, QuotaExceededException {
        FsPermission newPerm;
        assert (newAcl.size() >= 3);
        FsPermission perm = inode.getFsPermission();
        if (!AclUtil.isMinimalAcl(newAcl)) {
            ScopedAclEntries scoped = new ScopedAclEntries(newAcl);
            List<AclEntry> accessEntries = scoped.getAccessEntries();
            List<AclEntry> defaultEntries = scoped.getDefaultEntries();
            if (!defaultEntries.isEmpty() && !inode.isDirectory()) {
                throw new AclException("Invalid ACL: only directories may have a default ACL.");
            }
            if (inode.getAclFeature() != null) {
                inode.removeAclFeature(snapshotId);
            }
            inode.addAclFeature(AclStorage.createAclFeature(accessEntries, defaultEntries), snapshotId);
            newPerm = AclStorage.createFsPermissionForExtendedAcl(accessEntries, perm);
        } else {
            if (inode.getAclFeature() != null) {
                inode.removeAclFeature(snapshotId);
            }
            newPerm = AclStorage.createFsPermissionForMinimalAcl(newAcl, perm);
        }
        inode.setPermission(newPerm, snapshotId);
    }

    private AclStorage() {
    }

    private static AclFeature createAclFeature(List<AclEntry> accessEntries, List<AclEntry> defaultEntries) {
        ArrayList<AclEntry> featureEntries = Lists.newArrayListWithCapacity(accessEntries.size() - 3 + defaultEntries.size());
        if (!AclUtil.isMinimalAcl(accessEntries)) {
            featureEntries.addAll(accessEntries.subList(1, accessEntries.size() - 2));
        }
        featureEntries.addAll(defaultEntries);
        return new AclFeature(ImmutableList.copyOf(featureEntries));
    }

    private static FsPermission createFsPermissionForExtendedAcl(List<AclEntry> accessEntries, FsPermission existingPerm) {
        return new FsPermission(accessEntries.get(0).getPermission(), accessEntries.get(accessEntries.size() - 2).getPermission(), accessEntries.get(accessEntries.size() - 1).getPermission(), existingPerm.getStickyBit());
    }

    private static FsPermission createFsPermissionForMinimalAcl(List<AclEntry> accessEntries, FsPermission existingPerm) {
        return new FsPermission(accessEntries.get(0).getPermission(), accessEntries.get(1).getPermission(), accessEntries.get(2).getPermission(), existingPerm.getStickyBit());
    }
}

