/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net.unix;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.util.NativeCodeLoader;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
public final class DomainSocketWatcher
implements Closeable {
    static Log LOG;
    private static final String loadingFailureReason;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition processedCond = this.lock.newCondition();
    private final LinkedList<Entry> toAdd = new LinkedList();
    private final TreeMap<Integer, DomainSocket> toRemove = new TreeMap();
    private final int interruptCheckPeriodMs;
    private final DomainSocket[] notificationSockets;
    private boolean closed = false;
    @VisibleForTesting
    final Thread watcherThread = new Thread(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (DomainSocketWatcher.LOG.isDebugEnabled()) {
                DomainSocketWatcher.LOG.debug(this + ": starting with interruptCheckPeriodMs = " + DomainSocketWatcher.access$100(DomainSocketWatcher.this));
            }
            entries = new TreeMap<Integer, Entry>();
            fdSet = new FdSet();
            DomainSocketWatcher.access$200(DomainSocketWatcher.this, entries, fdSet);
            while (true) {
                try {
                    DomainSocketWatcher.access$300(DomainSocketWatcher.this).lock();
                    for (int fd : fdSet.getAndClearReadableFds()) {
                        DomainSocketWatcher.access$400(DomainSocketWatcher.this, "getAndClearReadableFds", entries, fdSet, fd);
                    }
                    if (!DomainSocketWatcher.access$500(DomainSocketWatcher.this).isEmpty() || !DomainSocketWatcher.access$600(DomainSocketWatcher.this).isEmpty()) {
                        iter = DomainSocketWatcher.access$500(DomainSocketWatcher.this).iterator();
                        while (iter.hasNext()) {
                            entry = (Entry)iter.next();
                            sock = entry.getDomainSocket();
                            prevEntry = entries.put(sock.fd, entry);
                            Preconditions.checkState(prevEntry == null, this + ": tried to watch a file descriptor that we " + "were already watching: " + sock);
                            if (DomainSocketWatcher.LOG.isTraceEnabled()) {
                                DomainSocketWatcher.LOG.trace(this + ": adding fd " + sock.fd);
                            }
                            fdSet.add(sock.fd);
                            iter.remove();
                        }
                        while (true) {
                            if ((entry = DomainSocketWatcher.access$600(DomainSocketWatcher.this).firstEntry()) == null) {
                                DomainSocketWatcher.access$700(DomainSocketWatcher.this).signalAll();
                                break;
                            }
                            DomainSocketWatcher.access$400(DomainSocketWatcher.this, "handlePendingRemovals", entries, fdSet, ((DomainSocket)entry.getValue()).fd);
                        }
                    }
                    if (!DomainSocketWatcher.access$000(DomainSocketWatcher.this)) ** GOTO lbl75
                    if (DomainSocketWatcher.LOG.isDebugEnabled()) {
                        DomainSocketWatcher.LOG.debug(this.toString() + " thread terminating.");
                    }
                    DomainSocketWatcher.access$300(DomainSocketWatcher.this).unlock();
                    ** GOTO lbl65
                }
                catch (InterruptedException e) {
                    DomainSocketWatcher.LOG.info(this.toString() + " terminating on InterruptedException");
                    DomainSocketWatcher.access$900(DomainSocketWatcher.this);
                    i$ = entries.values().iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                            entries.clear();
                            fdSet.close();
                            return;
                        }
                        entry = (Entry)i$.next();
                        DomainSocketWatcher.access$400(DomainSocketWatcher.this, "close", entries, fdSet, entry.getDomainSocket().fd);
                    }
                }
                catch (IOException e) {
                    block29: {
                        try {
                            DomainSocketWatcher.LOG.error(this.toString() + " terminating on IOException", e);
                        }
                        catch (Throwable var8_18) {
                            DomainSocketWatcher.access$900(DomainSocketWatcher.this);
                            i$ = entries.values().iterator();
                            while (true) {
                                if (!i$.hasNext()) {
                                    entries.clear();
                                    fdSet.close();
                                    throw var8_18;
                                }
                                entry = (Entry)i$.next();
                                DomainSocketWatcher.access$400(DomainSocketWatcher.this, "close", entries, fdSet, entry.getDomainSocket().fd);
                            }
                        }
lbl65:
                        // 1 sources

                        DomainSocketWatcher.access$900(DomainSocketWatcher.this);
                        i$ = entries.values().iterator();
                        while (true) {
                            if (!i$.hasNext()) {
                                entries.clear();
                                fdSet.close();
                                return;
                            }
                            entry = (Entry)i$.next();
                            DomainSocketWatcher.access$400(DomainSocketWatcher.this, "close", entries, fdSet, entry.getDomainSocket().fd);
                        }
lbl75:
                        // 1 sources

                        ** try [egrp 4[TRYBLOCK] [1 : 501->515)] { 
lbl76:
                        // 1 sources

                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        break block29;
lbl79:
                        // 1 sources

                        finally {
                            DomainSocketWatcher.access$300(DomainSocketWatcher.this).unlock();
                        }
                    }
                    DomainSocketWatcher.access$800(DomainSocketWatcher.access$100(DomainSocketWatcher.this), fdSet);
                    continue;
                    DomainSocketWatcher.access$900(DomainSocketWatcher.this);
                    i$ = entries.values().iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                            entries.clear();
                            fdSet.close();
                            return;
                        }
                        entry = (Entry)i$.next();
                        DomainSocketWatcher.access$400(DomainSocketWatcher.this, "close", entries, fdSet, entry.getDomainSocket().fd);
                    }
                }
                break;
            }
        }
    });

    private static native void anchorNative();

    public static String getLoadingFailureReason() {
        return loadingFailureReason;
    }

    public DomainSocketWatcher(int interruptCheckPeriodMs) throws IOException {
        if (loadingFailureReason != null) {
            throw new UnsupportedOperationException(loadingFailureReason);
        }
        Preconditions.checkArgument(interruptCheckPeriodMs > 0);
        this.interruptCheckPeriodMs = interruptCheckPeriodMs;
        this.notificationSockets = DomainSocket.socketpair();
        this.watcherThread.setDaemon(true);
        this.watcherThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + ": closing");
            }
            this.closed = true;
        }
        finally {
            this.lock.unlock();
        }
        this.notificationSockets[0].close();
        Uninterruptibles.joinUninterruptibly(this.watcherThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean isClosed() {
        this.lock.lock();
        try {
            boolean bl = this.closed;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DomainSocket sock, Handler handler) {
        this.lock.lock();
        try {
            if (this.closed) {
                handler.handle(sock);
                IOUtils.cleanup(LOG, sock);
                return;
            }
            Entry entry = new Entry(sock, handler);
            try {
                sock.refCount.reference();
            }
            catch (ClosedChannelException e1) {
                handler.handle(sock);
                this.lock.unlock();
                return;
            }
            this.toAdd.add(entry);
            this.kick();
            do {
                try {
                    this.processedCond.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } while (this.toAdd.contains(entry));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DomainSocket sock) {
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            this.toRemove.put(sock.fd, sock);
            this.kick();
            do {
                try {
                    this.processedCond.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } while (this.toRemove.containsKey(sock.fd));
        }
        finally {
            this.lock.unlock();
        }
    }

    private void kick() {
        block2: {
            try {
                this.notificationSockets[0].getOutputStream().write(0);
            }
            catch (IOException e) {
                if (this.closed) break block2;
                LOG.error(this + ": error writing to notificationSockets[0]", e);
            }
        }
    }

    private void sendCallback(String caller, TreeMap<Integer, Entry> entries, FdSet fdSet, int fd) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this + ": " + caller + " starting sendCallback for fd " + fd);
        }
        Entry entry = entries.get(fd);
        Preconditions.checkNotNull(entry, this + ": fdSet contained " + fd + ", which we were " + "not tracking.");
        DomainSocket sock = entry.getDomainSocket();
        if (entry.getHandler().handle(sock)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(this + ": " + caller + ": closing fd " + fd + " at the request of the handler.");
            }
            if (this.toRemove.remove(fd) != null && LOG.isTraceEnabled()) {
                LOG.trace(this + ": " + caller + " : sendCallback processed fd " + fd + " in toRemove.");
            }
            try {
                sock.refCount.unreferenceCheckClosed();
            }
            catch (IOException e) {
                Preconditions.checkArgument(false, this + ": file descriptor " + sock.fd + " was closed while " + "still in the poll(2) loop.");
            }
            IOUtils.cleanup(LOG, sock);
            entries.remove(fd);
            fdSet.remove(fd);
        } else if (LOG.isTraceEnabled()) {
            LOG.trace(this + ": " + caller + ": sendCallback not " + "closing fd " + fd);
        }
    }

    private void addNotificationSocket(TreeMap<Integer, Entry> entries, FdSet fdSet) {
        entries.put(this.notificationSockets[1].fd, new Entry(this.notificationSockets[1], new NotificationHandler()));
        try {
            this.notificationSockets[1].refCount.reference();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        fdSet.add(this.notificationSockets[1].fd);
        if (LOG.isTraceEnabled()) {
            LOG.trace(this + ": adding notificationSocket " + this.notificationSockets[1].fd + ", connected to " + this.notificationSockets[0].fd);
        }
    }

    public String toString() {
        return "DomainSocketWatcher(" + System.identityHashCode(this) + ")";
    }

    private static native int doPoll0(int var0, FdSet var1) throws IOException;

    static /* synthetic */ int access$100(DomainSocketWatcher x0) {
        return x0.interruptCheckPeriodMs;
    }

    static /* synthetic */ void access$200(DomainSocketWatcher x0, TreeMap x1, FdSet x2) {
        x0.addNotificationSocket(x1, x2);
    }

    static /* synthetic */ ReentrantLock access$300(DomainSocketWatcher x0) {
        return x0.lock;
    }

    static /* synthetic */ void access$400(DomainSocketWatcher x0, String x1, TreeMap x2, FdSet x3, int x4) {
        x0.sendCallback(x1, x2, x3, x4);
    }

    static /* synthetic */ LinkedList access$500(DomainSocketWatcher x0) {
        return x0.toAdd;
    }

    static /* synthetic */ TreeMap access$600(DomainSocketWatcher x0) {
        return x0.toRemove;
    }

    static /* synthetic */ Condition access$700(DomainSocketWatcher x0) {
        return x0.processedCond;
    }

    static /* synthetic */ boolean access$000(DomainSocketWatcher x0) {
        return x0.closed;
    }

    static /* synthetic */ int access$800(int x0, FdSet x1) throws IOException {
        return DomainSocketWatcher.doPoll0(x0, x1);
    }

    static /* synthetic */ void access$900(DomainSocketWatcher x0) {
        x0.kick();
    }

    static {
        if (SystemUtils.IS_OS_WINDOWS) {
            loadingFailureReason = "UNIX Domain sockets are not available on Windows.";
        } else if (!NativeCodeLoader.isNativeCodeLoaded()) {
            loadingFailureReason = "libhadoop cannot be loaded.";
        } else {
            String problem;
            try {
                DomainSocketWatcher.anchorNative();
                problem = null;
            }
            catch (Throwable t) {
                problem = "DomainSocketWatcher#anchorNative got error: " + t.getMessage();
            }
            loadingFailureReason = problem;
        }
        LOG = LogFactory.getLog(DomainSocketWatcher.class);
    }

    private static class FdSet {
        private long data = FdSet.alloc0();

        private static native long alloc0();

        FdSet() {
        }

        native void add(int var1);

        native void remove(int var1);

        native int[] getAndClearReadableFds();

        native void close();
    }

    private static class Entry {
        final DomainSocket socket;
        final Handler handler;

        Entry(DomainSocket socket, Handler handler) {
            this.socket = socket;
            this.handler = handler;
        }

        DomainSocket getDomainSocket() {
            return this.socket;
        }

        Handler getHandler() {
            return this.handler;
        }
    }

    private class NotificationHandler
    implements Handler {
        private NotificationHandler() {
        }

        @Override
        public boolean handle(DomainSocket sock) {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this + ": NotificationHandler: doing a read on " + sock.fd);
                }
                if (sock.getInputStream().read() == -1) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(this + ": NotificationHandler: got EOF on " + sock.fd);
                    }
                    throw new EOFException();
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this + ": NotificationHandler: read succeeded on " + sock.fd);
                }
                return false;
            }
            catch (IOException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this + ": NotificationHandler: setting closed to " + "true for " + sock.fd);
                }
                DomainSocketWatcher.this.closed = true;
                return true;
            }
        }
    }

    public static interface Handler {
        public boolean handle(DomainSocket var1);
    }
}

