/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.avro.AvroColumnReader;
import org.apache.trevni.avro.AvroColumnWriter;
import org.junit.Assert;
import org.junit.Test;

public class TestCases {
    private static final File DIR = new File("src/test/cases/");
    private static final File FILE = new File("target", "case.trv");

    @Test
    public void testCases() throws Exception {
        for (File f : DIR.listFiles()) {
            if (!f.isDirectory() || f.getName().startsWith(".")) continue;
            this.runCase(f);
        }
    }

    private void runCase(File dir) throws Exception {
        Schema schema = Schema.parse(new File(dir, "input.avsc"));
        List<Object> data = this.fromJson(schema, new File(dir, "input.json"));
        AvroColumnWriter<Object> writer = new AvroColumnWriter<Object>(schema, new ColumnFileMetaData());
        for (Object datum : data) {
            writer.write(datum);
        }
        writer.writeTo(FILE);
        this.checkRead(schema, data);
        for (File f : dir.listFiles()) {
            if (!f.isDirectory() || f.getName().startsWith(".")) continue;
            Schema s = Schema.parse(new File(f, "sub.avsc"));
            this.checkRead(s, this.fromJson(s, new File(f, "sub.json")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRead(Schema s, List<Object> data) throws Exception {
        AvroColumnReader reader = new AvroColumnReader(new AvroColumnReader.Params(FILE).setSchema(s));
        try {
            for (Object datum : data) {
                Assert.assertEquals((Object)datum, reader.next());
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> fromJson(Schema schema, File file) throws Exception {
        FileInputStream in = new FileInputStream(file);
        ArrayList<Object> data = new ArrayList<Object>();
        try {
            try {
                GenericDatumReader<Object> reader = new GenericDatumReader<Object>(schema);
                JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, in);
                while (true) {
                    data.add(reader.read(null, decoder));
                }
            }
            catch (EOFException eOFException) {
                ((InputStream)in).close();
            }
        }
        catch (Throwable throwable) {
            ((InputStream)in).close();
            throw throwable;
        }
        return data;
    }
}

