/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import org.jboss.netty.handler.codec.spdy.DefaultSpdyGoAwayFrame;
import org.jboss.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import org.jboss.netty.handler.codec.spdy.DefaultSpdyPingFrame;
import org.jboss.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import org.jboss.netty.handler.codec.spdy.DefaultSpdySettingsFrame;
import org.jboss.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import org.jboss.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import org.jboss.netty.handler.codec.spdy.DefaultSpdyWindowUpdateFrame;
import org.jboss.netty.handler.codec.spdy.SpdyCodecUtil;
import org.jboss.netty.handler.codec.spdy.SpdyHeaderBlock;
import org.jboss.netty.handler.codec.spdy.SpdyHeaderBlockDecompressor;
import org.jboss.netty.handler.codec.spdy.SpdyProtocolException;
import org.jboss.netty.handler.codec.spdy.SpdySettingsFrame;

public class SpdyFrameDecoder
extends FrameDecoder {
    private final int spdyVersion;
    private final int maxChunkSize;
    private final int maxHeaderSize;
    private final SpdyHeaderBlockDecompressor headerBlockDecompressor;
    private State state;
    private SpdySettingsFrame spdySettingsFrame;
    private SpdyHeaderBlock spdyHeaderBlock;
    private byte flags;
    private int length;
    private int version;
    private int type;
    private int streamID;
    private int headerSize;
    private int numHeaders;
    private ChannelBuffer decompressed;

    @Deprecated
    public SpdyFrameDecoder() {
        this(2);
    }

    public SpdyFrameDecoder(int version) {
        this(version, 8192, 16384);
    }

    public SpdyFrameDecoder(int version, int maxChunkSize, int maxHeaderSize) {
        super(false);
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("unsupported version: " + version);
        }
        if (maxChunkSize <= 0) {
            throw new IllegalArgumentException("maxChunkSize must be a positive integer: " + maxChunkSize);
        }
        if (maxHeaderSize <= 0) {
            throw new IllegalArgumentException("maxHeaderSize must be a positive integer: " + maxHeaderSize);
        }
        this.spdyVersion = version;
        this.maxChunkSize = maxChunkSize;
        this.maxHeaderSize = maxHeaderSize;
        this.headerBlockDecompressor = SpdyHeaderBlockDecompressor.newInstance(version);
        this.state = State.READ_COMMON_HEADER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        try {
            Object object = this.decode(ctx, channel, buffer);
            return object;
        }
        finally {
            this.headerBlockDecompressor.end();
        }
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        switch (this.state) {
            case READ_COMMON_HEADER: {
                this.state = this.readCommonHeader(buffer);
                if (this.state == State.FRAME_ERROR) {
                    if (this.version != this.spdyVersion) {
                        SpdyFrameDecoder.fireProtocolException(ctx, "Unsupported version: " + this.version);
                    } else {
                        this.fireInvalidControlFrameException(ctx);
                    }
                }
                if (this.length == 0) {
                    if (this.state == State.READ_DATA_FRAME) {
                        if (this.streamID == 0) {
                            this.state = State.FRAME_ERROR;
                            SpdyFrameDecoder.fireProtocolException(ctx, "Received invalid data frame");
                            return null;
                        }
                        DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(this.streamID);
                        spdyDataFrame.setLast((this.flags & 1) != 0);
                        this.state = State.READ_COMMON_HEADER;
                        return spdyDataFrame;
                    }
                    this.state = State.READ_COMMON_HEADER;
                }
                return null;
            }
            case READ_CONTROL_FRAME: {
                try {
                    Object frame = this.readControlFrame(buffer);
                    if (frame != null) {
                        this.state = State.READ_COMMON_HEADER;
                    }
                    return frame;
                }
                catch (IllegalArgumentException e) {
                    this.state = State.FRAME_ERROR;
                    this.fireInvalidControlFrameException(ctx);
                    return null;
                }
            }
            case READ_SETTINGS_FRAME: {
                if (this.spdySettingsFrame == null) {
                    if (buffer.readableBytes() < 4) {
                        return null;
                    }
                    int numEntries = SpdyCodecUtil.getUnsignedInt(buffer, buffer.readerIndex());
                    buffer.skipBytes(4);
                    this.length -= 4;
                    if ((this.length & 7) != 0 || this.length >> 3 != numEntries) {
                        this.state = State.FRAME_ERROR;
                        this.fireInvalidControlFrameException(ctx);
                        return null;
                    }
                    this.spdySettingsFrame = new DefaultSpdySettingsFrame();
                    boolean clear = (this.flags & 1) != 0;
                    this.spdySettingsFrame.setClearPreviouslyPersistedSettings(clear);
                }
                int readableEntries = Math.min(buffer.readableBytes() >> 3, this.length >> 3);
                for (int i = 0; i < readableEntries; ++i) {
                    byte ID_flags;
                    int ID2;
                    if (this.version < 3) {
                        ID2 = buffer.readByte() & 0xFF | (buffer.readByte() & 0xFF) << 8 | (buffer.readByte() & 0xFF) << 16;
                        ID_flags = buffer.readByte();
                    } else {
                        ID_flags = buffer.readByte();
                        ID2 = SpdyCodecUtil.getUnsignedMedium(buffer, buffer.readerIndex());
                        buffer.skipBytes(3);
                    }
                    int value = SpdyCodecUtil.getSignedInt(buffer, buffer.readerIndex());
                    buffer.skipBytes(4);
                    if (ID2 == 0) {
                        this.state = State.FRAME_ERROR;
                        this.spdySettingsFrame = null;
                        this.fireInvalidControlFrameException(ctx);
                        return null;
                    }
                    if (this.spdySettingsFrame.isSet(ID2)) continue;
                    boolean persistVal = (ID_flags & 1) != 0;
                    boolean persisted = (ID_flags & 2) != 0;
                    this.spdySettingsFrame.setValue(ID2, value, persistVal, persisted);
                }
                this.length -= 8 * readableEntries;
                if (this.length == 0) {
                    this.state = State.READ_COMMON_HEADER;
                    SpdySettingsFrame frame = this.spdySettingsFrame;
                    this.spdySettingsFrame = null;
                    return frame;
                }
                return null;
            }
            case READ_HEADER_BLOCK_FRAME: {
                try {
                    this.spdyHeaderBlock = this.readHeaderBlockFrame(buffer);
                    if (this.spdyHeaderBlock != null) {
                        if (this.length == 0) {
                            this.state = State.READ_COMMON_HEADER;
                            SpdyHeaderBlock frame = this.spdyHeaderBlock;
                            this.spdyHeaderBlock = null;
                            return frame;
                        }
                        this.state = State.READ_HEADER_BLOCK;
                    }
                    return null;
                }
                catch (IllegalArgumentException e) {
                    this.state = State.FRAME_ERROR;
                    this.fireInvalidControlFrameException(ctx);
                    return null;
                }
            }
            case READ_HEADER_BLOCK: {
                int compressedBytes = Math.min(buffer.readableBytes(), this.length);
                this.length -= compressedBytes;
                try {
                    this.decodeHeaderBlock(buffer.readSlice(compressedBytes));
                }
                catch (Exception e) {
                    this.state = State.FRAME_ERROR;
                    this.spdyHeaderBlock = null;
                    this.decompressed = null;
                    Channels.fireExceptionCaught(ctx, (Throwable)e);
                    return null;
                }
                if (this.spdyHeaderBlock != null && this.spdyHeaderBlock.isInvalid()) {
                    SpdyHeaderBlock frame = this.spdyHeaderBlock;
                    this.spdyHeaderBlock = null;
                    this.decompressed = null;
                    if (this.length == 0) {
                        this.state = State.READ_COMMON_HEADER;
                    }
                    return frame;
                }
                if (this.length == 0) {
                    SpdyHeaderBlock frame = this.spdyHeaderBlock;
                    this.spdyHeaderBlock = null;
                    this.state = State.READ_COMMON_HEADER;
                    return frame;
                }
                return null;
            }
            case READ_DATA_FRAME: {
                if (this.streamID == 0) {
                    this.state = State.FRAME_ERROR;
                    SpdyFrameDecoder.fireProtocolException(ctx, "Received invalid data frame");
                    return null;
                }
                int dataLength = Math.min(this.maxChunkSize, this.length);
                if (buffer.readableBytes() < dataLength) {
                    return null;
                }
                DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(this.streamID);
                spdyDataFrame.setData(buffer.readBytes(dataLength));
                this.length -= dataLength;
                if (this.length == 0) {
                    spdyDataFrame.setLast((this.flags & 1) != 0);
                    this.state = State.READ_COMMON_HEADER;
                }
                return spdyDataFrame;
            }
            case DISCARD_FRAME: {
                int numBytes = Math.min(buffer.readableBytes(), this.length);
                buffer.skipBytes(numBytes);
                this.length -= numBytes;
                if (this.length == 0) {
                    this.state = State.READ_COMMON_HEADER;
                }
                return null;
            }
            case FRAME_ERROR: {
                buffer.skipBytes(buffer.readableBytes());
                return null;
            }
        }
        throw new Error("Shouldn't reach here.");
    }

    private State readCommonHeader(ChannelBuffer buffer) {
        if (buffer.readableBytes() < 8) {
            return State.READ_COMMON_HEADER;
        }
        int frameOffset = buffer.readerIndex();
        int flagsOffset = frameOffset + 4;
        int lengthOffset = frameOffset + 5;
        buffer.skipBytes(8);
        boolean control = (buffer.getByte(frameOffset) & 0x80) != 0;
        this.flags = buffer.getByte(flagsOffset);
        this.length = SpdyCodecUtil.getUnsignedMedium(buffer, lengthOffset);
        if (control) {
            State nextState;
            this.version = SpdyCodecUtil.getUnsignedShort(buffer, frameOffset) & Short.MAX_VALUE;
            int typeOffset = frameOffset + 2;
            this.type = SpdyCodecUtil.getUnsignedShort(buffer, typeOffset);
            if (this.version != this.spdyVersion || !this.isValidControlFrameHeader()) {
                return State.FRAME_ERROR;
            }
            if (this.willGenerateControlFrame()) {
                switch (this.type) {
                    case 1: 
                    case 2: 
                    case 8: {
                        nextState = State.READ_HEADER_BLOCK_FRAME;
                        break;
                    }
                    case 4: {
                        nextState = State.READ_SETTINGS_FRAME;
                        break;
                    }
                    default: {
                        nextState = State.READ_CONTROL_FRAME;
                        break;
                    }
                }
            } else {
                nextState = this.length != 0 ? State.DISCARD_FRAME : State.READ_COMMON_HEADER;
            }
            return nextState;
        }
        this.streamID = SpdyCodecUtil.getUnsignedInt(buffer, frameOffset);
        return State.READ_DATA_FRAME;
    }

    private Object readControlFrame(ChannelBuffer buffer) {
        switch (this.type) {
            case 3: {
                if (buffer.readableBytes() < 8) {
                    return null;
                }
                int streamID = SpdyCodecUtil.getUnsignedInt(buffer, buffer.readerIndex());
                int statusCode = SpdyCodecUtil.getSignedInt(buffer, buffer.readerIndex() + 4);
                buffer.skipBytes(8);
                return new DefaultSpdyRstStreamFrame(streamID, statusCode);
            }
            case 6: {
                if (buffer.readableBytes() < 4) {
                    return null;
                }
                int ID2 = SpdyCodecUtil.getSignedInt(buffer, buffer.readerIndex());
                buffer.skipBytes(4);
                return new DefaultSpdyPingFrame(ID2);
            }
            case 7: {
                int minLength;
                int n = minLength = this.version < 3 ? 4 : 8;
                if (buffer.readableBytes() < minLength) {
                    return null;
                }
                int lastGoodStreamID = SpdyCodecUtil.getUnsignedInt(buffer, buffer.readerIndex());
                buffer.skipBytes(4);
                if (this.version < 3) {
                    return new DefaultSpdyGoAwayFrame(lastGoodStreamID);
                }
                int statusCode = SpdyCodecUtil.getSignedInt(buffer, buffer.readerIndex());
                buffer.skipBytes(4);
                return new DefaultSpdyGoAwayFrame(lastGoodStreamID, statusCode);
            }
            case 9: {
                if (buffer.readableBytes() < 8) {
                    return null;
                }
                int streamID = SpdyCodecUtil.getUnsignedInt(buffer, buffer.readerIndex());
                int deltaWindowSize = SpdyCodecUtil.getUnsignedInt(buffer, buffer.readerIndex() + 4);
                buffer.skipBytes(8);
                return new DefaultSpdyWindowUpdateFrame(streamID, deltaWindowSize);
            }
        }
        throw new Error("Shouldn't reach here.");
    }

    private SpdyHeaderBlock readHeaderBlockFrame(ChannelBuffer buffer) {
        switch (this.type) {
            case 1: {
                int minLength;
                int n = minLength = this.version < 3 ? 12 : 10;
                if (buffer.readableBytes() < minLength) {
                    return null;
                }
                int offset = buffer.readerIndex();
                int streamID = SpdyCodecUtil.getUnsignedInt(buffer, offset);
                int associatedToStreamID = SpdyCodecUtil.getUnsignedInt(buffer, offset + 4);
                byte priority = (byte)(buffer.getByte(offset + 8) >> 5 & 7);
                if (this.version < 3) {
                    priority = (byte)(priority >> 1);
                }
                buffer.skipBytes(10);
                this.length -= 10;
                if (this.version < 3 && this.length == 2 && buffer.getShort(buffer.readerIndex()) == 0) {
                    buffer.skipBytes(2);
                    this.length = 0;
                }
                DefaultSpdySynStreamFrame spdySynStreamFrame = new DefaultSpdySynStreamFrame(streamID, associatedToStreamID, priority);
                spdySynStreamFrame.setLast((this.flags & 1) != 0);
                spdySynStreamFrame.setUnidirectional((this.flags & 2) != 0);
                return spdySynStreamFrame;
            }
            case 2: {
                int minLength;
                int n = minLength = this.version < 3 ? 8 : 4;
                if (buffer.readableBytes() < minLength) {
                    return null;
                }
                int streamID = SpdyCodecUtil.getUnsignedInt(buffer, buffer.readerIndex());
                buffer.skipBytes(4);
                this.length -= 4;
                if (this.version < 3) {
                    buffer.skipBytes(2);
                    this.length -= 2;
                }
                if (this.version < 3 && this.length == 2 && buffer.getShort(buffer.readerIndex()) == 0) {
                    buffer.skipBytes(2);
                    this.length = 0;
                }
                DefaultSpdySynReplyFrame spdySynReplyFrame = new DefaultSpdySynReplyFrame(streamID);
                spdySynReplyFrame.setLast((this.flags & 1) != 0);
                return spdySynReplyFrame;
            }
            case 8: {
                if (buffer.readableBytes() < 4) {
                    return null;
                }
                if (this.version < 3 && this.length > 4 && buffer.readableBytes() < 8) {
                    return null;
                }
                int streamID = SpdyCodecUtil.getUnsignedInt(buffer, buffer.readerIndex());
                buffer.skipBytes(4);
                this.length -= 4;
                if (this.version < 3 && this.length != 0) {
                    buffer.skipBytes(2);
                    this.length -= 2;
                }
                if (this.version < 3 && this.length == 2 && buffer.getShort(buffer.readerIndex()) == 0) {
                    buffer.skipBytes(2);
                    this.length = 0;
                }
                DefaultSpdyHeadersFrame spdyHeadersFrame = new DefaultSpdyHeadersFrame(streamID);
                spdyHeadersFrame.setLast((this.flags & 1) != 0);
                return spdyHeadersFrame;
            }
        }
        throw new Error("Shouldn't reach here.");
    }

    private boolean ensureBytes(int bytes) throws Exception {
        int numBytes;
        boolean done;
        if (this.decompressed.readableBytes() >= bytes) {
            return true;
        }
        do {
            numBytes = this.headerBlockDecompressor.decode(this.decompressed);
            boolean bl = done = this.decompressed.readableBytes() >= bytes;
        } while (!done && numBytes > 0);
        return done;
    }

    private int readLengthField() {
        if (this.version < 3) {
            return this.decompressed.readUnsignedShort();
        }
        return this.decompressed.readInt();
    }

    private void decodeHeaderBlock(ChannelBuffer buffer) throws Exception {
        int lengthFieldSize;
        if (this.decompressed == null) {
            this.headerSize = 0;
            this.numHeaders = -1;
            this.decompressed = ChannelBuffers.dynamicBuffer(8192);
        }
        this.headerBlockDecompressor.setInput(buffer);
        this.headerBlockDecompressor.decode(this.decompressed);
        if (this.spdyHeaderBlock == null) {
            this.decompressed = null;
            return;
        }
        int n = lengthFieldSize = this.version < 3 ? 2 : 4;
        if (this.numHeaders == -1) {
            if (this.decompressed.readableBytes() < lengthFieldSize) {
                return;
            }
            this.numHeaders = this.readLengthField();
            if (this.numHeaders < 0) {
                this.spdyHeaderBlock.setInvalid();
                return;
            }
        }
        while (this.numHeaders > 0) {
            int headerSize = this.headerSize;
            this.decompressed.markReaderIndex();
            if (!this.ensureBytes(lengthFieldSize)) {
                this.decompressed.resetReaderIndex();
                this.decompressed.discardReadBytes();
                return;
            }
            int nameLength = this.readLengthField();
            if (nameLength <= 0) {
                this.spdyHeaderBlock.setInvalid();
                return;
            }
            if ((headerSize += nameLength) > this.maxHeaderSize) {
                throw new TooLongFrameException("Header block exceeds " + this.maxHeaderSize);
            }
            if (!this.ensureBytes(nameLength)) {
                this.decompressed.resetReaderIndex();
                this.decompressed.discardReadBytes();
                return;
            }
            byte[] nameBytes = new byte[nameLength];
            this.decompressed.readBytes(nameBytes);
            String name = new String(nameBytes, "UTF-8");
            if (this.spdyHeaderBlock.containsHeader(name)) {
                this.spdyHeaderBlock.setInvalid();
                return;
            }
            if (!this.ensureBytes(lengthFieldSize)) {
                this.decompressed.resetReaderIndex();
                this.decompressed.discardReadBytes();
                return;
            }
            int valueLength = this.readLengthField();
            if (valueLength < 0) {
                this.spdyHeaderBlock.setInvalid();
                return;
            }
            if (valueLength == 0) {
                if (this.version < 3) {
                    this.spdyHeaderBlock.setInvalid();
                    return;
                }
                this.spdyHeaderBlock.addHeader(name, "");
                --this.numHeaders;
                this.headerSize = headerSize;
                continue;
            }
            if ((headerSize += valueLength) > this.maxHeaderSize) {
                throw new TooLongFrameException("Header block exceeds " + this.maxHeaderSize);
            }
            if (!this.ensureBytes(valueLength)) {
                this.decompressed.resetReaderIndex();
                this.decompressed.discardReadBytes();
                return;
            }
            byte[] valueBytes = new byte[valueLength];
            this.decompressed.readBytes(valueBytes);
            int index = 0;
            int offset = 0;
            while (index < valueLength) {
                while (index < valueBytes.length && valueBytes[index] != 0) {
                    ++index;
                }
                if (index < valueBytes.length && valueBytes[index + 1] == 0) {
                    this.spdyHeaderBlock.setInvalid();
                    return;
                }
                String value = new String(valueBytes, offset, index - offset, "UTF-8");
                try {
                    this.spdyHeaderBlock.addHeader(name, value);
                }
                catch (IllegalArgumentException e) {
                    this.spdyHeaderBlock.setInvalid();
                    return;
                }
                offset = ++index;
            }
            --this.numHeaders;
            this.headerSize = headerSize;
        }
        this.decompressed = null;
    }

    private boolean isValidControlFrameHeader() {
        switch (this.type) {
            case 1: {
                return this.version < 3 ? this.length >= 12 : this.length >= 10;
            }
            case 2: {
                return this.version < 3 ? this.length >= 8 : this.length >= 4;
            }
            case 3: {
                return this.flags == 0 && this.length == 8;
            }
            case 4: {
                return this.length >= 4;
            }
            case 5: {
                return this.length == 0;
            }
            case 6: {
                return this.length == 4;
            }
            case 7: {
                return this.version < 3 ? this.length == 4 : this.length == 8;
            }
            case 8: {
                if (this.version < 3) {
                    return this.length == 4 || this.length >= 8;
                }
                return this.length >= 4;
            }
            case 9: {
                return this.length == 8;
            }
        }
        return true;
    }

    private boolean willGenerateControlFrame() {
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    private void fireInvalidControlFrameException(ChannelHandlerContext ctx) {
        String message = "Received invalid control frame";
        switch (this.type) {
            case 1: {
                message = "Received invalid SYN_STREAM control frame";
                break;
            }
            case 2: {
                message = "Received invalid SYN_REPLY control frame";
                break;
            }
            case 3: {
                message = "Received invalid RST_STREAM control frame";
                break;
            }
            case 4: {
                message = "Received invalid SETTINGS control frame";
                break;
            }
            case 5: {
                message = "Received invalid NOOP control frame";
                break;
            }
            case 6: {
                message = "Received invalid PING control frame";
                break;
            }
            case 7: {
                message = "Received invalid GOAWAY control frame";
                break;
            }
            case 8: {
                message = "Received invalid HEADERS control frame";
                break;
            }
            case 9: {
                message = "Received invalid WINDOW_UPDATE control frame";
                break;
            }
            case 10: {
                message = "Received invalid CREDENTIAL control frame";
            }
        }
        SpdyFrameDecoder.fireProtocolException(ctx, message);
    }

    private static void fireProtocolException(ChannelHandlerContext ctx, String message) {
        Channels.fireExceptionCaught(ctx, (Throwable)new SpdyProtocolException(message));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        READ_COMMON_HEADER,
        READ_CONTROL_FRAME,
        READ_SETTINGS_FRAME,
        READ_HEADER_BLOCK_FRAME,
        READ_HEADER_BLOCK,
        READ_DATA_FRAME,
        DISCARD_FRAME,
        FRAME_ERROR;

    }
}

