/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;

@InterfaceStability.Evolving
@InterfaceAudience.Public
public class CacheDirectiveInfo {
    private final Long id;
    private final Path path;
    private final Short replication;
    private final String pool;
    private final Expiration expiration;

    CacheDirectiveInfo(Long id, Path path, Short replication, String pool, Expiration expiration) {
        this.id = id;
        this.path = path;
        this.replication = replication;
        this.pool = pool;
        this.expiration = expiration;
    }

    public Long getId() {
        return this.id;
    }

    public Path getPath() {
        return this.path;
    }

    public Short getReplication() {
        return this.replication;
    }

    public String getPool() {
        return this.pool;
    }

    public Expiration getExpiration() {
        return this.expiration;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        CacheDirectiveInfo other = (CacheDirectiveInfo)o;
        return new EqualsBuilder().append(this.getId(), other.getId()).append(this.getPath(), other.getPath()).append(this.getReplication(), other.getReplication()).append(this.getPool(), other.getPool()).append(this.getExpiration(), other.getExpiration()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.id).append(this.path).append(this.replication).append(this.pool).append(this.expiration).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        String prefix = "";
        if (this.id != null) {
            builder.append(prefix).append("id: ").append(this.id);
            prefix = ", ";
        }
        if (this.path != null) {
            builder.append(prefix).append("path: ").append(this.path);
            prefix = ", ";
        }
        if (this.replication != null) {
            builder.append(prefix).append("replication: ").append(this.replication);
            prefix = ", ";
        }
        if (this.pool != null) {
            builder.append(prefix).append("pool: ").append(this.pool);
            prefix = ", ";
        }
        if (this.expiration != null) {
            builder.append(prefix).append("expiration: ").append(this.expiration);
            prefix = ", ";
        }
        builder.append("}");
        return builder.toString();
    }

    public static class Expiration {
        public static final long MAX_RELATIVE_EXPIRY_MS = 0x1FFFFFFFFFFFFFFFL;
        public static final Expiration NEVER = Expiration.newRelative(0x1FFFFFFFFFFFFFFFL);
        private final long ms;
        private final boolean isRelative;

        public static Expiration newRelative(long ms) {
            return new Expiration(ms, true);
        }

        public static Expiration newAbsolute(Date date) {
            return new Expiration(date.getTime(), false);
        }

        public static Expiration newAbsolute(long ms) {
            return new Expiration(ms, false);
        }

        private Expiration(long ms, boolean isRelative) {
            if (isRelative) {
                Preconditions.checkArgument(ms <= 0x1FFFFFFFFFFFFFFFL, "Expiration time is too far in the future!");
            }
            this.ms = ms;
            this.isRelative = isRelative;
        }

        public boolean isRelative() {
            return this.isRelative;
        }

        public long getMillis() {
            return this.ms;
        }

        public Date getAbsoluteDate() {
            return new Date(this.getAbsoluteMillis());
        }

        public long getAbsoluteMillis() {
            if (!this.isRelative) {
                return this.ms;
            }
            return new Date().getTime() + this.ms;
        }

        public String toString() {
            if (this.isRelative) {
                return DFSUtil.durationToString(this.ms);
            }
            return DFSUtil.dateToIso8601String(new Date(this.ms));
        }
    }

    public static class Builder {
        private Long id;
        private Path path;
        private Short replication;
        private String pool;
        private Expiration expiration;

        public CacheDirectiveInfo build() {
            return new CacheDirectiveInfo(this.id, this.path, this.replication, this.pool, this.expiration);
        }

        public Builder() {
        }

        public Builder(CacheDirectiveInfo directive) {
            this.id = directive.getId();
            this.path = directive.getPath();
            this.replication = directive.getReplication();
            this.pool = directive.getPool();
            this.expiration = directive.getExpiration();
        }

        public Builder setId(Long id) {
            this.id = id;
            return this;
        }

        public Builder setPath(Path path) {
            this.path = path;
            return this;
        }

        public Builder setReplication(Short replication) {
            this.replication = replication;
            return this;
        }

        public Builder setPool(String pool) {
            this.pool = pool;
            return this;
        }

        public Builder setExpiration(Expiration expiration) {
            this.expiration = expiration;
            return this;
        }
    }
}

