/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapred.MapRunner;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.HashPartitioner;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapred.lib.KeyFieldBasedComparator;
import org.apache.hadoop.mapred.lib.KeyFieldBasedPartitioner;
import org.apache.hadoop.mapreduce.util.ConfigUtil;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.ClassUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.log4j.Level;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class JobConf
extends Configuration {
    private static final Log LOG = LogFactory.getLog(JobConf.class);
    @Deprecated
    public static final String MAPRED_TASK_MAXVMEM_PROPERTY = "mapred.task.maxvmem";
    @Deprecated
    public static final String UPPER_LIMIT_ON_TASK_VMEM_PROPERTY = "mapred.task.limit.maxvmem";
    @Deprecated
    public static final String MAPRED_TASK_DEFAULT_MAXVMEM_PROPERTY = "mapred.task.default.maxvmem";
    @Deprecated
    public static final String MAPRED_TASK_MAXPMEM_PROPERTY = "mapred.task.maxpmem";
    public static final long DISABLED_MEMORY_LIMIT = -1L;
    public static final String MAPRED_LOCAL_DIR_PROPERTY = "mapreduce.cluster.local.dir";
    public static final String DEFAULT_QUEUE_NAME = "default";
    static final String MAPREDUCE_JOB_MAP_MEMORY_MB_PROPERTY = "mapreduce.map.memory.mb";
    static final String MAPREDUCE_JOB_REDUCE_MEMORY_MB_PROPERTY = "mapreduce.reduce.memory.mb";
    @Deprecated
    public static final String MAPRED_JOB_MAP_MEMORY_MB_PROPERTY = "mapred.job.map.memory.mb";
    @Deprecated
    public static final String MAPRED_JOB_REDUCE_MEMORY_MB_PROPERTY = "mapred.job.reduce.memory.mb";
    public static final Pattern UNPACK_JAR_PATTERN_DEFAULT;
    @Deprecated
    public static final String MAPRED_TASK_JAVA_OPTS = "mapred.child.java.opts";
    public static final String MAPRED_MAP_TASK_JAVA_OPTS = "mapreduce.map.java.opts";
    public static final String MAPRED_REDUCE_TASK_JAVA_OPTS = "mapreduce.reduce.java.opts";
    public static final String DEFAULT_MAPRED_TASK_JAVA_OPTS = "-Xmx200m";
    @Deprecated
    public static final String MAPRED_TASK_ULIMIT = "mapred.child.ulimit";
    @Deprecated
    public static final String MAPRED_MAP_TASK_ULIMIT = "mapreduce.map.ulimit";
    @Deprecated
    public static final String MAPRED_REDUCE_TASK_ULIMIT = "mapreduce.reduce.ulimit";
    @Deprecated
    public static final String MAPRED_TASK_ENV = "mapred.child.env";
    public static final String MAPRED_MAP_TASK_ENV = "mapreduce.map.env";
    public static final String MAPRED_REDUCE_TASK_ENV = "mapreduce.reduce.env";
    private Credentials credentials = new Credentials();
    public static final String MAPRED_MAP_TASK_LOG_LEVEL = "mapreduce.map.log.level";
    public static final String MAPRED_REDUCE_TASK_LOG_LEVEL = "mapreduce.reduce.log.level";
    public static final Level DEFAULT_LOG_LEVEL;
    @Deprecated
    public static final String WORKFLOW_ID = "mapreduce.workflow.id";
    @Deprecated
    public static final String WORKFLOW_NAME = "mapreduce.workflow.name";
    @Deprecated
    public static final String WORKFLOW_NODE_NAME = "mapreduce.workflow.node.name";
    @Deprecated
    public static final String WORKFLOW_ADJACENCY_PREFIX_STRING = "mapreduce.workflow.adjacency.";
    @Deprecated
    public static final String WORKFLOW_ADJACENCY_PREFIX_PATTERN = "^mapreduce\\.workflow\\.adjacency\\..+";
    @Deprecated
    public static final String WORKFLOW_TAGS = "mapreduce.workflow.tags";
    @Deprecated
    public static final String MAPREDUCE_RECOVER_JOB = "mapreduce.job.restart.recover";
    @Deprecated
    public static final boolean DEFAULT_MAPREDUCE_RECOVER_JOB = true;

    public JobConf() {
        this.checkAndWarnDeprecation();
    }

    public JobConf(Class exampleClass) {
        this.setJarByClass(exampleClass);
        this.checkAndWarnDeprecation();
    }

    public JobConf(Configuration conf) {
        super(conf);
        if (conf instanceof JobConf) {
            JobConf that = (JobConf)conf;
            this.credentials = that.credentials;
        }
        this.checkAndWarnDeprecation();
    }

    public JobConf(Configuration conf, Class exampleClass) {
        this(conf);
        this.setJarByClass(exampleClass);
    }

    public JobConf(String config) {
        this(new Path(config));
    }

    public JobConf(Path config) {
        this.addResource(config);
        this.checkAndWarnDeprecation();
    }

    public JobConf(boolean loadDefaults) {
        super(loadDefaults);
        this.checkAndWarnDeprecation();
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    @InterfaceAudience.Private
    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public String getJar() {
        return this.get("mapreduce.job.jar");
    }

    public void setJar(String jar) {
        this.set("mapreduce.job.jar", jar);
    }

    public Pattern getJarUnpackPattern() {
        return this.getPattern("mapreduce.job.jar.unpack.pattern", UNPACK_JAR_PATTERN_DEFAULT);
    }

    public void setJarByClass(Class cls) {
        String jar = ClassUtil.findContainingJar(cls);
        if (jar != null) {
            this.setJar(jar);
        }
    }

    public String[] getLocalDirs() throws IOException {
        return this.getTrimmedStrings(MAPRED_LOCAL_DIR_PROPERTY);
    }

    @Deprecated
    public void deleteLocalFiles() throws IOException {
        String[] localDirs = this.getLocalDirs();
        for (int i = 0; i < localDirs.length; ++i) {
            FileSystem.getLocal(this).delete(new Path(localDirs[i]), true);
        }
    }

    public void deleteLocalFiles(String subdir) throws IOException {
        String[] localDirs = this.getLocalDirs();
        for (int i = 0; i < localDirs.length; ++i) {
            FileSystem.getLocal(this).delete(new Path(localDirs[i], subdir), true);
        }
    }

    public Path getLocalPath(String pathString) throws IOException {
        return this.getLocalPath(MAPRED_LOCAL_DIR_PROPERTY, pathString);
    }

    public String getUser() {
        return this.get("mapreduce.job.user.name");
    }

    public void setUser(String user) {
        this.set("mapreduce.job.user.name", user);
    }

    public void setKeepFailedTaskFiles(boolean keep) {
        this.setBoolean("mapreduce.task.files.preserve.failedtasks", keep);
    }

    public boolean getKeepFailedTaskFiles() {
        return this.getBoolean("mapreduce.task.files.preserve.failedtasks", false);
    }

    public void setKeepTaskFilesPattern(String pattern) {
        this.set("mapreduce.task.files.preserve.filepattern", pattern);
    }

    public String getKeepTaskFilesPattern() {
        return this.get("mapreduce.task.files.preserve.filepattern");
    }

    public void setWorkingDirectory(Path dir) {
        dir = new Path(this.getWorkingDirectory(), dir);
        this.set("mapreduce.job.working.dir", dir.toString());
    }

    public Path getWorkingDirectory() {
        String name = this.get("mapreduce.job.working.dir");
        if (name != null) {
            return new Path(name);
        }
        try {
            Path dir = FileSystem.get(this).getWorkingDirectory();
            this.set("mapreduce.job.working.dir", dir.toString());
            return dir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setNumTasksToExecutePerJvm(int numTasks) {
        this.setInt("mapreduce.job.jvm.numtasks", numTasks);
    }

    public int getNumTasksToExecutePerJvm() {
        return this.getInt("mapreduce.job.jvm.numtasks", 1);
    }

    public InputFormat getInputFormat() {
        return ReflectionUtils.newInstance(this.getClass("mapred.input.format.class", TextInputFormat.class, InputFormat.class), this);
    }

    public void setInputFormat(Class<? extends InputFormat> theClass) {
        this.setClass("mapred.input.format.class", theClass, InputFormat.class);
    }

    public OutputFormat getOutputFormat() {
        return ReflectionUtils.newInstance(this.getClass("mapred.output.format.class", TextOutputFormat.class, OutputFormat.class), this);
    }

    public OutputCommitter getOutputCommitter() {
        return ReflectionUtils.newInstance(this.getClass("mapred.output.committer.class", FileOutputCommitter.class, OutputCommitter.class), this);
    }

    public void setOutputCommitter(Class<? extends OutputCommitter> theClass) {
        this.setClass("mapred.output.committer.class", theClass, OutputCommitter.class);
    }

    public void setOutputFormat(Class<? extends OutputFormat> theClass) {
        this.setClass("mapred.output.format.class", theClass, OutputFormat.class);
    }

    public void setCompressMapOutput(boolean compress) {
        this.setBoolean("mapreduce.map.output.compress", compress);
    }

    public boolean getCompressMapOutput() {
        return this.getBoolean("mapreduce.map.output.compress", false);
    }

    public void setMapOutputCompressorClass(Class<? extends CompressionCodec> codecClass) {
        this.setCompressMapOutput(true);
        this.setClass("mapreduce.map.output.compress.codec", codecClass, CompressionCodec.class);
    }

    public Class<? extends CompressionCodec> getMapOutputCompressorClass(Class<? extends CompressionCodec> defaultValue) {
        Class<? extends CompressionCodec> codecClass = defaultValue;
        String name = this.get("mapreduce.map.output.compress.codec");
        if (name != null) {
            try {
                codecClass = this.getClassByName(name).asSubclass(CompressionCodec.class);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Compression codec " + name + " was not found.", e);
            }
        }
        return codecClass;
    }

    public Class<?> getMapOutputKeyClass() {
        Class<Object> retv = this.getClass("mapreduce.map.output.key.class", null, Object.class);
        if (retv == null) {
            retv = this.getOutputKeyClass();
        }
        return retv;
    }

    public void setMapOutputKeyClass(Class<?> theClass) {
        this.setClass("mapreduce.map.output.key.class", theClass, Object.class);
    }

    public Class<?> getMapOutputValueClass() {
        Class<Object> retv = this.getClass("mapreduce.map.output.value.class", null, Object.class);
        if (retv == null) {
            retv = this.getOutputValueClass();
        }
        return retv;
    }

    public void setMapOutputValueClass(Class<?> theClass) {
        this.setClass("mapreduce.map.output.value.class", theClass, Object.class);
    }

    public Class<?> getOutputKeyClass() {
        return this.getClass("mapreduce.job.output.key.class", LongWritable.class, Object.class);
    }

    public void setOutputKeyClass(Class<?> theClass) {
        this.setClass("mapreduce.job.output.key.class", theClass, Object.class);
    }

    public RawComparator getOutputKeyComparator() {
        Class<RawComparator> theClass = this.getClass("mapreduce.job.output.key.comparator.class", null, RawComparator.class);
        if (theClass != null) {
            return ReflectionUtils.newInstance(theClass, this);
        }
        return WritableComparator.get(this.getMapOutputKeyClass().asSubclass(WritableComparable.class), this);
    }

    public void setOutputKeyComparatorClass(Class<? extends RawComparator> theClass) {
        this.setClass("mapreduce.job.output.key.comparator.class", theClass, RawComparator.class);
    }

    public void setKeyFieldComparatorOptions(String keySpec) {
        this.setOutputKeyComparatorClass(KeyFieldBasedComparator.class);
        this.set(KeyFieldBasedComparator.COMPARATOR_OPTIONS, keySpec);
    }

    public String getKeyFieldComparatorOption() {
        return this.get(KeyFieldBasedComparator.COMPARATOR_OPTIONS);
    }

    public void setKeyFieldPartitionerOptions(String keySpec) {
        this.setPartitionerClass(KeyFieldBasedPartitioner.class);
        this.set(KeyFieldBasedPartitioner.PARTITIONER_OPTIONS, keySpec);
    }

    public String getKeyFieldPartitionerOption() {
        return this.get(KeyFieldBasedPartitioner.PARTITIONER_OPTIONS);
    }

    public RawComparator getCombinerKeyGroupingComparator() {
        Class<RawComparator> theClass = this.getClass("mapreduce.job.combiner.group.comparator.class", null, RawComparator.class);
        if (theClass == null) {
            return this.getOutputKeyComparator();
        }
        return ReflectionUtils.newInstance(theClass, this);
    }

    public RawComparator getOutputValueGroupingComparator() {
        Class<RawComparator> theClass = this.getClass("mapreduce.job.output.group.comparator.class", null, RawComparator.class);
        if (theClass == null) {
            return this.getOutputKeyComparator();
        }
        return ReflectionUtils.newInstance(theClass, this);
    }

    public void setCombinerKeyGroupingComparator(Class<? extends RawComparator> theClass) {
        this.setClass("mapreduce.job.combiner.group.comparator.class", theClass, RawComparator.class);
    }

    public void setOutputValueGroupingComparator(Class<? extends RawComparator> theClass) {
        this.setClass("mapreduce.job.output.group.comparator.class", theClass, RawComparator.class);
    }

    public boolean getUseNewMapper() {
        return this.getBoolean("mapred.mapper.new-api", false);
    }

    public void setUseNewMapper(boolean flag) {
        this.setBoolean("mapred.mapper.new-api", flag);
    }

    public boolean getUseNewReducer() {
        return this.getBoolean("mapred.reducer.new-api", false);
    }

    public void setUseNewReducer(boolean flag) {
        this.setBoolean("mapred.reducer.new-api", flag);
    }

    public Class<?> getOutputValueClass() {
        return this.getClass("mapreduce.job.output.value.class", Text.class, Object.class);
    }

    public void setOutputValueClass(Class<?> theClass) {
        this.setClass("mapreduce.job.output.value.class", theClass, Object.class);
    }

    public Class<? extends Mapper> getMapperClass() {
        return this.getClass("mapred.mapper.class", IdentityMapper.class, Mapper.class);
    }

    public void setMapperClass(Class<? extends Mapper> theClass) {
        this.setClass("mapred.mapper.class", theClass, Mapper.class);
    }

    public Class<? extends MapRunnable> getMapRunnerClass() {
        return this.getClass("mapred.map.runner.class", MapRunner.class, MapRunnable.class);
    }

    public void setMapRunnerClass(Class<? extends MapRunnable> theClass) {
        this.setClass("mapred.map.runner.class", theClass, MapRunnable.class);
    }

    public Class<? extends Partitioner> getPartitionerClass() {
        return this.getClass("mapred.partitioner.class", HashPartitioner.class, Partitioner.class);
    }

    public void setPartitionerClass(Class<? extends Partitioner> theClass) {
        this.setClass("mapred.partitioner.class", theClass, Partitioner.class);
    }

    public Class<? extends Reducer> getReducerClass() {
        return this.getClass("mapred.reducer.class", IdentityReducer.class, Reducer.class);
    }

    public void setReducerClass(Class<? extends Reducer> theClass) {
        this.setClass("mapred.reducer.class", theClass, Reducer.class);
    }

    public Class<? extends Reducer> getCombinerClass() {
        return this.getClass("mapred.combiner.class", null, Reducer.class);
    }

    public void setCombinerClass(Class<? extends Reducer> theClass) {
        this.setClass("mapred.combiner.class", theClass, Reducer.class);
    }

    public boolean getSpeculativeExecution() {
        return this.getMapSpeculativeExecution() || this.getReduceSpeculativeExecution();
    }

    public void setSpeculativeExecution(boolean speculativeExecution) {
        this.setMapSpeculativeExecution(speculativeExecution);
        this.setReduceSpeculativeExecution(speculativeExecution);
    }

    public boolean getMapSpeculativeExecution() {
        return this.getBoolean("mapreduce.map.speculative", true);
    }

    public void setMapSpeculativeExecution(boolean speculativeExecution) {
        this.setBoolean("mapreduce.map.speculative", speculativeExecution);
    }

    public boolean getReduceSpeculativeExecution() {
        return this.getBoolean("mapreduce.reduce.speculative", true);
    }

    public void setReduceSpeculativeExecution(boolean speculativeExecution) {
        this.setBoolean("mapreduce.reduce.speculative", speculativeExecution);
    }

    public int getNumMapTasks() {
        return this.getInt("mapreduce.job.maps", 1);
    }

    public void setNumMapTasks(int n) {
        this.setInt("mapreduce.job.maps", n);
    }

    public int getNumReduceTasks() {
        return this.getInt("mapreduce.job.reduces", 1);
    }

    public void setNumReduceTasks(int n) {
        this.setInt("mapreduce.job.reduces", n);
    }

    public int getMaxMapAttempts() {
        return this.getInt("mapreduce.map.maxattempts", 4);
    }

    public void setMaxMapAttempts(int n) {
        this.setInt("mapreduce.map.maxattempts", n);
    }

    public int getMaxReduceAttempts() {
        return this.getInt("mapreduce.reduce.maxattempts", 4);
    }

    public void setMaxReduceAttempts(int n) {
        this.setInt("mapreduce.reduce.maxattempts", n);
    }

    public String getJobName() {
        return this.get("mapreduce.job.name", "");
    }

    public void setJobName(String name) {
        this.set("mapreduce.job.name", name);
    }

    @Deprecated
    public String getSessionId() {
        return this.get("session.id", "");
    }

    @Deprecated
    public void setSessionId(String sessionId) {
        this.set("session.id", sessionId);
    }

    public void setMaxTaskFailuresPerTracker(int noFailures) {
        this.setInt("mapreduce.job.maxtaskfailures.per.tracker", noFailures);
    }

    public int getMaxTaskFailuresPerTracker() {
        return this.getInt("mapreduce.job.maxtaskfailures.per.tracker", 3);
    }

    public int getMaxMapTaskFailuresPercent() {
        return this.getInt("mapreduce.map.failures.maxpercent", 0);
    }

    public void setMaxMapTaskFailuresPercent(int percent) {
        this.setInt("mapreduce.map.failures.maxpercent", percent);
    }

    public int getMaxReduceTaskFailuresPercent() {
        return this.getInt("mapreduce.reduce.failures.maxpercent", 0);
    }

    public void setMaxReduceTaskFailuresPercent(int percent) {
        this.setInt("mapreduce.reduce.failures.maxpercent", percent);
    }

    public void setJobPriority(JobPriority prio) {
        this.set("mapreduce.job.priority", prio.toString());
    }

    public JobPriority getJobPriority() {
        String prio = this.get("mapreduce.job.priority");
        if (prio == null) {
            return JobPriority.NORMAL;
        }
        return JobPriority.valueOf(prio);
    }

    void setJobSubmitHostName(String hostname) {
        this.set("mapreduce.job.submithostname", hostname);
    }

    String getJobSubmitHostName() {
        String hostname = this.get("mapreduce.job.submithostname");
        return hostname;
    }

    void setJobSubmitHostAddress(String hostadd) {
        this.set("mapreduce.job.submithostaddress", hostadd);
    }

    String getJobSubmitHostAddress() {
        String hostadd = this.get("mapreduce.job.submithostaddress");
        return hostadd;
    }

    public boolean getProfileEnabled() {
        return this.getBoolean("mapreduce.task.profile", false);
    }

    public void setProfileEnabled(boolean newValue) {
        this.setBoolean("mapreduce.task.profile", newValue);
    }

    public String getProfileParams() {
        return this.get("mapreduce.task.profile.params", "-agentlib:hprof=cpu=samples,heap=sites,force=n,thread=y,verbose=n,file=%s");
    }

    public void setProfileParams(String value) {
        this.set("mapreduce.task.profile.params", value);
    }

    public Configuration.IntegerRanges getProfileTaskRange(boolean isMap) {
        return this.getRange(isMap ? "mapreduce.task.profile.maps" : "mapreduce.task.profile.reduces", "0-2");
    }

    public void setProfileTaskRange(boolean isMap, String newValue) {
        new Configuration.IntegerRanges(newValue);
        this.set(isMap ? "mapreduce.task.profile.maps" : "mapreduce.task.profile.reduces", newValue);
    }

    public void setMapDebugScript(String mDbgScript) {
        this.set("mapreduce.map.debug.script", mDbgScript);
    }

    public String getMapDebugScript() {
        return this.get("mapreduce.map.debug.script");
    }

    public void setReduceDebugScript(String rDbgScript) {
        this.set("mapreduce.reduce.debug.script", rDbgScript);
    }

    public String getReduceDebugScript() {
        return this.get("mapreduce.reduce.debug.script");
    }

    public String getJobEndNotificationURI() {
        return this.get("mapreduce.job.end-notification.url");
    }

    public void setJobEndNotificationURI(String uri) {
        this.set("mapreduce.job.end-notification.url", uri);
    }

    public String getJobLocalDir() {
        return this.get("mapreduce.job.local.dir");
    }

    public long getMemoryForMapTask() {
        long value = this.getDeprecatedMemoryValue();
        if (value == -1L) {
            value = JobConf.normalizeMemoryConfigValue(this.getLong(MAPREDUCE_JOB_MAP_MEMORY_MB_PROPERTY, -1L));
        }
        if (value == -1L) {
            value = JobConf.normalizeMemoryConfigValue(this.getLong(MAPRED_JOB_MAP_MEMORY_MB_PROPERTY, -1L));
        }
        return value;
    }

    public void setMemoryForMapTask(long mem) {
        this.setLong(MAPREDUCE_JOB_MAP_MEMORY_MB_PROPERTY, mem);
        this.setLong(MAPRED_JOB_MAP_MEMORY_MB_PROPERTY, mem);
    }

    public long getMemoryForReduceTask() {
        long value = this.getDeprecatedMemoryValue();
        if (value == -1L) {
            value = JobConf.normalizeMemoryConfigValue(this.getLong(MAPREDUCE_JOB_REDUCE_MEMORY_MB_PROPERTY, -1L));
        }
        if (value == -1L) {
            value = JobConf.normalizeMemoryConfigValue(this.getLong(MAPRED_JOB_REDUCE_MEMORY_MB_PROPERTY, -1L));
        }
        return value;
    }

    private long getDeprecatedMemoryValue() {
        long oldValue = this.getLong(MAPRED_TASK_MAXVMEM_PROPERTY, -1L);
        if ((oldValue = JobConf.normalizeMemoryConfigValue(oldValue)) != -1L) {
            oldValue /= 0x100000L;
        }
        return oldValue;
    }

    public void setMemoryForReduceTask(long mem) {
        this.setLong(MAPREDUCE_JOB_REDUCE_MEMORY_MB_PROPERTY, mem);
        this.setLong(MAPRED_JOB_REDUCE_MEMORY_MB_PROPERTY, mem);
    }

    public String getQueueName() {
        return this.get("mapreduce.job.queuename", DEFAULT_QUEUE_NAME);
    }

    public void setQueueName(String queueName) {
        this.set("mapreduce.job.queuename", queueName);
    }

    public static long normalizeMemoryConfigValue(long val) {
        if (val < 0L) {
            val = -1L;
        }
        return val;
    }

    int computeNumSlotsPerMap(long slotSizePerMap) {
        if (slotSizePerMap == -1L || this.getMemoryForMapTask() == -1L) {
            return 1;
        }
        return (int)Math.ceil((float)this.getMemoryForMapTask() / (float)slotSizePerMap);
    }

    int computeNumSlotsPerReduce(long slotSizePerReduce) {
        if (slotSizePerReduce == -1L || this.getMemoryForReduceTask() == -1L) {
            return 1;
        }
        return (int)Math.ceil((float)this.getMemoryForReduceTask() / (float)slotSizePerReduce);
    }

    public static String findContainingJar(Class my_class) {
        return ClassUtil.findContainingJar(my_class);
    }

    @Deprecated
    public long getMaxVirtualMemoryForTask() {
        LOG.warn("getMaxVirtualMemoryForTask() is deprecated. Instead use getMemoryForMapTask() and getMemoryForReduceTask()");
        long value = this.getLong(MAPRED_TASK_MAXVMEM_PROPERTY, -1L);
        value = JobConf.normalizeMemoryConfigValue(value);
        if (value == -1L) {
            value = Math.max(this.getMemoryForMapTask(), this.getMemoryForReduceTask());
            if ((value = JobConf.normalizeMemoryConfigValue(value)) != -1L) {
                value *= 0x100000L;
            }
        }
        return value;
    }

    @Deprecated
    public void setMaxVirtualMemoryForTask(long vmem) {
        LOG.warn("setMaxVirtualMemoryForTask() is deprecated.Instead use setMemoryForMapTask() and setMemoryForReduceTask()");
        if (vmem != -1L && vmem < 0L) {
            this.setMemoryForMapTask(-1L);
            this.setMemoryForReduceTask(-1L);
        }
        if (this.get(MAPRED_TASK_MAXVMEM_PROPERTY) == null) {
            this.setMemoryForMapTask(vmem / 0x100000L);
            this.setMemoryForReduceTask(vmem / 0x100000L);
        } else {
            this.setLong(MAPRED_TASK_MAXVMEM_PROPERTY, vmem);
        }
    }

    @Deprecated
    public long getMaxPhysicalMemoryForTask() {
        LOG.warn("The API getMaxPhysicalMemoryForTask() is deprecated. Refer to the APIs getMemoryForMapTask() and getMemoryForReduceTask() for details.");
        return -1L;
    }

    @Deprecated
    public void setMaxPhysicalMemoryForTask(long mem) {
        LOG.warn("The API setMaxPhysicalMemoryForTask() is deprecated. The value set is ignored. Refer to  setMemoryForMapTask() and setMemoryForReduceTask() for details.");
    }

    static String deprecatedString(String key) {
        return "The variable " + key + " is no longer used.";
    }

    private void checkAndWarnDeprecation() {
        if (this.get(MAPRED_TASK_MAXVMEM_PROPERTY) != null) {
            LOG.warn(JobConf.deprecatedString(MAPRED_TASK_MAXVMEM_PROPERTY) + " Instead use " + MAPREDUCE_JOB_MAP_MEMORY_MB_PROPERTY + " and " + MAPREDUCE_JOB_REDUCE_MEMORY_MB_PROPERTY);
        }
        if (this.get(MAPRED_TASK_ULIMIT) != null) {
            LOG.warn(JobConf.deprecatedString(MAPRED_TASK_ULIMIT));
        }
        if (this.get(MAPRED_MAP_TASK_ULIMIT) != null) {
            LOG.warn(JobConf.deprecatedString(MAPRED_MAP_TASK_ULIMIT));
        }
        if (this.get(MAPRED_REDUCE_TASK_ULIMIT) != null) {
            LOG.warn(JobConf.deprecatedString(MAPRED_REDUCE_TASK_ULIMIT));
        }
    }

    static {
        ConfigUtil.loadResources();
        UNPACK_JAR_PATTERN_DEFAULT = Pattern.compile("(?:classes/|lib/).*");
        DEFAULT_LOG_LEVEL = Level.INFO;
    }
}

