/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;
import org.apache.trevni.avro.RandomData;

public class CreateRandomFileTool
implements Tool {
    @Override
    public String getName() {
        return "random";
    }

    @Override
    public String getShortDescription() {
        return "Creates a file with randomly generated instances of a schema.";
    }

    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser p = new OptionParser();
        ArgumentAcceptingOptionSpec<Integer> count = p.accepts("count", "Record Count").withRequiredArg().ofType(Integer.class);
        OptionSpec<String> codec = Util.compressionCodecOption(p);
        OptionSpec<Integer> level = Util.compressionLevelOption(p);
        ArgumentAcceptingOptionSpec<String> file = p.accepts("schema-file", "Schema File").withOptionalArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<String> inschema = p.accepts("schema", "Schema").withOptionalArg().ofType(String.class);
        OptionSet opts = p.parse(args.toArray(new String[0]));
        if (opts.nonOptionArguments().size() != 1) {
            err.println("Usage: outFile (filename or '-' for stdout)");
            p.printHelpOn(err);
            return 1;
        }
        args = opts.nonOptionArguments();
        String schemastr = (String)inschema.value(opts);
        String schemafile = (String)file.value(opts);
        if (schemastr == null && schemafile == null) {
            err.println("Need input schema (--schema-file) or (--schema)");
            p.printHelpOn(err);
            return 1;
        }
        Schema schema = schemafile != null ? Util.parseSchemaFromFS(schemafile) : new Schema.Parser().parse(schemastr);
        DataFileWriter<Object> writer = new DataFileWriter<Object>(new GenericDatumWriter());
        writer.setCodec(Util.codecFactory(opts, codec, level));
        writer.create(schema, Util.fileOrStdout(args.get(0), out));
        for (Object datum : new RandomData(schema, (Integer)count.value(opts))) {
            writer.append(datum);
        }
        writer.close();
        return 0;
    }
}

