/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.apache.avro.tool.Tool;

public class SpecificCompilerTool
implements Tool {
    private static final FileExtensionFilter SCHEMA_FILTER = new FileExtensionFilter("avsc");
    private static final FileExtensionFilter PROTOCOL_FILTER = new FileExtensionFilter("avpr");

    @Override
    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        if (args.size() < 3) {
            System.err.println("Usage: [-encoding <outputencoding>] [-string] [-bigDecimal] (schema|protocol) input... outputdir");
            System.err.println(" input - input files or directories");
            System.err.println(" outputdir - directory to write generated java");
            System.err.println(" -encoding <outputencoding> - set the encoding of output file(s)");
            System.err.println(" -string - use java.lang.String instead of Utf8");
            System.err.println(" -bigDecimal - use java.math.BigDecimal for decimal type instead of java.nio.ByteBuffer");
            return 1;
        }
        GenericData.StringType stringType = GenericData.StringType.CharSequence;
        boolean useLogicalDecimal = false;
        int arg = 0;
        String encoding = null;
        if ("-encoding".equals(args.get(arg))) {
            encoding = args.get(++arg);
            ++arg;
        }
        if ("-string".equals(args.get(arg))) {
            stringType = GenericData.StringType.String;
            ++arg;
        }
        if ("-bigDecimal".equalsIgnoreCase(args.get(arg))) {
            useLogicalDecimal = true;
            ++arg;
        }
        String method = args.get(arg);
        ArrayList<File> inputs = new ArrayList<File>();
        File output = new File(args.get(args.size() - 1));
        for (int i = arg + 1; i < args.size() - 1; ++i) {
            inputs.add(new File(args.get(i)));
        }
        if ("schema".equals(method)) {
            Schema.Parser parser = new Schema.Parser();
            for (File src : SpecificCompilerTool.determineInputs(inputs, SCHEMA_FILTER)) {
                Schema schema = parser.parse(src);
                SpecificCompiler compiler = new SpecificCompiler(schema);
                this.executeCompiler(compiler, encoding, stringType, useLogicalDecimal, src, output);
            }
        } else if ("protocol".equals(method)) {
            for (File src : SpecificCompilerTool.determineInputs(inputs, PROTOCOL_FILTER)) {
                Protocol protocol = Protocol.parse(src);
                SpecificCompiler compiler = new SpecificCompiler(protocol);
                this.executeCompiler(compiler, encoding, stringType, useLogicalDecimal, src, output);
            }
        } else {
            System.err.println("Expected \"schema\" or \"protocol\".");
            return 1;
        }
        return 0;
    }

    private void executeCompiler(SpecificCompiler compiler, String encoding, GenericData.StringType stringType, boolean enableDecimalLogicalType, File src, File output) throws IOException {
        compiler.setStringType(stringType);
        compiler.setEnableDecimalLogicalType(enableDecimalLogicalType);
        if (encoding != null) {
            compiler.setOutputCharacterEncoding(encoding);
        }
        compiler.compileToDestination(src, output);
    }

    @Override
    public String getName() {
        return "compile";
    }

    @Override
    public String getShortDescription() {
        return "Generates Java code for the given schema.";
    }

    private static File[] determineInputs(List<File> inputs, FilenameFilter filter) {
        LinkedHashSet<File> fileSet = new LinkedHashSet<File>();
        for (File file : inputs) {
            if (file.isDirectory()) {
                for (File f : file.listFiles(filter)) {
                    fileSet.add(f);
                }
                continue;
            }
            fileSet.add(file);
        }
        if (fileSet.size() > 0) {
            System.err.println("Input files to compile:");
            for (File file : fileSet) {
                System.err.println("  " + file);
            }
        } else {
            System.err.println("No input files found.");
        }
        return fileSet.toArray(new File[fileSet.size()]);
    }

    private static class FileExtensionFilter
    implements FilenameFilter {
        private String extension;

        private FileExtensionFilter(String extension) {
            this.extension = extension;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.extension);
        }
    }
}

