/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PriorityPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

public class ContainerReportPBImpl
extends ContainerReport {
    YarnProtos.ContainerReportProto proto = YarnProtos.ContainerReportProto.getDefaultInstance();
    YarnProtos.ContainerReportProto.Builder builder = null;
    boolean viaProto = false;
    private ContainerId containerId = null;
    private Resource resource = null;
    private NodeId nodeId = null;
    private Priority priority = null;

    public ContainerReportPBImpl() {
        this.builder = YarnProtos.ContainerReportProto.newBuilder();
    }

    public ContainerReportPBImpl(YarnProtos.ContainerReportProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    @Override
    public Resource getAllocatedResource() {
        YarnProtos.ContainerReportProtoOrBuilder p;
        if (this.resource != null) {
            return this.resource;
        }
        YarnProtos.ContainerReportProtoOrBuilder containerReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasResource()) {
            return null;
        }
        this.resource = this.convertFromProtoFormat(p.getResource());
        return this.resource;
    }

    @Override
    public NodeId getAssignedNode() {
        YarnProtos.ContainerReportProtoOrBuilder p;
        if (this.nodeId != null) {
            return this.nodeId;
        }
        YarnProtos.ContainerReportProtoOrBuilder containerReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeId()) {
            return null;
        }
        this.nodeId = this.convertFromProtoFormat(p.getNodeId());
        return this.nodeId;
    }

    @Override
    public ContainerId getContainerId() {
        YarnProtos.ContainerReportProtoOrBuilder p;
        if (this.containerId != null) {
            return this.containerId;
        }
        YarnProtos.ContainerReportProtoOrBuilder containerReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasContainerId()) {
            return null;
        }
        this.containerId = this.convertFromProtoFormat(p.getContainerId());
        return this.containerId;
    }

    @Override
    public String getDiagnosticsInfo() {
        YarnProtos.ContainerReportProtoOrBuilder p;
        YarnProtos.ContainerReportProtoOrBuilder containerReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasDiagnosticsInfo()) {
            return null;
        }
        return p.getDiagnosticsInfo();
    }

    @Override
    public ContainerState getContainerState() {
        YarnProtos.ContainerReportProtoOrBuilder p;
        YarnProtos.ContainerReportProtoOrBuilder containerReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasContainerState()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getContainerState());
    }

    @Override
    public long getFinishTime() {
        YarnProtos.ContainerReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getFinishTime();
    }

    @Override
    public String getLogUrl() {
        YarnProtos.ContainerReportProtoOrBuilder p;
        YarnProtos.ContainerReportProtoOrBuilder containerReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasLogUrl()) {
            return null;
        }
        return p.getLogUrl();
    }

    @Override
    public Priority getPriority() {
        YarnProtos.ContainerReportProtoOrBuilder p;
        if (this.priority != null) {
            return this.priority;
        }
        YarnProtos.ContainerReportProtoOrBuilder containerReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasPriority()) {
            return null;
        }
        this.priority = this.convertFromProtoFormat(p.getPriority());
        return this.priority;
    }

    @Override
    public long getCreationTime() {
        YarnProtos.ContainerReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getCreationTime();
    }

    @Override
    public void setAllocatedResource(Resource resource) {
        this.maybeInitBuilder();
        if (resource == null) {
            this.builder.clearResource();
        }
        this.resource = resource;
    }

    @Override
    public void setAssignedNode(NodeId nodeId) {
        this.maybeInitBuilder();
        if (nodeId == null) {
            this.builder.clearNodeId();
        }
        this.nodeId = nodeId;
    }

    @Override
    public void setContainerId(ContainerId containerId) {
        this.maybeInitBuilder();
        if (containerId == null) {
            this.builder.clearContainerId();
        }
        this.containerId = containerId;
    }

    @Override
    public void setDiagnosticsInfo(String diagnosticsInfo) {
        this.maybeInitBuilder();
        if (diagnosticsInfo == null) {
            this.builder.clearDiagnosticsInfo();
            return;
        }
        this.builder.setDiagnosticsInfo(diagnosticsInfo);
    }

    @Override
    public void setContainerState(ContainerState containerState) {
        this.maybeInitBuilder();
        if (containerState == null) {
            this.builder.clearContainerState();
            return;
        }
        this.builder.setContainerState(this.convertToProtoFormat(containerState));
    }

    @Override
    public int getContainerExitStatus() {
        YarnProtos.ContainerReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getContainerExitStatus();
    }

    @Override
    public void setContainerExitStatus(int containerExitStatus) {
        this.maybeInitBuilder();
        this.builder.setContainerExitStatus(containerExitStatus);
    }

    @Override
    public void setFinishTime(long finishTime) {
        this.maybeInitBuilder();
        this.builder.setFinishTime(finishTime);
    }

    @Override
    public void setLogUrl(String logUrl) {
        this.maybeInitBuilder();
        if (logUrl == null) {
            this.builder.clearLogUrl();
            return;
        }
        this.builder.setLogUrl(logUrl);
    }

    @Override
    public void setPriority(Priority priority) {
        this.maybeInitBuilder();
        if (priority == null) {
            this.builder.clearPriority();
        }
        this.priority = priority;
    }

    @Override
    public void setCreationTime(long creationTime) {
        this.maybeInitBuilder();
        this.builder.setCreationTime(creationTime);
    }

    public YarnProtos.ContainerReportProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ContainerReportPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    private void mergeLocalToBuilder() {
        if (this.containerId != null && !((ContainerIdPBImpl)this.containerId).getProto().equals(this.builder.getContainerId())) {
            this.builder.setContainerId(this.convertToProtoFormat(this.containerId));
        }
        if (this.nodeId != null && !((NodeIdPBImpl)this.nodeId).getProto().equals(this.builder.getNodeId())) {
            this.builder.setNodeId(this.convertToProtoFormat(this.nodeId));
        }
        if (this.resource != null && !((ResourcePBImpl)this.resource).getProto().equals(this.builder.getResource())) {
            this.builder.setResource(this.convertToProtoFormat(this.resource));
        }
        if (this.priority != null && !((PriorityPBImpl)this.priority).getProto().equals(this.builder.getPriority())) {
            this.builder.setPriority(this.convertToProtoFormat(this.priority));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ContainerReportProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private NodeIdPBImpl convertFromProtoFormat(YarnProtos.NodeIdProto p) {
        return new NodeIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }

    private YarnProtos.NodeIdProto convertToProtoFormat(NodeId t) {
        return ((NodeIdPBImpl)t).getProto();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource t) {
        return ((ResourcePBImpl)t).getProto();
    }

    private PriorityPBImpl convertFromProtoFormat(YarnProtos.PriorityProto p) {
        return new PriorityPBImpl(p);
    }

    private YarnProtos.PriorityProto convertToProtoFormat(Priority p) {
        return ((PriorityPBImpl)p).getProto();
    }

    private YarnProtos.ContainerStateProto convertToProtoFormat(ContainerState containerState) {
        return ProtoUtils.convertToProtoFormat(containerState);
    }

    private ContainerState convertFromProtoFormat(YarnProtos.ContainerStateProto containerState) {
        return ProtoUtils.convertFromProtoFormat(containerState);
    }
}

