/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.util.Clock;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AbstractLivelinessMonitor<O>
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(AbstractLivelinessMonitor.class);
    private Thread checkerThread;
    private volatile boolean stopped;
    public static final int DEFAULT_EXPIRE = 300000;
    private int expireInterval = 300000;
    private int monitorInterval = this.expireInterval / 3;
    private final Clock clock;
    private Map<O, Long> running = new HashMap<O, Long>();

    public AbstractLivelinessMonitor(String name, Clock clock) {
        super(name);
        this.clock = clock;
    }

    @Override
    protected void serviceStart() throws Exception {
        assert (!this.stopped) : "starting when already stopped";
        this.checkerThread = new Thread(new PingChecker());
        this.checkerThread.setName("Ping Checker");
        this.checkerThread.start();
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        this.stopped = true;
        if (this.checkerThread != null) {
            this.checkerThread.interrupt();
        }
        super.serviceStop();
    }

    protected abstract void expire(O var1);

    protected void setExpireInterval(int expireInterval) {
        this.expireInterval = expireInterval;
    }

    protected void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public synchronized void receivedPing(O ob) {
        if (this.running.containsKey(ob)) {
            this.running.put(ob, this.clock.getTime());
        }
    }

    public synchronized void register(O ob) {
        this.running.put(ob, this.clock.getTime());
    }

    public synchronized void unregister(O ob) {
        this.running.remove(ob);
    }

    private class PingChecker
    implements Runnable {
        private PingChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!AbstractLivelinessMonitor.this.stopped && !Thread.currentThread().isInterrupted()) {
                AbstractLivelinessMonitor abstractLivelinessMonitor = AbstractLivelinessMonitor.this;
                synchronized (abstractLivelinessMonitor) {
                    Iterator iterator = AbstractLivelinessMonitor.this.running.entrySet().iterator();
                    long currentTime = AbstractLivelinessMonitor.this.clock.getTime();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (currentTime <= (Long)entry.getValue() + (long)AbstractLivelinessMonitor.this.expireInterval) continue;
                        iterator.remove();
                        AbstractLivelinessMonitor.this.expire(entry.getKey());
                        LOG.info("Expired:" + entry.getKey().toString() + " Timed out after " + AbstractLivelinessMonitor.this.expireInterval / 1000 + " secs");
                    }
                }
                try {
                    Thread.sleep(AbstractLivelinessMonitor.this.monitorInterval);
                }
                catch (InterruptedException e) {
                    LOG.info(AbstractLivelinessMonitor.this.getName() + " thread interrupted");
                    break;
                }
            }
        }
    }
}

