/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.internal.SystemPropertyUtil;

final class NioProviderMetadata {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(NioProviderMetadata.class);
    private static final String CONSTRAINT_LEVEL_PROPERTY = "org.jboss.netty.channel.socket.nio.constraintLevel";
    private static final String OLD_CONSTRAINT_LEVEL_PROPERTY = "java.nio.channels.spi.constraintLevel";
    static final int CONSTRAINT_LEVEL;

    private static int detectConstraintLevelFromSystemProperties() {
        String provider;
        String version = SystemPropertyUtil.get("java.specification.version");
        String vminfo = SystemPropertyUtil.get("java.vm.info", "");
        String os = SystemPropertyUtil.get("os.name");
        String vendor = SystemPropertyUtil.get("java.vm.vendor");
        try {
            provider = SelectorProvider.provider().getClass().getName();
        }
        catch (Exception e) {
            provider = null;
        }
        if (version == null || os == null || vendor == null || provider == null) {
            return -1;
        }
        os = os.toLowerCase();
        if ((vendor = vendor.toLowerCase()).contains("sun")) {
            if (os.contains("linux") ? provider.equals("sun.nio.ch.EPollSelectorProvider") || provider.equals("sun.nio.ch.PollSelectorProvider") : (os.contains("windows") ? provider.equals("sun.nio.ch.WindowsSelectorProvider") : (os.contains("sun") || os.contains("solaris")) && provider.equals("sun.nio.ch.DevPollSelectorProvider"))) {
                return 0;
            }
        } else if (vendor.contains("apple")) {
            if (os.contains("mac") && os.contains("os") && provider.equals("sun.nio.ch.KQueueSelectorProvider")) {
                return 0;
            }
        } else if (vendor.contains("ibm")) {
            if (os.contains("linux") || os.contains("aix")) {
                Pattern datePattern;
                Matcher dateMatcher;
                if (version.equals("1.5") || version.matches("^1\\.5\\D.*$")) {
                    if (provider.equals("sun.nio.ch.PollSelectorProvider")) {
                        return 1;
                    }
                } else if ((version.equals("1.6") || version.matches("^1\\.6\\D.*$")) && (dateMatcher = (datePattern = Pattern.compile("(?:^|[^0-9])([2-9][0-9]{3}(?:0[1-9]|1[0-2])(?:0[1-9]|[12][0-9]|3[01]))(?:$|[^0-9])")).matcher(vminfo)).find()) {
                    long dateValue = Long.parseLong(dateMatcher.group(1));
                    if (dateValue < 20081105L) {
                        return 2;
                    }
                    if (provider.equals("sun.nio.ch.EPollSelectorProvider")) {
                        return 0;
                    }
                    if (provider.equals("sun.nio.ch.PollSelectorProvider")) {
                        return 1;
                    }
                }
            }
        } else if (vendor.contains("bea") || vendor.contains("oracle")) {
            if (os.contains("linux") ? provider.equals("sun.nio.ch.EPollSelectorProvider") || provider.equals("sun.nio.ch.PollSelectorProvider") : os.contains("windows") && provider.equals("sun.nio.ch.WindowsSelectorProvider")) {
                return 0;
            }
        } else if (vendor.contains("apache") && provider.equals("org.apache.harmony.nio.internal.SelectorProviderImpl")) {
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static int autodetect() {
        int constraintLevel;
        block100: {
            Throwable e3222222222;
            SelectorLoop loop;
            ServerSocketChannel ch;
            ExecutorService executor;
            block97: {
                block96: {
                    long startTime;
                    int i;
                    executor = Executors.newCachedThreadPool();
                    ch = null;
                    loop = null;
                    ch = ServerSocketChannel.open();
                    try {
                        ch.socket().bind(new InetSocketAddress(0));
                        ch.configureBlocking(false);
                    }
                    catch (Throwable e2) {
                        int n;
                        block87: {
                            Throwable e3222222222;
                            block84: {
                                if (logger.isWarnEnabled()) {
                                    logger.warn("Failed to configure a temporary socket.", e2);
                                }
                                n = -1;
                                Object var13_13 = null;
                                if (ch != null) {
                                    try {
                                        ch.close();
                                    }
                                    catch (Throwable e3222222222) {
                                        if (!logger.isWarnEnabled()) break block84;
                                        logger.warn("Failed to close a temporary socket.", e3222222222);
                                    }
                                }
                            }
                            if (loop != null) {
                                loop.done = true;
                                try {
                                    executor.shutdownNow();
                                }
                                catch (NullPointerException ex) {
                                    // empty catch block
                                }
                                try {
                                    while (true) {
                                        loop.selector.wakeup();
                                        try {
                                            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                        }
                                        catch (InterruptedException e3222222222) {
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable e3222222222) {
                                    // empty catch block
                                }
                                try {
                                    loop.selector.close();
                                }
                                catch (Throwable e3222222222) {
                                    if (!logger.isWarnEnabled()) break block87;
                                    logger.warn("Failed to close a temporary selector.", e3222222222);
                                }
                            }
                        }
                        return n;
                    }
                    try {
                        loop = new SelectorLoop();
                    }
                    catch (Throwable e4) {
                        int n;
                        block91: {
                            Throwable e3222222222;
                            block88: {
                                if (logger.isWarnEnabled()) {
                                    logger.warn("Failed to open a temporary selector.", e4);
                                }
                                n = -1;
                                Object var13_14 = null;
                                if (ch != null) {
                                    try {
                                        ch.close();
                                    }
                                    catch (Throwable e3222222222) {
                                        if (!logger.isWarnEnabled()) break block88;
                                        logger.warn("Failed to close a temporary socket.", e3222222222);
                                    }
                                }
                            }
                            if (loop != null) {
                                loop.done = true;
                                try {
                                    executor.shutdownNow();
                                }
                                catch (NullPointerException ex) {
                                    // empty catch block
                                }
                                try {
                                    while (true) {
                                        loop.selector.wakeup();
                                        try {
                                            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                        }
                                        catch (InterruptedException e3222222222) {
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable e3222222222) {
                                    // empty catch block
                                }
                                try {
                                    loop.selector.close();
                                }
                                catch (Throwable e3222222222) {
                                    if (!logger.isWarnEnabled()) break block91;
                                    logger.warn("Failed to close a temporary selector.", e3222222222);
                                }
                            }
                        }
                        return n;
                    }
                    try {
                        ch.register(loop.selector, 0);
                    }
                    catch (Throwable e5) {
                        int n;
                        block95: {
                            Throwable e3222222222;
                            block92: {
                                if (logger.isWarnEnabled()) {
                                    logger.warn("Failed to register a temporary selector.", e5);
                                }
                                n = -1;
                                Object var13_15 = null;
                                if (ch != null) {
                                    try {
                                        ch.close();
                                    }
                                    catch (Throwable e3222222222) {
                                        if (!logger.isWarnEnabled()) break block92;
                                        logger.warn("Failed to close a temporary socket.", e3222222222);
                                    }
                                }
                            }
                            if (loop != null) {
                                loop.done = true;
                                try {
                                    executor.shutdownNow();
                                }
                                catch (NullPointerException ex) {
                                    // empty catch block
                                }
                                try {
                                    while (true) {
                                        loop.selector.wakeup();
                                        try {
                                            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                        }
                                        catch (InterruptedException e3222222222) {
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable e3222222222) {
                                    // empty catch block
                                }
                                try {
                                    loop.selector.close();
                                }
                                catch (Throwable e3222222222) {
                                    if (!logger.isWarnEnabled()) break block95;
                                    logger.warn("Failed to close a temporary selector.", e3222222222);
                                }
                            }
                        }
                        return n;
                    }
                    SelectionKey key = ch.keyFor(loop.selector);
                    executor.execute(loop);
                    boolean success = true;
                    for (i = 0; i < 10; ++i) {
                        while (true) {
                            if (!loop.selecting) {
                                Thread.yield();
                                continue;
                            }
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e6) {
                                // empty catch block
                            }
                            if (loop.selecting) break;
                        }
                        startTime = System.nanoTime();
                        key.interestOps(key.interestOps() | 0x10);
                        key.interestOps(key.interestOps() & 0xFFFFFFEF);
                        if (System.nanoTime() - startTime < 500000000L) continue;
                        success = false;
                        break;
                    }
                    if (success) {
                        constraintLevel = 0;
                        break block96;
                    }
                    success = true;
                    for (i = 0; i < 10; ++i) {
                        while (true) {
                            if (!loop.selecting) {
                                Thread.yield();
                                continue;
                            }
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e7) {
                                // empty catch block
                            }
                            if (loop.selecting) break;
                        }
                        startTime = System.nanoTime();
                        int interestOps = key.interestOps();
                        SelectorLoop selectorLoop = loop;
                        synchronized (selectorLoop) {
                            loop.selector.wakeup();
                            key.interestOps(interestOps | 0x10);
                            key.interestOps(interestOps & 0xFFFFFFEF);
                        }
                        if (System.nanoTime() - startTime < 500000000L) continue;
                        success = false;
                        break;
                    }
                    if (success) {
                        constraintLevel = 1;
                        break block96;
                    }
                    constraintLevel = 2;
                }
                Object var13_16 = null;
                if (ch == null) break block97;
                try {
                    ch.close();
                }
                catch (Throwable e3222222222) {
                    if (!logger.isWarnEnabled()) break block97;
                    logger.warn("Failed to close a temporary socket.", e3222222222);
                }
            }
            if (loop != null) {
                loop.done = true;
                try {
                    executor.shutdownNow();
                }
                catch (NullPointerException ex) {
                    // empty catch block
                }
                try {
                    while (true) {
                        loop.selector.wakeup();
                        try {
                            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                        }
                        catch (InterruptedException e3222222222) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e3222222222) {
                    // empty catch block
                }
                try {
                    loop.selector.close();
                }
                catch (Throwable e3222222222) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Failed to close a temporary selector.", e3222222222);
                    }
                    break block100;
                }
            }
            break block100;
            {
                catch (Throwable e8) {
                    int n;
                    block104: {
                        Throwable e3222222222;
                        block101: {
                            n = -1;
                            Object var13_17 = null;
                            if (ch != null) {
                                try {
                                    ch.close();
                                }
                                catch (Throwable e3222222222) {
                                    if (!logger.isWarnEnabled()) break block101;
                                    logger.warn("Failed to close a temporary socket.", e3222222222);
                                }
                            }
                        }
                        if (loop != null) {
                            loop.done = true;
                            try {
                                executor.shutdownNow();
                            }
                            catch (NullPointerException ex) {
                                // empty catch block
                            }
                            try {
                                while (true) {
                                    loop.selector.wakeup();
                                    try {
                                        if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                    }
                                    catch (InterruptedException e3222222222) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Throwable e3222222222) {
                                // empty catch block
                            }
                            try {
                                loop.selector.close();
                            }
                            catch (Throwable e3222222222) {
                                if (!logger.isWarnEnabled()) break block104;
                                logger.warn("Failed to close a temporary selector.", e3222222222);
                            }
                        }
                    }
                    return n;
                }
            }
            catch (Throwable throwable) {
                block107: {
                    Throwable e3222222222;
                    block105: {
                        Object var13_18 = null;
                        if (ch != null) {
                            try {
                                ch.close();
                            }
                            catch (Throwable e3222222222) {
                                if (!logger.isWarnEnabled()) break block105;
                                logger.warn("Failed to close a temporary socket.", e3222222222);
                            }
                        }
                    }
                    if (loop != null) {
                        loop.done = true;
                        try {
                            executor.shutdownNow();
                        }
                        catch (NullPointerException ex) {
                            // empty catch block
                        }
                        try {
                            while (true) {
                                loop.selector.wakeup();
                                try {
                                    if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                }
                                catch (InterruptedException e3222222222) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Throwable e3222222222) {
                            // empty catch block
                        }
                        try {
                            loop.selector.close();
                        }
                        catch (Throwable e3222222222) {
                            if (!logger.isWarnEnabled()) break block107;
                            logger.warn("Failed to close a temporary selector.", e3222222222);
                        }
                    }
                }
                throw throwable;
            }
        }
        return constraintLevel;
    }

    public static void main(String[] args) throws Exception {
        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
            System.out.println(e.getKey() + ": " + e.getValue());
        }
        System.out.println();
        System.out.println("Hard-coded Constraint Level: " + CONSTRAINT_LEVEL);
        System.out.println("Auto-detected Constraint Level: " + NioProviderMetadata.autodetect());
    }

    private NioProviderMetadata() {
    }

    static {
        int constraintLevel = -1;
        constraintLevel = SystemPropertyUtil.getInt(CONSTRAINT_LEVEL_PROPERTY, -1);
        if (constraintLevel < 0 || constraintLevel > 2) {
            constraintLevel = SystemPropertyUtil.getInt(OLD_CONSTRAINT_LEVEL_PROPERTY, -1);
            if (constraintLevel < 0 || constraintLevel > 2) {
                constraintLevel = -1;
            } else {
                logger.warn("System property 'java.nio.channels.spi.constraintLevel' has been deprecated.  Use 'org.jboss.netty.channel.socket.nio.constraintLevel' instead.");
            }
        }
        if (constraintLevel >= 0) {
            logger.debug("Setting the NIO constraint level to: " + constraintLevel);
        }
        if (constraintLevel < 0) {
            constraintLevel = NioProviderMetadata.detectConstraintLevelFromSystemProperties();
            if (constraintLevel < 0) {
                constraintLevel = 2;
                if (logger.isDebugEnabled()) {
                    logger.debug("Couldn't determine the NIO constraint level from the system properties; using the safest level (2)");
                }
            } else if (constraintLevel != 0) {
                if (logger.isInfoEnabled()) {
                    logger.info("Using the autodetected NIO constraint level: " + constraintLevel + " (Use better NIO provider for better performance)");
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Using the autodetected NIO constraint level: " + constraintLevel);
            }
        }
        if ((CONSTRAINT_LEVEL = constraintLevel) < 0 || CONSTRAINT_LEVEL > 2) {
            throw new Error("Unexpected NIO constraint level: " + CONSTRAINT_LEVEL + ", please report this error.");
        }
    }

    private static final class SelectorLoop
    implements Runnable {
        final Selector selector = Selector.open();
        volatile boolean done;
        volatile boolean selecting;

        SelectorLoop() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.done) {
                SelectorLoop selectorLoop = this;
                synchronized (selectorLoop) {
                }
                try {
                    Object var4_7;
                    this.selecting = true;
                    try {
                        this.selector.select(1000L);
                        var4_7 = null;
                        this.selecting = false;
                    }
                    catch (Throwable throwable) {
                        var4_7 = null;
                        this.selecting = false;
                        throw throwable;
                    }
                    Set<SelectionKey> keys = this.selector.selectedKeys();
                    for (SelectionKey k : keys) {
                        k.interestOps(0);
                    }
                    keys.clear();
                }
                catch (IOException e) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("Failed to wait for a temporary selector.", e);
                }
            }
        }
    }
}

