/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.stats;

class Stopwatch {
    public static final Ticks SYSTEM_TICKS = new SystemTicks();
    private Ticks ticks;
    private long start;
    private long elapsed = -1L;
    private boolean running;

    public Stopwatch(Ticks ticks) {
        this.ticks = ticks;
    }

    public long elapsedNanos() {
        if (this.running) {
            return this.ticks.ticks() - this.start;
        }
        if (this.elapsed == -1L) {
            throw new IllegalStateException();
        }
        return this.elapsed;
    }

    public void start() {
        if (this.running) {
            throw new IllegalStateException();
        }
        this.start = this.ticks.ticks();
        this.running = true;
    }

    public void stop() {
        if (!this.running) {
            throw new IllegalStateException();
        }
        this.elapsed = this.ticks.ticks() - this.start;
        this.running = false;
    }

    private static class SystemTicks
    implements Ticks {
        private SystemTicks() {
        }

        @Override
        public long ticks() {
            return System.nanoTime();
        }
    }

    static interface Ticks {
        public long ticks();
    }
}

