/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;

public class Resolver {
    public static Action resolve(Schema writer, Schema reader, GenericData data) {
        return Resolver.resolve(Schema.applyAliases(writer, reader), reader, data, new HashMap<Schema.SeenPair, Action>());
    }

    public static Action resolve(Schema writer, Schema reader) {
        return Resolver.resolve(writer, reader, GenericData.get());
    }

    private static Action resolve(Schema w, Schema r, GenericData d, Map<Schema.SeenPair, Action> seen) {
        Schema.Type wType = w.getType();
        Schema.Type rType = r.getType();
        if (wType == Schema.Type.UNION) {
            return WriterUnion.resolve(w, r, d, seen);
        }
        if (wType == rType) {
            switch (wType) {
                case NULL: 
                case BOOLEAN: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case STRING: 
                case BYTES: {
                    return new DoNothing(w, r, d);
                }
                case FIXED: {
                    if (w.getFullName() != null && !w.getFullName().equals(r.getFullName())) {
                        return new ErrorAction(w, r, d, ErrorAction.ErrorType.NAMES_DONT_MATCH);
                    }
                    if (w.getFixedSize() != r.getFixedSize()) {
                        return new ErrorAction(w, r, d, ErrorAction.ErrorType.SIZES_DONT_MATCH);
                    }
                    return new DoNothing(w, r, d);
                }
                case ARRAY: {
                    Action et = Resolver.resolve(w.getElementType(), r.getElementType(), d, seen);
                    return new Container(w, r, d, et);
                }
                case MAP: {
                    Action vt = Resolver.resolve(w.getValueType(), r.getValueType(), d, seen);
                    return new Container(w, r, d, vt);
                }
                case ENUM: {
                    return EnumAdjust.resolve(w, r, d);
                }
                case RECORD: {
                    return RecordAdjust.resolve(w, r, d, seen);
                }
            }
            throw new IllegalArgumentException("Unknown type for schema: " + (Object)((Object)wType));
        }
        if (rType == Schema.Type.UNION) {
            return ReaderUnion.resolve(w, r, d, seen);
        }
        return Promote.resolve(w, r, d);
    }

    private static boolean unionEquiv(Schema w, Schema r, Map<Schema.SeenPair, Boolean> seen) {
        Schema.Type wt = w.getType();
        if (wt != r.getType()) {
            return false;
        }
        if (!(wt != Schema.Type.RECORD && wt != Schema.Type.FIXED && wt != Schema.Type.ENUM || w.getName() == null || w.getName().equals(r.getName()))) {
            return false;
        }
        switch (w.getType()) {
            case NULL: 
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BYTES: {
                return true;
            }
            case ARRAY: {
                return Resolver.unionEquiv(w.getElementType(), r.getElementType(), seen);
            }
            case MAP: {
                return Resolver.unionEquiv(w.getValueType(), r.getValueType(), seen);
            }
            case FIXED: {
                return w.getFixedSize() == r.getFixedSize();
            }
            case ENUM: {
                List<String> ws = w.getEnumSymbols();
                List<String> rs = r.getEnumSymbols();
                if (ws.size() != rs.size()) {
                    return false;
                }
                int i = 0;
                for (i = 0; i < ws.size() && ws.get(i).equals(rs.get(i)); ++i) {
                }
                return i == ws.size();
            }
            case UNION: {
                List<Schema> wb = w.getTypes();
                List<Schema> rb = r.getTypes();
                if (wb.size() != rb.size()) {
                    return false;
                }
                int i = 0;
                for (i = 0; i < wb.size() && Resolver.unionEquiv(wb.get(i), rb.get(i), seen); ++i) {
                }
                return i == wb.size();
            }
            case RECORD: {
                Schema.SeenPair wsc = new Schema.SeenPair(w, r);
                if (!seen.containsKey(wsc)) {
                    seen.put(wsc, true);
                    List<Schema.Field> wb = w.getFields();
                    List<Schema.Field> rb = r.getFields();
                    if (wb.size() != rb.size()) {
                        seen.put(wsc, false);
                    } else {
                        int i = 0;
                        for (i = 0; i < wb.size() && Resolver.unionEquiv(wb.get(i).schema(), rb.get(i).schema(), seen); ++i) {
                        }
                        seen.put(wsc, i == wb.size());
                    }
                }
                return seen.get(wsc);
            }
        }
        throw new IllegalArgumentException("Unknown schema type: " + (Object)((Object)w.getType()));
    }

    public static class ReaderUnion
    extends Action {
        public final int firstMatch;
        public final Action actualAction;

        public ReaderUnion(Schema w, Schema r, GenericData d, int firstMatch, Action actual) {
            super(w, r, d, Action.Type.READER_UNION);
            this.firstMatch = firstMatch;
            this.actualAction = actual;
        }

        public static Action resolve(Schema w, Schema r, GenericData d, Map<Schema.SeenPair, Action> seen) {
            if (w.getType() == Schema.Type.UNION) {
                throw new IllegalArgumentException("Writer schema is union.");
            }
            int i = ReaderUnion.firstMatchingBranch(w, r, d, seen);
            if (0 <= i) {
                return new ReaderUnion(w, r, d, i, Resolver.resolve(w, r.getTypes().get(i), d, seen));
            }
            return new ErrorAction(w, r, d, ErrorAction.ErrorType.NO_MATCHING_BRANCH);
        }

        private static int firstMatchingBranch(Schema w, Schema r, GenericData d, Map<Schema.SeenPair, Action> seen) {
            Schema.Type vt = w.getType();
            int j = 0;
            int structureMatch = -1;
            for (Schema b : r.getTypes()) {
                if (vt == b.getType()) {
                    if (vt == Schema.Type.RECORD || vt == Schema.Type.ENUM || vt == Schema.Type.FIXED) {
                        String vname = w.getFullName();
                        String bname = b.getFullName();
                        if (vname != null && vname.equals(bname)) {
                            return j;
                        }
                        if (vt == Schema.Type.RECORD && !ReaderUnion.hasMatchError(RecordAdjust.resolve(w, b, d, seen))) {
                            String vShortName = w.getName();
                            String bShortName = b.getName();
                            if (structureMatch < 0 || vShortName != null && vShortName.equals(bShortName)) {
                                structureMatch = j;
                            }
                        }
                    } else {
                        return j;
                    }
                }
                ++j;
            }
            if (structureMatch >= 0) {
                return structureMatch;
            }
            j = 0;
            for (Schema b : r.getTypes()) {
                switch (vt) {
                    case INT: {
                        switch (b.getType()) {
                            case LONG: 
                            case FLOAT: 
                            case DOUBLE: {
                                return j;
                            }
                        }
                        break;
                    }
                    case LONG: {
                        switch (b.getType()) {
                            case FLOAT: 
                            case DOUBLE: {
                                return j;
                            }
                        }
                        break;
                    }
                    case FLOAT: {
                        switch (b.getType()) {
                            case DOUBLE: {
                                return j;
                            }
                        }
                        break;
                    }
                    case STRING: {
                        switch (b.getType()) {
                            case BYTES: {
                                return j;
                            }
                        }
                        break;
                    }
                    case BYTES: {
                        switch (b.getType()) {
                            case STRING: {
                                return j;
                            }
                        }
                    }
                }
                ++j;
            }
            return -1;
        }

        private static boolean hasMatchError(Action action) {
            if (action instanceof ErrorAction) {
                return true;
            }
            for (Action a : ((RecordAdjust)action).fieldActions) {
                if (!(a instanceof ErrorAction)) continue;
                return true;
            }
            return false;
        }
    }

    public static class WriterUnion
    extends Action {
        public final Action[] actions;
        public final boolean unionEquiv;

        private WriterUnion(Schema w, Schema r, GenericData d, boolean ue, Action[] a) {
            super(w, r, d, Action.Type.WRITER_UNION);
            this.unionEquiv = ue;
            this.actions = a;
        }

        public static Action resolve(Schema w, Schema r, GenericData d, Map<Schema.SeenPair, Action> seen) {
            boolean ueqv = Resolver.unionEquiv(w, r, new HashMap());
            List<Schema> wb = w.getTypes();
            List<Schema> rb = ueqv ? r.getTypes() : null;
            int sz = wb.size();
            Action[] actions = new Action[sz];
            for (int i = 0; i < sz; ++i) {
                actions[i] = Resolver.resolve(wb.get(i), ueqv ? rb.get(i) : r, d, seen);
            }
            return new WriterUnion(w, r, d, ueqv, actions);
        }
    }

    public static class RecordAdjust
    extends Action {
        public final Action[] fieldActions;
        public final Schema.Field[] readerOrder;
        public final int firstDefault;
        public final Object[] defaults;

        public boolean noReorder() {
            boolean result = true;
            for (int i = 0; result && i < this.readerOrder.length; result &= i == this.readerOrder[i].pos(), ++i) {
            }
            return result;
        }

        private RecordAdjust(Schema w, Schema r, GenericData d, Action[] fa, Schema.Field[] ro, int firstD, Object[] defaults) {
            super(w, r, d, Action.Type.RECORD);
            this.fieldActions = fa;
            this.readerOrder = ro;
            this.firstDefault = firstD;
            this.defaults = defaults;
        }

        static Action resolve(Schema w, Schema r, GenericData d, Map<Schema.SeenPair, Action> seen) {
            Schema.SeenPair wr = new Schema.SeenPair(w, r);
            Action result = seen.get(wr);
            if (result != null) {
                return result;
            }
            List<Schema.Field> wfields = w.getFields();
            List<Schema.Field> rfields = r.getFields();
            int firstDefault = 0;
            for (Schema.Field wf : wfields) {
                if (r.getField(wf.name()) == null) continue;
                ++firstDefault;
            }
            Action[] actions = new Action[wfields.size()];
            Schema.Field[] reordered = new Schema.Field[rfields.size()];
            Object[] defaults = new Object[reordered.length - firstDefault];
            result = new RecordAdjust(w, r, d, actions, reordered, firstDefault, defaults);
            seen.put(wr, result);
            int i = 0;
            int ridx = 0;
            for (Schema.Field wField : wfields) {
                Schema.Field rField = r.getField(wField.name());
                if (rField != null) {
                    reordered[ridx++] = rField;
                    actions[i++] = Resolver.resolve(wField.schema(), rField.schema(), d, seen);
                    continue;
                }
                actions[i++] = new Skip(wField.schema(), d);
            }
            for (Schema.Field rf : rfields) {
                if (w.getField(rf.name()) != null) continue;
                if (rf.defaultValue() == null) {
                    result = new ErrorAction(w, r, d, ErrorAction.ErrorType.MISSING_REQUIRED_FIELD);
                    seen.put(wr, result);
                    return result;
                }
                defaults[ridx - firstDefault] = d.getDefaultValue(rf);
                reordered[ridx++] = rf;
            }
            return result;
        }
    }

    public static class Skip
    extends Action {
        public Skip(Schema w, GenericData d) {
            super(w, null, d, Action.Type.SKIP);
        }
    }

    public static class EnumAdjust
    extends Action {
        public final int[] adjustments;
        public final boolean noAdjustmentsNeeded;

        private EnumAdjust(Schema w, Schema r, GenericData d, int[] adj) {
            super(w, r, d, Action.Type.ENUM);
            this.adjustments = adj;
            int rsymCount = r.getEnumSymbols().size();
            int count = Math.min(rsymCount, adj.length);
            boolean noAdj = adj.length <= rsymCount;
            for (int i = 0; noAdj && i < count; noAdj &= i == adj[i], ++i) {
            }
            this.noAdjustmentsNeeded = noAdj;
        }

        public static Action resolve(Schema w, Schema r, GenericData d) {
            if (w.getFullName() != null && !w.getFullName().equals(r.getFullName())) {
                return new ErrorAction(w, r, d, ErrorAction.ErrorType.NAMES_DONT_MATCH);
            }
            List<String> wsymbols = w.getEnumSymbols();
            List<String> rsymbols = r.getEnumSymbols();
            int defaultIndex = r.getEnumDefault() == null ? -1 : rsymbols.indexOf(r.getEnumDefault());
            int[] adjustments = new int[wsymbols.size()];
            for (int i = 0; i < adjustments.length; ++i) {
                int j = rsymbols.indexOf(wsymbols.get(i));
                adjustments[i] = 0 <= j ? j : defaultIndex;
            }
            return new EnumAdjust(w, r, d, adjustments);
        }
    }

    public static class Container
    extends Action {
        public final Action elementAction;

        public Container(Schema w, Schema r, GenericData d, Action e) {
            super(w, r, d, Action.Type.CONTAINER);
            this.elementAction = e;
        }
    }

    public static class Promote
    extends Action {
        private Promote(Schema w, Schema r, GenericData d) {
            super(w, r, d, Action.Type.PROMOTE);
        }

        public static Action resolve(Schema w, Schema r, GenericData d) {
            if (Promote.isValid(w, r)) {
                return new Promote(w, r, d);
            }
            return new ErrorAction(w, r, d, ErrorAction.ErrorType.INCOMPATIBLE_SCHEMA_TYPES);
        }

        public static boolean isValid(Schema w, Schema r) {
            if (w.getType() == r.getType()) {
                throw new IllegalArgumentException("Only use when reader and writer are different.");
            }
            Schema.Type wt = w.getType();
            switch (r.getType()) {
                case INT: {
                    switch (wt) {
                        case INT: {
                            return true;
                        }
                    }
                    break;
                }
                case LONG: {
                    switch (wt) {
                        case INT: 
                        case LONG: {
                            return true;
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (wt) {
                        case INT: 
                        case LONG: 
                        case FLOAT: {
                            return true;
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    switch (wt) {
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: {
                            return true;
                        }
                    }
                    break;
                }
                case STRING: 
                case BYTES: {
                    switch (wt) {
                        case STRING: 
                        case BYTES: {
                            return true;
                        }
                    }
                }
            }
            return false;
        }
    }

    public static class ErrorAction
    extends Action {
        public final ErrorType error;

        public ErrorAction(Schema w, Schema r, GenericData d, ErrorType e) {
            super(w, r, d, Action.Type.ERROR);
            this.error = e;
        }

        public String toString() {
            switch (this.error) {
                case INCOMPATIBLE_SCHEMA_TYPES: 
                case NAMES_DONT_MATCH: 
                case SIZES_DONT_MATCH: 
                case NO_MATCHING_BRANCH: {
                    return "Found " + this.writer.getFullName() + ", expecting " + this.reader.getFullName();
                }
                case MISSING_REQUIRED_FIELD: {
                    List<Schema.Field> wfields = this.writer.getFields();
                    List<Schema.Field> rfields = this.reader.getFields();
                    String fname = "<oops>";
                    for (Schema.Field rf : rfields) {
                        if (this.writer.getField(rf.name()) != null || rf.defaultValue() != null) continue;
                        fname = rf.name();
                    }
                    return "Found " + this.writer.getFullName() + ", expecting " + this.reader.getFullName() + ", missing required field " + fname;
                }
            }
            throw new IllegalArgumentException("Unknown error.");
        }

        public static enum ErrorType {
            INCOMPATIBLE_SCHEMA_TYPES,
            NAMES_DONT_MATCH,
            SIZES_DONT_MATCH,
            MISSING_REQUIRED_FIELD,
            NO_MATCHING_BRANCH;

        }
    }

    public static class DoNothing
    extends Action {
        public DoNothing(Schema w, Schema r, GenericData d) {
            super(w, r, d, Action.Type.DO_NOTHING);
        }
    }

    public static abstract class Action {
        public final Schema writer;
        public final Schema reader;
        public final Type type;
        public final LogicalType logicalType;
        public final Conversion<?> conversion;

        protected Action(Schema w, Schema r, GenericData data, Type t) {
            this.writer = w;
            this.reader = r;
            this.type = t;
            if (r == null) {
                this.logicalType = null;
                this.conversion = null;
            } else {
                this.logicalType = r.getLogicalType();
                this.conversion = data.getConversionFor(this.logicalType);
            }
        }

        public static enum Type {
            DO_NOTHING,
            ERROR,
            PROMOTE,
            CONTAINER,
            ENUM,
            SKIP,
            RECORD,
            WRITER_UNION,
            READER_UNION;

        }
    }
}

