/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.InvalidRequestException;
import org.apache.hadoop.fs.permission.FsPermission;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CachePoolInfo {
    public static final Log LOG = LogFactory.getLog(CachePoolInfo.class);
    public static final long RELATIVE_EXPIRY_NEVER = 0x1FFFFFFFFFFFFFFFL;
    public static final long DEFAULT_MAX_RELATIVE_EXPIRY = 0x1FFFFFFFFFFFFFFFL;
    public static final long LIMIT_UNLIMITED = Long.MAX_VALUE;
    public static final long DEFAULT_LIMIT = Long.MAX_VALUE;
    final String poolName;
    @Nullable
    String ownerName;
    @Nullable
    String groupName;
    @Nullable
    FsPermission mode;
    @Nullable
    Long limit;
    @Nullable
    Long maxRelativeExpiryMs;

    public CachePoolInfo(String poolName) {
        this.poolName = poolName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public CachePoolInfo setOwnerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public CachePoolInfo setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public FsPermission getMode() {
        return this.mode;
    }

    public CachePoolInfo setMode(FsPermission mode) {
        this.mode = mode;
        return this;
    }

    public Long getLimit() {
        return this.limit;
    }

    public CachePoolInfo setLimit(Long bytes) {
        this.limit = bytes;
        return this;
    }

    public Long getMaxRelativeExpiryMs() {
        return this.maxRelativeExpiryMs;
    }

    public CachePoolInfo setMaxRelativeExpiryMs(Long ms) {
        this.maxRelativeExpiryMs = ms;
        return this;
    }

    public String toString() {
        return "{" + "poolName:" + this.poolName + ", ownerName:" + this.ownerName + ", groupName:" + this.groupName + ", mode:" + (this.mode == null ? "null" : String.format("0%03o", this.mode.toShort())) + ", limit:" + this.limit + ", maxRelativeExpiryMs:" + this.maxRelativeExpiryMs + "}";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        CachePoolInfo other = (CachePoolInfo)o;
        return new EqualsBuilder().append(this.poolName, other.poolName).append(this.ownerName, other.ownerName).append(this.groupName, other.groupName).append(this.mode, other.mode).append(this.limit, other.limit).append(this.maxRelativeExpiryMs, other.maxRelativeExpiryMs).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.poolName).append(this.ownerName).append(this.groupName).append(this.mode).append(this.limit).append(this.maxRelativeExpiryMs).hashCode();
    }

    public static void validate(CachePoolInfo info) throws IOException {
        if (info == null) {
            throw new InvalidRequestException("CachePoolInfo is null");
        }
        if (info.getLimit() != null && info.getLimit() < 0L) {
            throw new InvalidRequestException("Limit is negative.");
        }
        if (info.getMaxRelativeExpiryMs() != null) {
            long maxRelativeExpiryMs = info.getMaxRelativeExpiryMs();
            if (maxRelativeExpiryMs < 0L) {
                throw new InvalidRequestException("Max relative expiry is negative.");
            }
            if (maxRelativeExpiryMs > 0x1FFFFFFFFFFFFFFFL) {
                throw new InvalidRequestException("Max relative expiry is too big.");
            }
        }
        CachePoolInfo.validateName(info.poolName);
    }

    public static void validateName(String poolName) throws IOException {
        if (poolName == null || poolName.isEmpty()) {
            throw new IOException("invalid empty cache pool name");
        }
    }
}

