/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DelegationTokenRenewer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.web.HftpFileSystem;
import org.apache.hadoop.hdfs.web.HsftpFileSystem;
import org.apache.hadoop.hdfs.web.SWebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;

final class TokenAspect<T extends FileSystem> {
    private DelegationTokenRenewer.RenewAction<?> action;
    private DelegationTokenRenewer dtRenewer = null;
    private final DTSelecorByKind dtSelector;
    private final T fs;
    private boolean hasInitedToken;
    private final Log LOG;
    private final Text serviceName;

    TokenAspect(T fs, Text serviceName, Text kind) {
        this.LOG = LogFactory.getLog(fs.getClass());
        this.fs = fs;
        this.dtSelector = new DTSelecorByKind(kind);
        this.serviceName = serviceName;
    }

    synchronized void ensureTokenInitialized() throws IOException {
        if (!this.hasInitedToken || this.action != null && !this.action.isValid()) {
            Token<?> token = ((FileSystem)this.fs).getDelegationToken(null);
            if (token != null) {
                ((DelegationTokenRenewer.Renewable)this.fs).setDelegationToken(token);
                this.addRenewAction(this.fs);
                this.LOG.debug("Created new DT for " + token.getService());
            }
            this.hasInitedToken = true;
        }
    }

    public synchronized void reset() {
        this.hasInitedToken = false;
    }

    synchronized void initDelegationToken(UserGroupInformation ugi) {
        Token<DelegationTokenIdentifier> token = this.selectDelegationToken(ugi);
        if (token != null) {
            this.LOG.debug("Found existing DT for " + token.getService());
            ((DelegationTokenRenewer.Renewable)this.fs).setDelegationToken(token);
            this.hasInitedToken = true;
        }
    }

    synchronized void removeRenewAction() throws IOException {
        if (this.dtRenewer != null) {
            this.dtRenewer.removeRenewAction(this.fs);
        }
    }

    @VisibleForTesting
    Token<DelegationTokenIdentifier> selectDelegationToken(UserGroupInformation ugi) {
        return this.dtSelector.selectToken(this.serviceName, ugi.getTokens());
    }

    private synchronized void addRenewAction(T webhdfs) {
        if (this.dtRenewer == null) {
            this.dtRenewer = DelegationTokenRenewer.getInstance();
        }
        this.action = this.dtRenewer.addRenewAction(webhdfs);
    }

    static interface TokenManagementDelegator {
        public void cancelDelegationToken(Token<?> var1) throws IOException;

        public long renewDelegationToken(Token<?> var1) throws IOException;
    }

    private static class DTSelecorByKind
    extends AbstractDelegationTokenSelector<DelegationTokenIdentifier> {
        public DTSelecorByKind(Text kind) {
            super(kind);
        }
    }

    @InterfaceAudience.Private
    public static class TokenManager
    extends TokenRenewer {
        @Override
        public void cancel(Token<?> token, Configuration conf) throws IOException {
            this.getInstance(token, conf).cancelDelegationToken(token);
        }

        @Override
        public boolean handleKind(Text kind) {
            return kind.equals(HftpFileSystem.TOKEN_KIND) || kind.equals(HsftpFileSystem.TOKEN_KIND) || kind.equals(WebHdfsFileSystem.TOKEN_KIND) || kind.equals(SWebHdfsFileSystem.TOKEN_KIND);
        }

        @Override
        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        @Override
        public long renew(Token<?> token, Configuration conf) throws IOException {
            return this.getInstance(token, conf).renewDelegationToken(token);
        }

        private TokenManagementDelegator getInstance(Token<?> token, Configuration conf) throws IOException {
            URI uri;
            String scheme = TokenManager.getSchemeByKind(token.getKind());
            if (HAUtil.isTokenForLogicalUri(token)) {
                uri = HAUtil.getServiceUriFromToken(scheme, token);
            } else {
                InetSocketAddress address = SecurityUtil.getTokenServiceAddr(token);
                uri = URI.create(scheme + "://" + NetUtils.getHostPortString(address));
            }
            return (TokenManagementDelegator)((Object)FileSystem.get(uri, conf));
        }

        private static String getSchemeByKind(Text kind) {
            if (kind.equals(HftpFileSystem.TOKEN_KIND)) {
                return "hftp";
            }
            if (kind.equals(HsftpFileSystem.TOKEN_KIND)) {
                return "hsftp";
            }
            if (kind.equals(WebHdfsFileSystem.TOKEN_KIND)) {
                return "webhdfs";
            }
            if (kind.equals(SWebHdfsFileSystem.TOKEN_KIND)) {
                return "swebhdfs";
            }
            throw new IllegalArgumentException("Unsupported scheme");
        }
    }
}

