/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.protobuf.TextFormat;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.TokenPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ApplicationReportPBImpl
extends ApplicationReport {
    YarnProtos.ApplicationReportProto proto = YarnProtos.ApplicationReportProto.getDefaultInstance();
    YarnProtos.ApplicationReportProto.Builder builder = null;
    boolean viaProto = false;
    private ApplicationId applicationId;
    private ApplicationAttemptId currentApplicationAttemptId;
    private Token clientToAMToken = null;
    private Token amRmToken = null;
    private Set<String> applicationTags = null;

    public ApplicationReportPBImpl() {
        this.builder = YarnProtos.ApplicationReportProto.newBuilder();
    }

    public ApplicationReportPBImpl(YarnProtos.ApplicationReportProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    @Override
    public ApplicationId getApplicationId() {
        YarnProtos.ApplicationReportProtoOrBuilder p;
        if (this.applicationId != null) {
            return this.applicationId;
        }
        YarnProtos.ApplicationReportProtoOrBuilder applicationReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasApplicationId()) {
            return null;
        }
        this.applicationId = this.convertFromProtoFormat(p.getApplicationId());
        return this.applicationId;
    }

    @Override
    public void setApplicationResourceUsageReport(ApplicationResourceUsageReport appInfo) {
        this.maybeInitBuilder();
        if (appInfo == null) {
            this.builder.clearAppResourceUsage();
            return;
        }
        this.builder.setAppResourceUsage(this.convertToProtoFormat(appInfo));
    }

    @Override
    public ApplicationAttemptId getCurrentApplicationAttemptId() {
        YarnProtos.ApplicationReportProtoOrBuilder p;
        if (this.currentApplicationAttemptId != null) {
            return this.currentApplicationAttemptId;
        }
        YarnProtos.ApplicationReportProtoOrBuilder applicationReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasCurrentApplicationAttemptId()) {
            return null;
        }
        this.currentApplicationAttemptId = this.convertFromProtoFormat(p.getCurrentApplicationAttemptId());
        return this.currentApplicationAttemptId;
    }

    @Override
    public ApplicationResourceUsageReport getApplicationResourceUsageReport() {
        YarnProtos.ApplicationReportProtoOrBuilder p;
        YarnProtos.ApplicationReportProtoOrBuilder applicationReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasAppResourceUsage()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getAppResourceUsage());
    }

    @Override
    public String getTrackingUrl() {
        YarnProtos.ApplicationReportProtoOrBuilder p;
        YarnProtos.ApplicationReportProtoOrBuilder applicationReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasTrackingUrl()) {
            return null;
        }
        return p.getTrackingUrl();
    }

    @Override
    public String getOriginalTrackingUrl() {
        YarnProtos.ApplicationReportProtoOrBuilder p;
        YarnProtos.ApplicationReportProtoOrBuilder applicationReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasOriginalTrackingUrl()) {
            return null;
        }
        return p.getOriginalTrackingUrl();
    }

    @Override
    public String getName() {
        YarnProtos.ApplicationReportProtoOrBuilder p;
        YarnProtos.ApplicationReportProtoOrBuilder applicationReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasName()) {
            return null;
        }
        return p.getName();
    }

    @Override
    public String getQueue() {
        YarnProtos.ApplicationReportProtoOrBuilder p;
        YarnProtos.ApplicationReportProtoOrBuilder applicationReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasQueue()) {
            return null;
        }
        return p.getQueue();
    }

    @Override
    public YarnApplicationState getYarnApplicationState() {
        YarnProtos.ApplicationReportProtoOrBuilder p;
        YarnProtos.ApplicationReportProtoOrBuilder applicationReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasYarnApplicationState()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getYarnApplicationState());
    }

    @Override
    public String getHost() {
        YarnProtos.ApplicationReportProtoOrBuilder p;
        YarnProtos.ApplicationReportProtoOrBuilder applicationReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasHost()) {
            return null;
        }
        return p.getHost();
    }

    @Override
    public int getRpcPort() {
        YarnProtos.ApplicationReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getRpcPort();
    }

    @Override
    public Token getClientToAMToken() {
        YarnProtos.ApplicationReportProtoOrBuilder p;
        YarnProtos.ApplicationReportProtoOrBuilder applicationReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.clientToAMToken != null) {
            return this.clientToAMToken;
        }
        if (!p.hasClientToAmToken()) {
            return null;
        }
        this.clientToAMToken = this.convertFromProtoFormat(p.getClientToAmToken());
        return this.clientToAMToken;
    }

    @Override
    public String getUser() {
        YarnProtos.ApplicationReportProtoOrBuilder p;
        YarnProtos.ApplicationReportProtoOrBuilder applicationReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasUser()) {
            return null;
        }
        return p.getUser();
    }

    @Override
    public String getDiagnostics() {
        YarnProtos.ApplicationReportProtoOrBuilder p;
        YarnProtos.ApplicationReportProtoOrBuilder applicationReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasDiagnostics()) {
            return null;
        }
        return p.getDiagnostics();
    }

    @Override
    public long getStartTime() {
        YarnProtos.ApplicationReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getStartTime();
    }

    @Override
    public long getFinishTime() {
        YarnProtos.ApplicationReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getFinishTime();
    }

    @Override
    public FinalApplicationStatus getFinalApplicationStatus() {
        YarnProtos.ApplicationReportProtoOrBuilder p;
        YarnProtos.ApplicationReportProtoOrBuilder applicationReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasFinalApplicationStatus()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getFinalApplicationStatus());
    }

    @Override
    public float getProgress() {
        YarnProtos.ApplicationReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getProgress();
    }

    @Override
    public String getApplicationType() {
        YarnProtos.ApplicationReportProtoOrBuilder p;
        YarnProtos.ApplicationReportProtoOrBuilder applicationReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasApplicationType()) {
            return null;
        }
        return p.getApplicationType();
    }

    @Override
    public Token getAMRMToken() {
        YarnProtos.ApplicationReportProtoOrBuilder p;
        YarnProtos.ApplicationReportProtoOrBuilder applicationReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.amRmToken != null) {
            return this.amRmToken;
        }
        if (!p.hasAmRmToken()) {
            return null;
        }
        this.amRmToken = this.convertFromProtoFormat(p.getAmRmToken());
        return this.amRmToken;
    }

    private void initApplicationTags() {
        if (this.applicationTags != null) {
            return;
        }
        YarnProtos.ApplicationReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        this.applicationTags = new HashSet<String>();
        this.applicationTags.addAll(p.getApplicationTagsList());
    }

    @Override
    public Set<String> getApplicationTags() {
        this.initApplicationTags();
        return this.applicationTags;
    }

    @Override
    public void setApplicationId(ApplicationId applicationId) {
        this.maybeInitBuilder();
        if (applicationId == null) {
            this.builder.clearApplicationId();
        }
        this.applicationId = applicationId;
    }

    @Override
    public void setCurrentApplicationAttemptId(ApplicationAttemptId applicationAttemptId) {
        this.maybeInitBuilder();
        if (applicationAttemptId == null) {
            this.builder.clearCurrentApplicationAttemptId();
        }
        this.currentApplicationAttemptId = applicationAttemptId;
    }

    @Override
    public void setTrackingUrl(String url) {
        this.maybeInitBuilder();
        if (url == null) {
            this.builder.clearTrackingUrl();
            return;
        }
        this.builder.setTrackingUrl(url);
    }

    @Override
    public void setOriginalTrackingUrl(String url) {
        this.maybeInitBuilder();
        if (url == null) {
            this.builder.clearOriginalTrackingUrl();
            return;
        }
        this.builder.setOriginalTrackingUrl(url);
    }

    @Override
    public void setName(String name) {
        this.maybeInitBuilder();
        if (name == null) {
            this.builder.clearName();
            return;
        }
        this.builder.setName(name);
    }

    @Override
    public void setQueue(String queue) {
        this.maybeInitBuilder();
        if (queue == null) {
            this.builder.clearQueue();
            return;
        }
        this.builder.setQueue(queue);
    }

    @Override
    public void setYarnApplicationState(YarnApplicationState state) {
        this.maybeInitBuilder();
        if (state == null) {
            this.builder.clearYarnApplicationState();
            return;
        }
        this.builder.setYarnApplicationState(this.convertToProtoFormat(state));
    }

    @Override
    public void setHost(String host) {
        this.maybeInitBuilder();
        if (host == null) {
            this.builder.clearHost();
            return;
        }
        this.builder.setHost(host);
    }

    @Override
    public void setRpcPort(int rpcPort) {
        this.maybeInitBuilder();
        this.builder.setRpcPort(rpcPort);
    }

    @Override
    public void setClientToAMToken(Token clientToAMToken) {
        this.maybeInitBuilder();
        if (clientToAMToken == null) {
            this.builder.clearClientToAmToken();
        }
        this.clientToAMToken = clientToAMToken;
    }

    @Override
    public void setUser(String user) {
        this.maybeInitBuilder();
        if (user == null) {
            this.builder.clearUser();
            return;
        }
        this.builder.setUser(user);
    }

    @Override
    public void setApplicationType(String applicationType) {
        this.maybeInitBuilder();
        if (applicationType == null) {
            this.builder.clearApplicationType();
            return;
        }
        this.builder.setApplicationType(applicationType);
    }

    @Override
    public void setApplicationTags(Set<String> tags) {
        this.maybeInitBuilder();
        if (tags == null || tags.isEmpty()) {
            this.builder.clearApplicationTags();
        }
        this.applicationTags = tags;
    }

    @Override
    public void setDiagnostics(String diagnostics) {
        this.maybeInitBuilder();
        if (diagnostics == null) {
            this.builder.clearDiagnostics();
            return;
        }
        this.builder.setDiagnostics(diagnostics);
    }

    @Override
    public void setStartTime(long startTime) {
        this.maybeInitBuilder();
        this.builder.setStartTime(startTime);
    }

    @Override
    public void setFinishTime(long finishTime) {
        this.maybeInitBuilder();
        this.builder.setFinishTime(finishTime);
    }

    @Override
    public void setFinalApplicationStatus(FinalApplicationStatus finishState) {
        this.maybeInitBuilder();
        if (finishState == null) {
            this.builder.clearFinalApplicationStatus();
            return;
        }
        this.builder.setFinalApplicationStatus(this.convertToProtoFormat(finishState));
    }

    @Override
    public void setProgress(float progress) {
        this.maybeInitBuilder();
        this.builder.setProgress(progress);
    }

    @Override
    public void setAMRMToken(Token amRmToken) {
        this.maybeInitBuilder();
        if (amRmToken == null) {
            this.builder.clearAmRmToken();
        }
        this.amRmToken = amRmToken;
    }

    public YarnProtos.ApplicationReportProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ApplicationReportPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.applicationId != null && !((ApplicationIdPBImpl)this.applicationId).getProto().equals(this.builder.getApplicationId())) {
            this.builder.setApplicationId(this.convertToProtoFormat(this.applicationId));
        }
        if (this.currentApplicationAttemptId != null && !((ApplicationAttemptIdPBImpl)this.currentApplicationAttemptId).getProto().equals(this.builder.getCurrentApplicationAttemptId())) {
            this.builder.setCurrentApplicationAttemptId(this.convertToProtoFormat(this.currentApplicationAttemptId));
        }
        if (this.clientToAMToken != null && !((TokenPBImpl)this.clientToAMToken).getProto().equals(this.builder.getClientToAmToken())) {
            this.builder.setClientToAmToken(this.convertToProtoFormat(this.clientToAMToken));
        }
        if (this.amRmToken != null && !((TokenPBImpl)this.amRmToken).getProto().equals(this.builder.getAmRmToken())) {
            this.builder.setAmRmToken(this.convertToProtoFormat(this.amRmToken));
        }
        if (this.applicationTags != null && !this.applicationTags.isEmpty()) {
            this.builder.clearApplicationTags();
            this.builder.addAllApplicationTags(this.applicationTags);
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ApplicationReportProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId t) {
        return ((ApplicationIdPBImpl)t).getProto();
    }

    private YarnProtos.ApplicationAttemptIdProto convertToProtoFormat(ApplicationAttemptId t) {
        return ((ApplicationAttemptIdPBImpl)t).getProto();
    }

    private ApplicationResourceUsageReport convertFromProtoFormat(YarnProtos.ApplicationResourceUsageReportProto s) {
        return ProtoUtils.convertFromProtoFormat(s);
    }

    private YarnProtos.ApplicationResourceUsageReportProto convertToProtoFormat(ApplicationResourceUsageReport s) {
        return ProtoUtils.convertToProtoFormat(s);
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto applicationId) {
        return new ApplicationIdPBImpl(applicationId);
    }

    private ApplicationAttemptIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationAttemptIdProto applicationAttemptId) {
        return new ApplicationAttemptIdPBImpl(applicationAttemptId);
    }

    private YarnApplicationState convertFromProtoFormat(YarnProtos.YarnApplicationStateProto s) {
        return ProtoUtils.convertFromProtoFormat(s);
    }

    private YarnProtos.YarnApplicationStateProto convertToProtoFormat(YarnApplicationState s) {
        return ProtoUtils.convertToProtoFormat(s);
    }

    private FinalApplicationStatus convertFromProtoFormat(YarnProtos.FinalApplicationStatusProto s) {
        return ProtoUtils.convertFromProtoFormat(s);
    }

    private YarnProtos.FinalApplicationStatusProto convertToProtoFormat(FinalApplicationStatus s) {
        return ProtoUtils.convertToProtoFormat(s);
    }

    private TokenPBImpl convertFromProtoFormat(SecurityProtos.TokenProto p) {
        return new TokenPBImpl(p);
    }

    private SecurityProtos.TokenProto convertToProtoFormat(Token t) {
        return ((TokenPBImpl)t).getProto();
    }
}

