/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.avro.AvroColumnReader;
import org.apache.trevni.avro.AvroColumnWriter;
import org.junit.Assert;
import org.junit.Test;

public class TestCases {
    private static final File DIR = new File("src/test/cases/");
    private static final File FILE = new File("target", "case.trv");

    @Test
    public void testCases() throws Exception {
        for (File f : DIR.listFiles()) {
            if (!f.isDirectory() || f.getName().startsWith(".")) continue;
            this.runCase(f);
        }
    }

    private void runCase(File dir) throws Exception {
        Schema schema = new Schema.Parser().parse(new File(dir, "input.avsc"));
        List<Object> data = this.fromJson(schema, new File(dir, "input.json"));
        AvroColumnWriter writer = new AvroColumnWriter(schema, new ColumnFileMetaData());
        for (Object datum : data) {
            writer.write(datum);
        }
        writer.writeTo(FILE);
        this.checkRead(schema, data);
        for (File f : dir.listFiles()) {
            if (!f.isDirectory() || f.getName().startsWith(".")) continue;
            Schema s = new Schema.Parser().parse(new File(f, "sub.avsc"));
            this.checkRead(s, this.fromJson(s, new File(f, "sub.json")));
        }
    }

    private void checkRead(Schema s, List<Object> data) throws Exception {
        try (AvroColumnReader reader = new AvroColumnReader(new AvroColumnReader.Params(FILE).setSchema(s));){
            for (Object datum : data) {
                Assert.assertEquals((Object)datum, (Object)reader.next());
            }
        }
    }

    private List<Object> fromJson(Schema schema, File file) throws Exception {
        ArrayList<Object> data = new ArrayList<Object>();
        try {
            FileInputStream in = new FileInputStream(file);
            Throwable throwable = null;
            try {
                try {
                    GenericDatumReader reader = new GenericDatumReader(schema);
                    JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, (InputStream)in);
                    while (true) {
                        data.add(reader.read(null, (Decoder)decoder));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ((InputStream)in).close();
                    }
                }
                throw throwable3;
            }
        }
        catch (EOFException eOFException) {
            return data;
        }
    }
}

