/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.avro.AvroColumnReader;
import org.apache.trevni.avro.AvroColumnWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestEvolvedSchema {
    private static String writerSchema = "{    \"namespace\": \"org.apache.avro\",    \"name\": \"test_evolution\",    \"type\": \"record\",    \"fields\": [        { \"name\": \"a\", \"type\":\"string\" },        { \"name\": \"b\", \"type\":\"int\" }     ]}";
    private static String innerSchema = "{\"name\":\"c1\",          \"type\":\"record\",          \"fields\":[{\"name\":\"c11\", \"type\":\"int\", \"default\": 2},                      {\"name\":\"c12\", \"type\":\"string\", \"default\":\"goodbye\"}]}";
    private static String evolvedSchema2 = "{    \"namespace\": \"org.apache.avro\",    \"name\": \"test_evolution\",    \"type\": \"record\",    \"fields\": [        { \"name\": \"a\", \"type\":\"string\" },        { \"name\": \"b\", \"type\":\"int\" },        { \"name\": \"c\", \"type\":" + innerSchema + ",          \"default\":{\"c11\": 1, \"c12\": \"hello\"}        }     ]}";
    GenericData.Record writtenRecord;
    GenericData.Record evolvedRecord;
    GenericData.Record innerRecord;
    private static final Schema writer = new Schema.Parser().parse(writerSchema);
    private static final Schema evolved = new Schema.Parser().parse(evolvedSchema2);
    private static final Schema inner = new Schema.Parser().parse(innerSchema);

    @Before
    public void setUp() {
        this.writtenRecord = new GenericData.Record(writer);
        this.writtenRecord.put("a", (Object)"record");
        this.writtenRecord.put("b", (Object)21);
        this.innerRecord = new GenericData.Record(inner);
        this.innerRecord.put("c11", (Object)1);
        this.innerRecord.put("c12", (Object)"hello");
        this.evolvedRecord = new GenericData.Record(evolved);
        this.evolvedRecord.put("a", (Object)"record");
        this.evolvedRecord.put("b", (Object)21);
        this.evolvedRecord.put("c", (Object)this.innerRecord);
    }

    @Test
    public void testTrevniEvolvedRead() throws IOException {
        AvroColumnWriter acw = new AvroColumnWriter(writer, new ColumnFileMetaData());
        acw.write((Object)this.writtenRecord);
        File serializedTrevni = File.createTempFile("trevni", null);
        acw.writeTo(serializedTrevni);
        AvroColumnReader.Params params = new AvroColumnReader.Params(serializedTrevni);
        params.setSchema(evolved);
        try (AvroColumnReader acr = new AvroColumnReader(params);){
            GenericRecord readRecord = (GenericRecord)acr.next();
            Assert.assertEquals((Object)this.evolvedRecord, (Object)readRecord);
            Assert.assertFalse((boolean)acr.hasNext());
        }
    }

    @Test
    public void testAvroEvolvedRead() throws IOException {
        File serializedAvro = File.createTempFile("avro", null);
        GenericDatumWriter dw = new GenericDatumWriter(writer);
        DataFileWriter dfw = new DataFileWriter((DatumWriter)dw);
        dfw.create(writer, serializedAvro);
        dfw.append((Object)this.writtenRecord);
        dfw.flush();
        dfw.close();
        GenericDatumReader reader = new GenericDatumReader(writer);
        reader.setExpected(evolved);
        try (DataFileReader dfr = new DataFileReader(serializedAvro, (DatumReader)reader);){
            GenericRecord readRecord = (GenericRecord)dfr.next();
            Assert.assertEquals((Object)this.evolvedRecord, (Object)readRecord);
            Assert.assertFalse((boolean)dfr.hasNext());
        }
    }
}

