/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro;

import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroCollector;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroMapper;
import org.apache.avro.mapred.AvroReducer;
import org.apache.avro.mapred.Pair;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.trevni.avro.AvroTrevniInputFormat;
import org.apache.trevni.avro.AvroTrevniOutputFormat;
import org.apache.trevni.avro.WordCountUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestWordCount {
    static final Schema STRING = Schema.create((Schema.Type)Schema.Type.STRING);
    static final Schema LONG;
    private static long total;

    @Test
    public void runTestsInOrder() throws Exception {
        this.testOutputFormat();
        this.testInputFormat();
    }

    public void testOutputFormat() throws Exception {
        JobConf job = new JobConf();
        WordCountUtil wordCountUtil = new WordCountUtil("trevniMapredTest");
        wordCountUtil.writeLinesFile();
        AvroJob.setInputSchema((JobConf)job, (Schema)STRING);
        AvroJob.setOutputSchema((JobConf)job, (Schema)Pair.getPairSchema((Schema)STRING, (Schema)LONG));
        AvroJob.setMapperClass((JobConf)job, MapImpl.class);
        AvroJob.setCombinerClass((JobConf)job, ReduceImpl.class);
        AvroJob.setReducerClass((JobConf)job, ReduceImpl.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{new Path(wordCountUtil.getDir().toString() + "/in")});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)new Path(wordCountUtil.getDir().toString() + "/out"));
        FileOutputFormat.setCompressOutput((JobConf)job, (boolean)true);
        job.setOutputFormat(AvroTrevniOutputFormat.class);
        JobClient.runJob((JobConf)job);
        wordCountUtil.validateCountsFile();
    }

    public void testInputFormat() throws Exception {
        JobConf job = new JobConf();
        WordCountUtil wordCountUtil = new WordCountUtil("trevniMapredTest");
        Schema subSchema = Schema.parse((String)"{\"type\":\"record\",\"name\":\"PairValue\",\"fields\": [ {\"name\":\"value\", \"type\":\"long\"}]}");
        AvroJob.setInputSchema((JobConf)job, (Schema)subSchema);
        AvroJob.setMapperClass((JobConf)job, Counter.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{new Path(wordCountUtil.getDir().toString() + "/out/*")});
        job.setInputFormat(AvroTrevniInputFormat.class);
        job.setNumReduceTasks(0);
        job.setOutputFormat(NullOutputFormat.class);
        total = 0L;
        JobClient.runJob((JobConf)job);
        Assert.assertEquals((long)WordCountUtil.TOTAL, (long)total);
    }

    static {
        GenericData.setStringType((Schema)STRING, (GenericData.StringType)GenericData.StringType.String);
        LONG = Schema.create((Schema.Type)Schema.Type.LONG);
    }

    public static class Counter
    extends AvroMapper<GenericRecord, Void> {
        public void map(GenericRecord r, AvroCollector<Void> collector, Reporter reporter) throws IOException {
            total += (Long)r.get("value");
        }
    }

    public static class ReduceImpl
    extends AvroReducer<String, Long, Pair<String, Long>> {
        public void reduce(String word, Iterable<Long> counts, AvroCollector<Pair<String, Long>> collector, Reporter reporter) throws IOException {
            long sum = 0L;
            for (long count : counts) {
                sum += count;
            }
            collector.collect((Object)new Pair((CharSequence)word, Long.valueOf(sum)));
        }
    }

    public static class MapImpl
    extends AvroMapper<String, Pair<String, Long>> {
        public void map(String text, AvroCollector<Pair<String, Long>> collector, Reporter reporter) throws IOException {
            StringTokenizer tokens = new StringTokenizer(text.toString());
            while (tokens.hasMoreTokens()) {
                collector.collect((Object)new Pair((CharSequence)tokens.nextToken(), Long.valueOf(1L)));
            }
        }
    }
}

