/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro.mapreduce;

import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.Pair;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.trevni.avro.WordCountUtil;
import org.apache.trevni.avro.mapreduce.AvroTrevniKeyInputFormat;
import org.apache.trevni.avro.mapreduce.AvroTrevniKeyOutputFormat;
import org.junit.Assert;
import org.junit.Test;

public class TestKeyWordCount {
    private static long total = 0L;
    static final Schema STRING = Schema.create((Schema.Type)Schema.Type.STRING);
    static final Schema LONG;

    @Test
    public void testIOFormat() throws Exception {
        this.checkOutputFormat();
        this.checkInputFormat();
    }

    public void checkOutputFormat() throws Exception {
        Job job = new Job();
        WordCountUtil wordCountUtil = new WordCountUtil("trevniMapReduceKeyTest", "part-r-00000");
        wordCountUtil.writeLinesFile();
        AvroJob.setInputKeySchema((Job)job, (Schema)STRING);
        AvroJob.setOutputKeySchema((Job)job, (Schema)Pair.getPairSchema((Schema)STRING, (Schema)LONG));
        job.setMapperClass(WordCountMapper.class);
        job.setReducerClass(WordCountReducer.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(LongWritable.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(wordCountUtil.getDir().toString() + "/in")});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(wordCountUtil.getDir().toString() + "/out"));
        FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
        job.setInputFormatClass(AvroKeyInputFormat.class);
        job.setOutputFormatClass(AvroTrevniKeyOutputFormat.class);
        job.waitForCompletion(true);
        wordCountUtil.validateCountsFile();
    }

    public void checkInputFormat() throws Exception {
        Job job = new Job();
        WordCountUtil wordCountUtil = new WordCountUtil("trevniMapReduceKeyTest");
        job.setMapperClass(Counter.class);
        Schema subSchema = Schema.parse((String)"{\"type\":\"record\",\"name\":\"PairValue\",\"fields\": [ {\"name\":\"value\", \"type\":\"long\"}]}");
        AvroJob.setInputKeySchema((Job)job, (Schema)subSchema);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(wordCountUtil.getDir().toString() + "/out/*")});
        job.setInputFormatClass(AvroTrevniKeyInputFormat.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(NullOutputFormat.class);
        total = 0L;
        job.waitForCompletion(true);
        Assert.assertEquals((long)WordCountUtil.TOTAL, (long)total);
    }

    static {
        GenericData.setStringType((Schema)STRING, (GenericData.StringType)GenericData.StringType.String);
        LONG = Schema.create((Schema.Type)Schema.Type.LONG);
    }

    public static class Counter
    extends Mapper<AvroKey<GenericData.Record>, NullWritable, NullWritable, NullWritable> {
        protected void map(AvroKey<GenericData.Record> key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
            total += (Long)((GenericData.Record)key.datum()).get("value");
        }
    }

    private static class WordCountReducer
    extends Reducer<Text, LongWritable, AvroKey<GenericData.Record>, NullWritable> {
        private AvroKey<GenericData.Record> result;

        private WordCountReducer() {
        }

        protected void setup(Reducer.Context context) {
            this.result = new AvroKey();
            this.result.datum((Object)new GenericData.Record(Pair.getPairSchema((Schema)STRING, (Schema)LONG)));
        }

        protected void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long count = 0L;
            for (LongWritable value : values) {
                count += value.get();
            }
            ((GenericData.Record)this.result.datum()).put("key", (Object)key.toString());
            ((GenericData.Record)this.result.datum()).put("value", (Object)count);
            context.write(this.result, (Object)NullWritable.get());
        }
    }

    private static class WordCountMapper
    extends Mapper<AvroKey<String>, NullWritable, Text, LongWritable> {
        private LongWritable mCount = new LongWritable();
        private Text mText = new Text();

        private WordCountMapper() {
        }

        protected void setup(Mapper.Context context) {
            this.mCount.set(1L);
        }

        protected void map(AvroKey<String> key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
            try {
                StringTokenizer tokens = new StringTokenizer((String)key.datum());
                while (tokens.hasMoreTokens()) {
                    this.mText.set(tokens.nextToken());
                    context.write((Object)this.mText, (Object)this.mCount);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(key + " " + (String)key.datum(), e);
            }
        }
    }
}

