/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.aar;

import java.io.File;
import java.io.IOException;
import org.apache.axis2.maven2.aar.AbstractAarMojo;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;

@Mojo(name="aar", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class AarMojo
extends AbstractAarMojo {
    @Parameter(required=true, readonly=true, property="session")
    private MavenSession session;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private String outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String aarName;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="true")
    private boolean primaryArtifact;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        File aarFile = new File(this.outputDirectory, this.aarName + ".aar");
        try {
            this.performPackaging(aarFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling aar", e);
        }
    }

    private void performPackaging(File aarFile) throws IOException, ArchiverException, ManifestException, DependencyResolutionRequiredException, MojoExecutionException {
        this.buildExplodedAar();
        this.getLog().info((CharSequence)("Generating aar " + aarFile.getAbsolutePath()));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(aarFile);
        archiver.configureReproducibleBuild(this.outputTimestamp);
        this.jarArchiver.addDirectory(this.aarDirectory);
        archiver.createArchive(this.session, this.project, this.archive);
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.project, "aar", this.classifier, aarFile);
        } else {
            Artifact artifact = this.project.getArtifact();
            if (this.primaryArtifact) {
                artifact.setFile(aarFile);
            } else if (artifact.getFile() == null || artifact.getFile().isDirectory()) {
                artifact.setFile(aarFile);
            } else {
                this.projectHelper.attachArtifact(this.project, "aar", aarFile);
            }
        }
    }
}

