/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.aar;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.axis2.maven2.aar.FileSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractAarMojo
extends AbstractMojo {
    @Parameter(property="project.basedir", required=true, readonly=true)
    protected File baseDir;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(defaultValue="${project.build.directory}/aar", required=true)
    protected File aarDirectory;
    @Parameter(defaultValue="src/main/resources/META-INF/services.xml")
    private File servicesXmlFile;
    @Parameter
    private File wsdlFile;
    @Parameter(defaultValue="service.wsdl")
    private String wsdlFileName;
    @Parameter
    private FileSet[] fileSets;
    @Parameter(defaultValue="true")
    private boolean includeDependencies;

    protected void buildExplodedAar() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Exploding aar...");
        this.aarDirectory.mkdirs();
        this.getLog().debug((CharSequence)("Assembling aar " + this.project.getArtifactId() + " in " + String.valueOf(this.aarDirectory)));
        try {
            boolean wsdlExistsBeforeCopyingClasses;
            File metaInfDir = new File(this.aarDirectory, "META-INF");
            File libDir = new File(this.aarDirectory, "lib");
            File servicesFileTarget = new File(metaInfDir, "services.xml");
            boolean existsBeforeCopyingClasses = servicesFileTarget.exists();
            String wsdlName = this.wsdlFileName;
            if (wsdlName == null && this.wsdlFile != null) {
                wsdlName = this.wsdlFile.getName();
            }
            File wsdlFileTarget = null;
            if (this.wsdlFile != null) {
                wsdlFileTarget = new File(metaInfDir, this.wsdlFileName);
            }
            boolean bl = wsdlExistsBeforeCopyingClasses = wsdlFileTarget == null ? false : wsdlFileTarget.exists();
            if (this.classesDirectory.exists() && !this.classesDirectory.equals(this.aarDirectory)) {
                FileUtils.copyDirectoryStructure((File)this.classesDirectory, (File)this.aarDirectory);
            }
            if (this.fileSets != null) {
                for (int i = 0; i < this.fileSets.length; ++i) {
                    FileSet fileSet = this.fileSets[i];
                    this.copyFileSet(fileSet, this.aarDirectory);
                }
            }
            this.copyMetaInfFile(this.servicesXmlFile, servicesFileTarget, existsBeforeCopyingClasses, "services.xml file");
            this.copyMetaInfFile(this.wsdlFile, wsdlFileTarget, wsdlExistsBeforeCopyingClasses, "WSDL file");
            if (this.includeDependencies) {
                Set artifacts = this.project.getArtifacts();
                List<String> duplicates = this.findDuplicates(artifacts);
                for (Artifact artifact : artifacts) {
                    String type;
                    ScopeArtifactFilter filter;
                    Object targetFileName = this.getDefaultFinalName(artifact);
                    this.getLog().debug((CharSequence)("Processing: " + (String)targetFileName));
                    if (duplicates.contains(targetFileName)) {
                        this.getLog().debug((CharSequence)("Duplicate found: " + (String)targetFileName));
                        targetFileName = artifact.getGroupId() + "-" + (String)targetFileName;
                        this.getLog().debug((CharSequence)("Renamed to: " + (String)targetFileName));
                    }
                    if (!(filter = new ScopeArtifactFilter("runtime")).include(artifact) || !"jar".equals(type = artifact.getType())) continue;
                    this.copyFileIfModified(artifact.getFile(), new File(libDir, (String)targetFileName));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not explode aar...", (Exception)e);
        }
    }

    private List<String> findDuplicates(Set<Artifact> artifacts) {
        ArrayList<String> duplicates = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        for (Artifact artifact : artifacts) {
            String candidate = this.getDefaultFinalName(artifact);
            if (identifiers.contains(candidate)) {
                duplicates.add(candidate);
                continue;
            }
            identifiers.add(candidate);
        }
        return duplicates;
    }

    private String getDefaultFinalName(Artifact artifact) {
        return artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getArtifactHandler().getExtension();
    }

    private void copyFileIfModified(File source, File destination) throws IOException {
        if (destination.lastModified() < source.lastModified()) {
            FileUtils.copyFile((File)source.getCanonicalFile(), (File)destination);
            destination.setLastModified(source.lastModified());
        }
    }

    private void copyFileSet(FileSet fileSet, File targetDirectory) throws IOException {
        String[] includes;
        String[] excludes;
        File dir = fileSet.getDirectory();
        if (dir == null) {
            dir = this.baseDir;
        }
        File targetDir = targetDirectory;
        if (fileSet.getOutputDirectory() != null) {
            targetDir = new File(targetDir, fileSet.getOutputDirectory());
        }
        if (targetDir.equals(dir)) {
            return;
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(dir);
        if (!fileSet.isSkipDefaultExcludes()) {
            ds.addDefaultExcludes();
        }
        if ((excludes = fileSet.getExcludes()) != null) {
            ds.setExcludes(excludes);
        }
        if ((includes = fileSet.getIncludes()) != null) {
            ds.setIncludes(includes);
        }
        ds.scan();
        String[] files = ds.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            File sourceFile = new File(dir, files[i]);
            File targetFile = new File(targetDir, files[i]);
            FileUtils.copyFile((File)sourceFile, (File)targetFile);
        }
    }

    private void copyMetaInfFile(File pSource, File pTarget, boolean pExistsBeforeCopying, String pDescription) throws MojoExecutionException, IOException {
        if (pSource != null && pTarget != null) {
            if (!pSource.exists()) {
                throw new MojoExecutionException("The configured " + pDescription + " could not be found at " + String.valueOf(pSource));
            }
            if (!pExistsBeforeCopying && pTarget.exists()) {
                this.getLog().warn((CharSequence)("The configured " + pDescription + " overwrites another file from the classpath."));
            }
            FileUtils.copyFile((File)pSource, (File)pTarget);
        }
    }
}

