/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.aar;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.axis2.maven2.aar.AbstractAarMojo;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="deployaar", defaultPhase=LifecyclePhase.INSTALL, threadSafe=true)
public class DeployAarMojo
extends AbstractAarMojo {
    private static final String LOGIN_FAILED_ERROR_MESSAGE = "Invalid auth credentials!";
    @Parameter(defaultValue="http://localhost:8080/axis2/axis2-admin", property="axis2.aar.axis2AdminConsoleURL")
    private URL axis2AdminConsoleURL;
    @Parameter(property="axis2.aar.axis2AdminUser")
    private String axis2AdminUser;
    @Parameter(property="axis2.aar.axis2AdminPassword")
    private String axis2AdminPassword;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Deploying AAR artifact " + String.valueOf(this.project.getArtifact().getFile()) + " to Axis2 Web Console " + String.valueOf(this.axis2AdminConsoleURL)));
        try {
            this.deploy(this.project.getArtifact().getFile());
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error deploying aar", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploy(File aarFile) throws MojoExecutionException, IOException {
        if (this.axis2AdminConsoleURL == null) {
            throw new MojoExecutionException("No Axis2 administrative console URL provided.");
        }
        URL axis2AdminConsoleLoginURL = new URL(this.axis2AdminConsoleURL.toString() + "/login");
        HttpPost httpPost = new HttpPost(axis2AdminConsoleLoginURL.toString());
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("userName", this.axis2AdminUser));
        nvps.add(new BasicNameValuePair("password", this.axis2AdminPassword));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            CloseableHttpResponse hcResponse = httpclient.execute((ClassicHttpRequest)httpPost);
            int status = hcResponse.getCode();
            if (status != 200) {
                throw new MojoExecutionException("Failed to log in");
            }
            HttpEntity responseEntity = hcResponse.getEntity();
            if (responseEntity == null) {
                throw new MojoExecutionException("url request returned null entity: " + String.valueOf(new StatusLine((HttpResponse)hcResponse)));
            }
            String responseStr = EntityUtils.toString((HttpEntity)responseEntity);
            if (responseStr.indexOf(LOGIN_FAILED_ERROR_MESSAGE) != -1) {
                throw new MojoExecutionException("Failed to log into Axis2 administration web console using credentials");
            }
        }
        URL axis2AdminConsoleUploadURL = new URL(this.axis2AdminConsoleURL.toString() + "/upload");
        this.getLog().debug((CharSequence)("Uploading AAR to Axis2 Admin Web Console " + String.valueOf(axis2AdminConsoleUploadURL)));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.LEGACY);
        File file = this.project.getArtifact().getFile();
        FileBody fileBody = new FileBody(file);
        builder.addPart(this.project.getArtifact().getFile().getName(), (ContentBody)fileBody);
        httpPost = null;
        httpPost = new HttpPost(axis2AdminConsoleLoginURL.toString());
        httpclient = null;
        httpclient = HttpClients.createDefault();
        try {
            CloseableHttpResponse hcResponse = httpclient.execute((ClassicHttpRequest)httpPost);
            int status = hcResponse.getCode();
            if (status != 200) {
                throw new MojoExecutionException("Failed to log in");
            }
        }
        finally {
            httpclient.close();
        }
        URL axis2AdminConsoleLogoutURL = new URL(this.axis2AdminConsoleURL.toString() + "/logout");
        this.getLog().debug((CharSequence)("Logging out of Axis2 Admin Web Console " + String.valueOf(axis2AdminConsoleLogoutURL)));
        HttpGet get = new HttpGet(axis2AdminConsoleLogoutURL.toString());
        httpclient = null;
        httpclient = HttpClients.createDefault();
        try {
            CloseableHttpResponse hcResponse = httpclient.execute((ClassicHttpRequest)get);
            int status = hcResponse.getCode();
            if (status != 200) {
                throw new MojoExecutionException("Failed to log out");
            }
        }
        finally {
            httpclient.close();
        }
    }
}

