/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.attachments.utils.IOUtils;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.databinding.ADBBean;
import org.apache.axis2.databinding.i18n.ADBMessages;
import org.apache.axis2.databinding.types.Day;
import org.apache.axis2.databinding.types.Duration;
import org.apache.axis2.databinding.types.Entities;
import org.apache.axis2.databinding.types.Entity;
import org.apache.axis2.databinding.types.HexBinary;
import org.apache.axis2.databinding.types.IDRef;
import org.apache.axis2.databinding.types.IDRefs;
import org.apache.axis2.databinding.types.Id;
import org.apache.axis2.databinding.types.Language;
import org.apache.axis2.databinding.types.Month;
import org.apache.axis2.databinding.types.MonthDay;
import org.apache.axis2.databinding.types.NCName;
import org.apache.axis2.databinding.types.NMToken;
import org.apache.axis2.databinding.types.NMTokens;
import org.apache.axis2.databinding.types.Name;
import org.apache.axis2.databinding.types.NegativeInteger;
import org.apache.axis2.databinding.types.NonNegativeInteger;
import org.apache.axis2.databinding.types.NonPositiveInteger;
import org.apache.axis2.databinding.types.NormalizedString;
import org.apache.axis2.databinding.types.Notation;
import org.apache.axis2.databinding.types.PositiveInteger;
import org.apache.axis2.databinding.types.Time;
import org.apache.axis2.databinding.types.Token;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.types.UnsignedByte;
import org.apache.axis2.databinding.types.UnsignedInt;
import org.apache.axis2.databinding.types.UnsignedLong;
import org.apache.axis2.databinding.types.UnsignedShort;
import org.apache.axis2.databinding.types.Year;
import org.apache.axis2.databinding.types.YearMonth;
import org.apache.axis2.databinding.utils.BeanUtil;

public class ConverterUtil {
    private static final String POSITIVE_INFINITY = "INF";
    private static final String NEGATIVE_INFINITY = "-INF";

    public static String convertToString(int i) {
        return Integer.toString(i);
    }

    public static String convertToString(float i) {
        return Float.toString(i);
    }

    public static String convertToString(long i) {
        return Long.toString(i);
    }

    public static String convertToString(double i) {
        return Double.toString(i);
    }

    public static String convertToString(byte i) {
        return Byte.toString(i);
    }

    public static String convertToString(char i) {
        return Character.toString(i);
    }

    public static String convertToString(short i) {
        return Short.toString(i);
    }

    public static String convertToString(boolean i) {
        return Boolean.toString(i);
    }

    public static String convertToString(Date value) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(value);
    }

    public static String convertToString(Calendar value) {
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
        return zulu.format(value.getTime());
    }

    public static String convertToString(Day o) {
        return o.toString();
    }

    public static String convertToString(YearMonth o) {
        return o.toString();
    }

    public static String convertToString(Year o) {
        return o.toString();
    }

    public static String convertToString(HexBinary o) {
        return o.toString();
    }

    public static String convertToString(MonthDay o) {
        return o.toString();
    }

    public static String convertToString(Time o) {
        return o.toString();
    }

    public static String convertToString(Byte o) {
        return o.toString();
    }

    public static String convertToString(BigInteger o) {
        return o.toString();
    }

    public static String convertToString(Integer o) {
        return o.toString();
    }

    public static String convertToString(Long o) {
        return o.toString();
    }

    public static String convertToString(Short o) {
        return o.toString();
    }

    public static String convertToString(UnsignedByte o) {
        return o.toString();
    }

    public static String convertToString(UnsignedInt o) {
        return o.toString();
    }

    public static String convertToString(UnsignedLong o) {
        return o.toString();
    }

    public static String convertToString(QName o) {
        if (o != null) {
            return o.getLocalPart();
        }
        return "";
    }

    public static String convertToString(Object o) {
        return o.toString();
    }

    public static String convertToString(Double o) {
        return o.toString();
    }

    public static String convertToString(Duration o) {
        return o.toString();
    }

    public static String convertToString(Float o) {
        return o.toString();
    }

    public static String convertToString(Month o) {
        return o.toString();
    }

    public static String convertToString(byte[] bytes) {
        return Base64.encode((byte[])bytes);
    }

    public static String convertToString(DataHandler handler) {
        return ConverterUtil.getStringFromDatahandler(handler);
    }

    public static int convertToInt(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return Integer.parseInt(s);
    }

    public static BigDecimal convertToBigDecimal(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new BigDecimal(s);
    }

    public static double convertToDouble(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        if (POSITIVE_INFINITY.equals(s)) {
            return Double.POSITIVE_INFINITY;
        }
        if (NEGATIVE_INFINITY.equals(s)) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(s);
    }

    public static BigDecimal convertToDecimal(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new BigDecimal(s);
    }

    public static float convertToFloat(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        if (POSITIVE_INFINITY.equals(s)) {
            return Float.POSITIVE_INFINITY;
        }
        if (NEGATIVE_INFINITY.equals(s)) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.parseFloat(s);
    }

    public static String convertToString(String s) {
        return s;
    }

    public static long convertToLong(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return Long.parseLong(s);
    }

    public static short convertToShort(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return Short.parseShort(s);
    }

    public static boolean convertToBoolean(String s) {
        boolean returnValue = false;
        if (s != null && s.length() > 0) {
            if ("1".equals(s) || s.toLowerCase().equals("true")) {
                returnValue = true;
            } else if (!"0".equals(s) && !s.toLowerCase().equals("false")) {
                throw new RuntimeException("in valid string -" + s + " for boolean value");
            }
        }
        return returnValue;
    }

    public static String convertToAnySimpleType(String s) {
        return s;
    }

    public static OMElement convertToAnyType(String s) {
        try {
            XMLStreamReader r = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(s.getBytes()));
            StAXOMBuilder builder = new StAXOMBuilder(OMAbstractFactory.getOMFactory(), r);
            return builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            return null;
        }
    }

    public static YearMonth convertToGYearMonth(String s) {
        return new YearMonth(s);
    }

    public static MonthDay convertToGMonthDay(String s) {
        return new MonthDay(s);
    }

    public static Year convertToGYear(String s) {
        return new Year(s);
    }

    public static Month convertToGMonth(String s) {
        return new Month(s);
    }

    public static Day convertToGDay(String s) {
        return new Day(s);
    }

    public static Duration convertToDuration(String s) {
        return new Duration(s);
    }

    public static HexBinary convertToHexBinary(String s) {
        return new HexBinary(s);
    }

    public static DataHandler convertToBase64Binary(String s) {
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(Base64.decode((String)s));
        return new DataHandler((DataSource)byteArrayDataSource);
    }

    public static DataHandler convertToDataHandler(String s) {
        return ConverterUtil.convertToBase64Binary(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Date convertToDate(String source) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = null;
        boolean bc = false;
        if (source.startsWith("-")) {
            source = source.substring(1);
            bc = true;
        }
        if (source == null) throw new RuntimeException("In valid string to parse");
        if (source.length() < 10) throw new RuntimeException("In valid string to parse");
        if (source.length() == 10) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        } else {
            String restpart = source.substring(10);
            if (restpart.startsWith("Z")) {
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'Z'");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            } else {
                if (!restpart.startsWith("+")) {
                    if (!restpart.startsWith("-")) throw new RuntimeException("In valid string sufix");
                }
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-ddz");
                source = source.substring(0, 10) + "GMT" + restpart;
            }
        }
        try {
            Date date = simpleDateFormat.parse(source);
            if (!bc) return date;
            calendar.setTime(date);
            calendar.set(0, 0);
            return calendar.getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException("In valid string to parse");
        }
    }

    public static Time convertToTime(String s) {
        return new Time(s);
    }

    public static Token convertToToken(String s) {
        return new Token(s);
    }

    public static NormalizedString convertToNormalizedString(String s) {
        return new NormalizedString(s);
    }

    public static UnsignedLong convertToUnsignedLong(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new UnsignedLong(s);
    }

    public static UnsignedInt convertToUnsignedInt(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new UnsignedInt(s);
    }

    public static UnsignedShort convertToUnsignedShort(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new UnsignedShort(s);
    }

    public static UnsignedByte convertToUnsignedByte(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new UnsignedByte(s);
    }

    public static NonNegativeInteger convertToNonNegativeInteger(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new NonNegativeInteger(s);
    }

    public static NegativeInteger convertToNegativeInteger(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new NegativeInteger(s);
    }

    public static PositiveInteger convertToPositiveInteger(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new PositiveInteger(s);
    }

    public static NonPositiveInteger convertToNonPositiveInteger(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new NonPositiveInteger(s);
    }

    public static Name convertToName(String s) {
        return new Name(s);
    }

    public static NCName convertToNCName(String s) {
        return new NCName(s);
    }

    public static Id convertToID(String s) {
        return new Id(s);
    }

    public static Id convertToId(String s) {
        return ConverterUtil.convertToID(s);
    }

    public static Language convertToLanguage(String s) {
        return new Language(s);
    }

    public static NMToken convertToNMTOKEN(String s) {
        return new NMToken(s);
    }

    public static NMTokens convertToNMTOKENS(String s) {
        return new NMTokens(s);
    }

    public static Notation convertToNOTATION(String s) {
        return null;
    }

    public static Entity convertToENTITY(String s) {
        return new Entity(s);
    }

    public static Entities convertToENTITIES(String s) {
        return new Entities(s);
    }

    public static IDRef convertToIDREF(String s) {
        return new IDRef(s);
    }

    public static IDRefs convertToIDREFS(String s) {
        return new IDRefs(s);
    }

    public static URI convertToURI(String s) {
        return ConverterUtil.convertToAnyURI(s);
    }

    public static URI convertToAnyURI(String s) {
        try {
            return new URI(s);
        }
        catch (URI.MalformedURIException e) {
            throw new ObjectConversionException(ADBMessages.getMessage("converter.cannotParse", s), e);
        }
    }

    public static BigInteger convertToInteger(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new BigInteger(s);
    }

    public static BigInteger convertToBigInteger(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return ConverterUtil.convertToInteger(s);
    }

    public static byte convertToByte(String s) {
        return Byte.parseByte(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Calendar convertToDateTime(String source) {
        SimpleDateFormat simpleDateFormat = null;
        Date date = null;
        Calendar calendar = Calendar.getInstance();
        if (source.startsWith("-")) {
            source = source.substring(1);
            calendar.set(0, 0);
        }
        try {
            if (source == null || source.length() < 19) throw new NumberFormatException("date string can not be less than 19 charactors");
            if (source.length() == 19) {
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            } else {
                String rest = source.substring(19);
                if (rest.startsWith(".")) {
                    if (rest.endsWith("Z")) {
                        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z'");
                        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    } else if (rest.lastIndexOf("+") > 0 || rest.lastIndexOf("-") > 0) {
                        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSz");
                        if (rest.lastIndexOf("+") > 0) {
                            source = source.substring(0, source.lastIndexOf("+")) + "GMT" + rest.substring(rest.lastIndexOf("+"));
                        } else if (rest.lastIndexOf("-") > 0) {
                            source = source.substring(0, source.lastIndexOf("-")) + "GMT" + rest.substring(rest.lastIndexOf("-"));
                        }
                    } else {
                        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS");
                    }
                } else if (rest.startsWith("Z")) {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                } else {
                    if (!rest.startsWith("+") && !rest.startsWith("-")) throw new NumberFormatException("in valid time zone attribute");
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                    source = source.substring(0, 19) + "GMT" + rest;
                }
            }
            date = simpleDateFormat.parse(source);
            calendar.setTime(date);
            return calendar;
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getMessage());
        }
    }

    public static QName convertToQName(String source, String nameSpaceuri) {
        int colon = (source = source.trim()).lastIndexOf(":");
        String localPart = colon < 0 ? source : source.substring(colon + 1);
        String perfix = colon <= 0 ? "" : source.substring(0, colon);
        return new QName(nameSpaceuri, localPart, perfix);
    }

    public static Object convertToObject(String i) {
        return i;
    }

    public static Object convertToObject(boolean i) {
        return i;
    }

    public static Object convertToObject(double i) {
        return new Double(i);
    }

    public static Object convertToObject(byte i) {
        return new Byte(i);
    }

    public static Object convertToObject(char i) {
        return new Character(i);
    }

    public static Object convertToObject(short i) {
        return new Short(i);
    }

    public static Object convertToArray(Class baseArrayClass, String[] valueArray) {
        ArrayList<String> valuesList = new ArrayList<String>(valueArray.length);
        for (int i = 0; i < valueArray.length; ++i) {
            valuesList.add(valueArray[i]);
        }
        return ConverterUtil.convertToArray(baseArrayClass, valuesList);
    }

    public static Object convertToArray(Class baseArrayClass, List objectList) {
        int listSize = objectList.size();
        Object returnArray = null;
        if (Integer.TYPE.equals(baseArrayClass)) {
            int[] array = new int[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                array[i] = o != null ? Integer.parseInt(o.toString()) : Integer.MIN_VALUE;
            }
            returnArray = array;
        } else if (Float.TYPE.equals(baseArrayClass)) {
            float[] array = new float[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                array[i] = o != null ? Float.parseFloat(o.toString()) : Float.NaN;
            }
            returnArray = array;
        } else if (Short.TYPE.equals(baseArrayClass)) {
            short[] array = new short[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                array[i] = o != null ? Short.parseShort(o.toString()) : (short)Short.MIN_VALUE;
            }
            returnArray = array;
        } else if (Byte.TYPE.equals(baseArrayClass)) {
            byte[] array = new byte[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                array[i] = o != null ? Byte.parseByte(o.toString()) : (byte)-128;
            }
            returnArray = array;
        } else if (Long.TYPE.equals(baseArrayClass)) {
            long[] array = new long[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                array[i] = o != null ? Long.parseLong(o.toString()) : Long.MIN_VALUE;
            }
            returnArray = array;
        } else if (Boolean.TYPE.equals(baseArrayClass)) {
            boolean[] array = new boolean[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                if (o == null) continue;
                array[i] = Boolean.getBoolean(o.toString());
            }
            returnArray = array;
        } else if (Character.TYPE.equals(baseArrayClass)) {
            char[] array = new char[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                if (o == null) continue;
                array[i] = o.toString().toCharArray()[0];
            }
            returnArray = array;
        } else if (Double.TYPE.equals(baseArrayClass)) {
            double[] array = new double[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                array[i] = o != null ? Double.parseDouble(o.toString()) : Double.NaN;
            }
            returnArray = array;
        } else if (Calendar.class.equals(baseArrayClass)) {
            Calendar[] array = new Calendar[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                if (o == null) continue;
                if (o instanceof String) {
                    array[i] = ConverterUtil.convertToDateTime(o.toString());
                    continue;
                }
                if (!(o instanceof Calendar)) continue;
                array[i] = (Calendar)o;
            }
            returnArray = array;
        } else {
            returnArray = Array.newInstance(baseArrayClass, listSize);
            ConverterUtil.ConvertToArbitraryObjectArray(returnArray, baseArrayClass, objectList);
        }
        return returnArray;
    }

    private static void ConvertToArbitraryObjectArray(Object returnArray, Class baseArrayClass, List objectList) {
        if (!ADBBean.class.isAssignableFrom(baseArrayClass)) {
            try {
                for (int i = 0; i < objectList.size(); ++i) {
                    Object o = objectList.get(i);
                    if (o == null) {
                        Array.set(returnArray, i, null);
                        continue;
                    }
                    Array.set(returnArray, i, ConverterUtil.getObjectForClass(baseArrayClass, o.toString()));
                }
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            objectList.toArray((Object[])returnArray);
        }
        catch (Exception e) {
            throw new ObjectConversionException(e);
        }
    }

    public static List toList(Object[] array) {
        if (array == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static int compare(int intValue, String value) {
        return intValue - Integer.parseInt(value);
    }

    public static double compare(double doubleValue, String value) {
        return doubleValue - Double.parseDouble(value);
    }

    public static float compare(float floatValue, String value) {
        return floatValue - Float.parseFloat(value);
    }

    public static long compare(long longValue, String value) {
        return longValue - Long.parseLong(value);
    }

    public static int compare(short shortValue, String value) {
        return shortValue - Short.parseShort(value);
    }

    public static int compare(byte byteVlaue, String value) {
        return byteVlaue - Byte.parseByte(value);
    }

    public static int compare(BigInteger binBigInteger, String value) {
        return binBigInteger.intValue() - Integer.parseInt(value);
    }

    public static double compare(BigDecimal binBigDecimal, String value) {
        return binBigDecimal.doubleValue() - Double.parseDouble(value);
    }

    public static long compare(Duration duration, String value) {
        Duration compareValue = new Duration(value);
        return duration.compare(compareValue);
    }

    public static long compare(Date date, String value) {
        Date newDate = ConverterUtil.convertToDate(value);
        return date.getTime() - newDate.getTime();
    }

    public static long compare(Time time, String value) {
        Time newTime = new Time(value);
        return time.getAsCalendar().getTimeInMillis() - newTime.getAsCalendar().getTimeInMillis();
    }

    public static long compare(Calendar calendar, String value) {
        Calendar newCalendar = ConverterUtil.convertToDateTime(value);
        return calendar.getTimeInMillis() - newCalendar.getTimeInMillis();
    }

    public static String getStringFromDatahandler(DataHandler dataHandler) {
        try {
            if (dataHandler == null) {
                return "";
            }
            InputStream inStream = dataHandler.getDataSource().getInputStream();
            byte[] data = IOUtils.getStreamAsByteArray((InputStream)inStream);
            return Base64.encode((byte[])data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getObjectForClass(Class clazz, String value) {
        boolean continueFlag = false;
        try {
            Constructor stringConstructor = clazz.getConstructor(String.class);
            return stringConstructor.newInstance(value);
        }
        catch (NoSuchMethodException e) {
            continueFlag = true;
        }
        catch (Exception e) {
            throw new ObjectConversionException(ADBMessages.getMessage("converter.cannotGenerate", clazz.getName()), e);
        }
        if (!continueFlag) {
            throw new ObjectConversionException(ADBMessages.getMessage("converter.cannotConvert", clazz.getName()));
        }
        try {
            Method parseMethod = clazz.getMethod("parse", String.class);
            Object instance = clazz.newInstance();
            return parseMethod.invoke(instance, value);
        }
        catch (NoSuchMethodException e) {
            throw new ObjectConversionException(e);
        }
        catch (Exception e) {
            throw new ObjectConversionException(ADBMessages.getMessage("converter.cannotGenerate", clazz.getName()), e);
        }
    }

    public static void serializeAnyType(String string, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        if (xmlStreamWriter.getPrefix("http://www.w3.org/2001/XMLSchema-instance") == null) {
            String prefix = BeanUtil.getUniquePrefix();
            xmlStreamWriter.writeNamespace(prefix, "http://www.w3.org/2001/XMLSchema-instance");
            xmlStreamWriter.setPrefix(prefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    public static class ObjectConversionException
    extends RuntimeException {
        public ObjectConversionException() {
        }

        public ObjectConversionException(String message) {
            super(message);
        }

        public ObjectConversionException(Throwable cause) {
            super(cause);
        }

        public ObjectConversionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

