/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.axis2.databinding;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

/**
 * Interface implemented by all ADB helpers. Helpers are generated by ADB when helper mode
 * is enabled. They contain the parsing and serialization logic.
 *
 * @param <T> the bean class that this helper is able to process
 */
public interface ADBHelper<T> {
    Class<T> getBeanClass();
    
    XMLStreamReader getPullParser(T bean, QName adbBeanQName) throws XMLStreamException;

    OMElement getOMElement(T bean, QName parentQName, OMFactory factory) throws ADBException;

    void serialize(T bean, QName parentQName, XMLStreamWriter xmlWriter) throws XMLStreamException;

    T parse(XMLStreamReader reader) throws Exception;
}
