/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.rpc.receivers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.receivers.AbstractInOutAsyncMessageReceiver;
import org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver;
import org.apache.axis2.rpc.receivers.RPCUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RPCInOutAsyncMessageReceiver
extends AbstractInOutAsyncMessageReceiver {
    private static Log log = LogFactory.getLog(RPCInOnlyMessageReceiver.class);

    public void invokeBusinessLogic(MessageContext inMessage, MessageContext outMessage) throws AxisFault {
        Method method = null;
        try {
            Object obj = this.getTheImplementationObject(inMessage);
            Class<?> ImplClass = obj.getClass();
            AxisOperation op = inMessage.getOperationContext().getAxisOperation();
            AxisService service = inMessage.getAxisService();
            SOAPBody body = inMessage.getEnvelope().getBody();
            if (body == null) {
                throw new AxisFault("SOAP body is missing in the request");
            }
            OMElement methodElement = body.getFirstElement();
            AxisMessage inaxisMessage = op.getMessage("In");
            String messageNameSpace = null;
            String methodName = op.getName().getLocalPart();
            Method[] methods = ImplClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i].isBridge() || !methods[i].getName().equals(methodName)) continue;
                method = methods[i];
                break;
            }
            Object resObject = null;
            if (inaxisMessage != null) {
                resObject = RPCUtil.invokeServiceClass(inaxisMessage, method, obj, messageNameSpace, methodElement, inMessage);
            }
            SOAPFactory fac = this.getSOAPFactory(inMessage);
            AxisMessage outaxisMessage = op.getMessage("Out");
            messageNameSpace = outaxisMessage != null && outaxisMessage.getElementQName() != null ? outaxisMessage.getElementQName().getNamespaceURI() : service.getTargetNamespace();
            OMNamespace ns = fac.createOMNamespace(messageNameSpace, service.getSchemaTargetNamespacePrefix());
            SOAPEnvelope envelope = fac.getDefaultEnvelope();
            OMElement bodyContent = null;
            if ("http://www.w3.org/ns/wsdl/robust-in-only".equals(op.getMessageExchangePattern())) {
                OMElement bodyChild = fac.createOMElement(outMessage.getAxisMessage().getName(), ns);
                envelope.getBody().addChild((OMNode)bodyChild);
                outMessage.setEnvelope(envelope);
                return;
            }
            Parameter generateBare = service.getParameter("doclitBare");
            if (generateBare != null && "true".equals(generateBare.getValue())) {
                RPCUtil.processResonseAsDocLitBare(resObject, service, envelope, fac, ns, bodyContent, outMessage);
            } else {
                RPCUtil.processResponseAsDocLitWrapped(resObject, service, method, envelope, fac, ns, bodyContent, outMessage);
            }
            outMessage.setEnvelope(envelope);
        }
        catch (InvocationTargetException e) {
            String msg = null;
            Throwable cause = e.getCause();
            if (cause != null) {
                msg = cause.getMessage();
            }
            if (msg == null) {
                msg = "Exception occurred while trying to invoke service method " + method.getName();
            }
            log.error((Object)msg, (Throwable)e);
            if (cause instanceof AxisFault) {
                throw (AxisFault)cause;
            }
            throw new AxisFault(msg);
        }
        catch (Exception e) {
            String msg = "Exception occurred while trying to invoke service method " + method.getName();
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }
}

