/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.ant;

import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.util.CommandLineOption;
import org.apache.axis2.util.CommandLineOptionParser;
import org.apache.axis2.wsdl.codegen.CodeGenerationEngine;
import org.apache.axis2.wsdl.util.ConfigPropertyFileLoader;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class AntCodegenTask
extends Task {
    private String wsdlFileName = null;
    private String output = ".";
    private String language = ConfigPropertyFileLoader.getDefaultLanguage();
    private String packageName = "org.apache.axis2";
    private String databindingName = ConfigPropertyFileLoader.getDefaultDBFrameworkName();
    private String portName = null;
    private String serviceName = null;
    private boolean asyncOnly = false;
    private boolean syncOnly = false;
    private boolean serverSide = false;
    private boolean testcase = false;
    private boolean generateServiceXml = false;
    private boolean generateAllClasses = false;
    private boolean unpackClasses = false;
    private boolean serverSideInterface = false;
    private String repositoryPath = null;
    private String externalMapping = null;
    private String wsdlVersion = null;
    private String targetSourceFolderLocation = null;
    private String targetResourcesFolderLocation = null;
    private boolean unwrap = false;
    private String namespaceToPackages = null;
    private Path classpath;

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
            this.classpath = this.classpath.concatSystemClasspath();
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public boolean isServerSideInterface() {
        return this.serverSideInterface;
    }

    public void setServerSideInterface(boolean serverSideInterface) {
        this.serverSideInterface = serverSideInterface;
    }

    private Map fillOptionMap() {
        HashMap<String, CommandLineOption> optionMap = new HashMap<String, CommandLineOption>();
        optionMap.put("uri", new CommandLineOption("uri", this.getStringArray(this.wsdlFileName)));
        if (this.wsdlVersion != null) {
            optionMap.put("wv", new CommandLineOption("wv", this.getStringArray(this.wsdlVersion)));
        }
        if (this.repositoryPath != null) {
            optionMap.put("r", new CommandLineOption("r", this.getStringArray(this.repositoryPath)));
        }
        if (this.externalMapping != null) {
            optionMap.put("em", new CommandLineOption("em", this.getStringArray(this.externalMapping)));
        }
        if (this.targetSourceFolderLocation != null) {
            optionMap.put("S", new CommandLineOption("S", this.getStringArray(this.targetSourceFolderLocation)));
        }
        if (this.targetResourcesFolderLocation != null) {
            optionMap.put("R", new CommandLineOption("R", this.getStringArray(this.targetResourcesFolderLocation)));
        }
        if (this.unwrap) {
            optionMap.put("uw", new CommandLineOption("uw", new String[0]));
        }
        optionMap.put("o", new CommandLineOption("o", this.getStringArray(this.output)));
        optionMap.put("d", new CommandLineOption("d", this.getStringArray(this.databindingName)));
        if (this.asyncOnly) {
            optionMap.put("a", new CommandLineOption("a", new String[0]));
        }
        if (this.syncOnly) {
            optionMap.put("s", new CommandLineOption("s", new String[0]));
        }
        optionMap.put("p", new CommandLineOption("p", this.getStringArray(this.packageName)));
        optionMap.put("l", new CommandLineOption("l", this.getStringArray(this.language)));
        if (this.serverSide) {
            optionMap.put("ss", new CommandLineOption("ss", new String[0]));
            if (this.generateServiceXml) {
                optionMap.put("sd", new CommandLineOption("sd", new String[0]));
            }
            if (this.generateAllClasses) {
                optionMap.put("g", new CommandLineOption("g", new String[0]));
            }
        }
        if (this.testcase) {
            optionMap.put("t", new CommandLineOption("t", new String[0]));
        }
        if (this.unpackClasses) {
            optionMap.put("u", new CommandLineOption("u", new String[0]));
        }
        if (this.serverSideInterface) {
            optionMap.put("ssi", new CommandLineOption("ssi", new String[0]));
        }
        optionMap.put("sn", new CommandLineOption("sn", new String[]{this.serviceName}));
        optionMap.put("pn", new CommandLineOption("pn", new String[]{this.portName}));
        optionMap.put("ns2p", new CommandLineOption("ns2p", new String[]{this.namespaceToPackages}));
        return optionMap;
    }

    private String[] getStringArray(String value) {
        String[] values = new String[]{value};
        return values;
    }

    public void execute() throws BuildException {
        try {
            AntClassLoader cl = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.getProject(), this.classpath == null ? this.createClasspath() : this.classpath, false);
            Thread.currentThread().setContextClassLoader((ClassLoader)cl);
            Map commandLineOptions = this.fillOptionMap();
            CommandLineOptionParser parser = new CommandLineOptionParser(commandLineOptions);
            new CodeGenerationEngine(parser).generate();
        }
        catch (Throwable e) {
            throw new BuildException(e);
        }
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setGenerateAllClasses(boolean generateAllClasses) {
        this.generateAllClasses = generateAllClasses;
    }

    public void setUnpackClasses(boolean unpackClasses) {
        this.unpackClasses = unpackClasses;
    }

    public void setWsdlFileName(String wsdlFileName) {
        this.wsdlFileName = wsdlFileName;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setAsyncOnly(boolean asyncOnly) {
        this.asyncOnly = asyncOnly;
    }

    public void setSyncOnly(boolean syncOnly) {
        this.syncOnly = syncOnly;
    }

    public void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }

    public void setTestcase(boolean testcase) {
        this.testcase = testcase;
    }

    public void setGenerateServiceXml(boolean generateServiceXml) {
        this.generateServiceXml = generateServiceXml;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public void setExternalMapping(String externalMapping) {
        this.externalMapping = externalMapping;
    }

    public void setWsdlVersion(String wsdlVersion) {
        this.wsdlVersion = wsdlVersion;
    }

    public void setTargetSourceFolderLocation(String targetSourceFolderLocation) {
        this.targetSourceFolderLocation = targetSourceFolderLocation;
    }

    public void setTargetResourcesFolderLocation(String targetResourcesFolderLocation) {
        this.targetResourcesFolderLocation = targetResourcesFolderLocation;
    }

    public void setUnwrap(boolean unwrap) {
        this.unwrap = unwrap;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setClasspath(Path path) {
        this.classpath = path;
    }

    public String getDatabindingName() {
        return this.databindingName;
    }

    public void setDatabindingName(String databindingName) {
        this.databindingName = databindingName;
    }

    public String getNamespaceToPackages() {
        return this.namespaceToPackages;
    }

    public void setNamespaceToPackages(String namespaceToPackages) {
        this.namespaceToPackages = namespaceToPackages;
    }
}

