/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.net.SocketException;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.MembershipScheme;
import org.apache.axis2.clustering.tribes.AtMostOnceInterceptor;
import org.apache.axis2.clustering.tribes.OperationMode;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.Utils;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ManagedChannel;
import org.apache.catalina.tribes.group.interceptors.OrderInterceptor;
import org.apache.catalina.tribes.group.interceptors.TcpFailureDetector;
import org.apache.catalina.tribes.transport.ReceiverBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastBasedMembershipScheme
implements MembershipScheme {
    private static final Log log = LogFactory.getLog(MulticastBasedMembershipScheme.class);
    private final ManagedChannel channel;
    private final Map<String, Parameter> parameters;
    private final byte[] domain;
    private final OperationMode mode;
    private final boolean atmostOnceMessageSemantics;
    private final boolean preserverMsgOrder;

    public MulticastBasedMembershipScheme(ManagedChannel channel, OperationMode mode, Map<String, Parameter> parameters, byte[] domain, boolean atmostOnceMessageSemantics, boolean preserverMsgOrder) {
        this.channel = channel;
        this.mode = mode;
        this.parameters = parameters;
        this.domain = domain;
        this.atmostOnceMessageSemantics = atmostOnceMessageSemantics;
        this.preserverMsgOrder = preserverMsgOrder;
    }

    @Override
    public void init() throws ClusteringFault {
        this.addInterceptors();
        this.configureMulticastParameters();
    }

    @Override
    public void joinGroup() throws ClusteringFault {
    }

    private void configureMulticastParameters() throws ClusteringFault {
        Parameter tcpListenPort;
        String host;
        Parameter mcastMemberDropTime;
        Parameter mcastFrequency;
        Parameter mcastPort;
        Parameter mcastBindAddress;
        Properties mcastProps = this.channel.getMembershipService().getProperties();
        Parameter mcastAddress = this.getParameter("mcastAddress");
        if (mcastAddress != null) {
            mcastProps.setProperty("mcastAddress", ((String)mcastAddress.getValue()).trim());
        }
        if ((mcastBindAddress = this.getParameter("multicastBindAddress")) != null) {
            mcastProps.setProperty("multicastBindAddress", ((String)mcastBindAddress.getValue()).trim());
        }
        if ((mcastPort = this.getParameter("mcastPort")) != null) {
            mcastProps.setProperty("mcastPort", ((String)mcastPort.getValue()).trim());
        }
        if ((mcastFrequency = this.getParameter("mcastFrequency")) != null) {
            mcastProps.setProperty("mcastFrequency", ((String)mcastFrequency.getValue()).trim());
        }
        if ((mcastMemberDropTime = this.getParameter("memberDropTime")) != null) {
            mcastProps.setProperty("memberDropTime", ((String)mcastMemberDropTime.getValue()).trim());
        }
        ReceiverBase receiver = (ReceiverBase)this.channel.getChannelReceiver();
        Parameter tcpListenHost = this.getParameter("localMemberHost");
        if (tcpListenHost != null) {
            host = ((String)tcpListenHost.getValue()).trim();
            mcastProps.setProperty("tcpListenHost", host);
            mcastProps.setProperty("bindAddress", host);
            receiver.setAddress(host);
        } else {
            try {
                host = Utils.getIpAddress();
            }
            catch (SocketException e) {
                String msg = "Could not get local IP address";
                log.error((Object)msg, (Throwable)e);
                throw new ClusteringFault(msg, (Exception)e);
            }
            mcastProps.setProperty("tcpListenHost", host);
            mcastProps.setProperty("bindAddress", host);
            receiver.setAddress(host);
        }
        String localIP = System.getProperty("axis2.local.ip.address");
        if (localIP != null) {
            receiver.setAddress(localIP);
        }
        if ((tcpListenPort = this.getParameter("localMemberPort")) != null) {
            String port = ((String)tcpListenPort.getValue()).trim();
            mcastProps.setProperty("tcpListenPort", port);
            receiver.setPort(Integer.parseInt(port));
        }
        mcastProps.setProperty("mcastClusterDomain", new String(this.domain));
    }

    private void addInterceptors() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding Interceptors...");
        }
        TcpFailureDetector tcpFailureDetector = new TcpFailureDetector();
        tcpFailureDetector.setConnectTimeout(30000L);
        this.channel.addInterceptor((ChannelInterceptor)tcpFailureDetector);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Added TCP Failure Detector");
        }
        this.channel.getMembershipService().setDomain(this.domain);
        this.mode.addInterceptors((Channel)this.channel);
        if (this.atmostOnceMessageSemantics) {
            AtMostOnceInterceptor atMostOnceInterceptor = new AtMostOnceInterceptor();
            atMostOnceInterceptor.setOptionFlag(2048);
            this.channel.addInterceptor((ChannelInterceptor)atMostOnceInterceptor);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Added At-most-once Interceptor");
            }
        }
        if (this.preserverMsgOrder) {
            OrderInterceptor orderInterceptor = new OrderInterceptor();
            orderInterceptor.setOptionFlag(512);
            this.channel.addInterceptor((ChannelInterceptor)orderInterceptor);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Added Message Order Interceptor");
            }
        }
    }

    public Parameter getParameter(String name) {
        return this.parameters.get(name);
    }
}

