/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.context.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContextUtils {
    private static final Log log = LogFactory.getLog(ContextUtils.class);
    private static final String WEBSERVICE_MESSAGE_CONTEXT = "javax.xml.ws.WebServiceContext";

    public static void addProperties(SOAPMessageContext soapMessageContext, org.apache.axis2.jaxws.core.MessageContext jaxwsMessageContext) {
        HttpServletResponse res;
        HttpServletRequest req;
        ServiceDescription sd;
        MessageContext axisMsgContext = jaxwsMessageContext.getAxisMessageContext();
        Map props = axisMsgContext.getOptions().getProperties();
        soapMessageContext.putAll(props);
        EndpointDescription description = jaxwsMessageContext.getEndpointDescription();
        if (description != null && (sd = description.getServiceDescription()) != null) {
            URL wsdlLocation = ((ServiceDescriptionWSDL)sd).getWSDLLocation();
            if (wsdlLocation != null && !"".equals(wsdlLocation)) {
                URI wsdlLocationURI = null;
                try {
                    wsdlLocationURI = wsdlLocation.toURI();
                }
                catch (URISyntaxException ex) {
                    log.warn((Object)("Unable to convert WSDL location URL to URI.  URL: " + wsdlLocation.toString() + "; Service: " + sd.getServiceQName()), (Throwable)ex);
                }
                soapMessageContext.put((Object)"javax.xml.ws.wsdl.description", (Object)wsdlLocationURI);
                soapMessageContext.setScope("javax.xml.ws.wsdl.description", MessageContext.Scope.APPLICATION);
            }
            soapMessageContext.put((Object)"javax.xml.ws.wsdl.service", (Object)sd.getServiceQName());
            soapMessageContext.setScope("javax.xml.ws.wsdl.service", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                log.debug((Object)("WSDL_SERVICE :" + sd.getServiceQName()));
            }
        }
        soapMessageContext.put((Object)"javax.xml.ws.servlet.context", axisMsgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETCONTEXT));
        soapMessageContext.setScope("javax.xml.ws.servlet.context", MessageContext.Scope.APPLICATION);
        if (log.isDebugEnabled()) {
            if (axisMsgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETCONTEXT) != null) {
                log.debug((Object)"Servlet Context Set");
            } else {
                log.debug((Object)"Servlet Context not found");
            }
        }
        if ((req = (HttpServletRequest)axisMsgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST)) == null && log.isDebugEnabled()) {
            log.debug((Object)"HTTPServletRequest not found");
        }
        if (req != null) {
            soapMessageContext.put((Object)"javax.xml.ws.servlet.request", (Object)req);
            soapMessageContext.setScope("javax.xml.ws.servlet.request", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                log.debug((Object)"SERVLET_REQUEST Set");
            }
            String pathInfo = req.getPathInfo();
            soapMessageContext.put((Object)"javax.xml.ws.http.request.pathinfo", (Object)pathInfo);
            soapMessageContext.setScope("javax.xml.ws.http.request.pathinfo", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                if (pathInfo != null) {
                    log.debug((Object)"HTTP_REQUEST_PATHINFO Set");
                } else {
                    log.debug((Object)"HTTP_REQUEST_PATHINFO not found");
                }
            }
            String queryString = req.getQueryString();
            soapMessageContext.put((Object)"javax.xml.ws.http.request.querystring", (Object)queryString);
            soapMessageContext.setScope("javax.xml.ws.http.request.querystring", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                if (queryString != null) {
                    log.debug((Object)"HTTP_REQUEST_QUERYSTRING Set");
                } else {
                    log.debug((Object)"HTTP_REQUEST_QUERYSTRING not found");
                }
            }
            String method = req.getMethod();
            soapMessageContext.put((Object)"javax.xml.ws.http.request.method", (Object)method);
            soapMessageContext.setScope("javax.xml.ws.http.request.method", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                if (method != null) {
                    log.debug((Object)"HTTP_REQUEST_METHOD Set");
                } else {
                    log.debug((Object)"HTTP_REQUEST_METHOD not found");
                }
            }
        }
        if ((res = (HttpServletResponse)axisMsgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE)) == null && log.isDebugEnabled()) {
            log.debug((Object)"Servlet Response not found");
        }
        if (res != null) {
            soapMessageContext.put((Object)"javax.xml.ws.servlet.response", (Object)res);
            soapMessageContext.setScope("javax.xml.ws.servlet.response", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                log.debug((Object)"SERVLET_RESPONSE Set");
            }
        }
        soapMessageContext.put((Object)"javax.xml.ws.http.request.headers", axisMsgContext.getProperty("TRANSPORT_HEADERS"));
        soapMessageContext.setScope("javax.xml.ws.http.request.headers", MessageContext.Scope.APPLICATION);
        soapMessageContext.put((Object)"javax.xml.ws.http.response.code", axisMsgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE));
        soapMessageContext.setScope("javax.xml.ws.http.response.code", MessageContext.Scope.APPLICATION);
        soapMessageContext.put((Object)"javax.xml.ws.http.response.headers", null);
        soapMessageContext.setScope("javax.xml.ws.http.response.headers", MessageContext.Scope.APPLICATION);
        soapMessageContext.put((Object)"javax.xml.ws.binding.attachments.inbound", (Object)axisMsgContext.getAttachmentMap());
        soapMessageContext.setScope("javax.xml.ws.binding.attachments.inbound", MessageContext.Scope.APPLICATION);
        soapMessageContext.put((Object)"javax.xml.ws.binding.attachments.outbound", null);
        soapMessageContext.setScope("javax.xml.ws.binding.attachments.outbound", MessageContext.Scope.APPLICATION);
    }

    public static void addWSDLProperties(org.apache.axis2.jaxws.core.MessageContext jaxwsMessageContext) {
        OperationDescription op;
        WebServiceContext wsc;
        MessageContext msgContext = jaxwsMessageContext.getAxisMessageContext();
        ServiceContext serviceContext = msgContext.getServiceContext();
        SOAPMessageContext soapMessageContext = null;
        if (serviceContext != null && (wsc = (WebServiceContext)serviceContext.getProperty(WEBSERVICE_MESSAGE_CONTEXT)) != null) {
            soapMessageContext = (SOAPMessageContext)wsc.getMessageContext();
        }
        if ((op = jaxwsMessageContext.getOperationDescription()) != null && soapMessageContext != null) {
            EndpointInterfaceDescription eid;
            soapMessageContext.put((Object)"javax.xml.ws.wsdl.operation", (Object)op.getName());
            soapMessageContext.setScope("javax.xml.ws.wsdl.operation", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                log.debug((Object)("WSDL_OPERATION :" + op.getName()));
            }
            if ((eid = op.getEndpointInterfaceDescription()) != null) {
                EndpointDescription ed = eid.getEndpointDescription();
                QName portType = eid.getPortType();
                if ((portType == null || portType.getLocalPart() == "") && log.isDebugEnabled()) {
                    log.debug((Object)"Did not get port type from EndpointInterfaceDescription, attempting to get PortType from EndpointDescription");
                }
                if (ed != null) {
                    soapMessageContext.put((Object)"javax.xml.ws.wsdl.port", (Object)ed.getPortQName());
                    soapMessageContext.setScope("javax.xml.ws.wsdl.port", MessageContext.Scope.APPLICATION);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("WSDL_PORT :" + ed.getPortQName()));
                    }
                }
                soapMessageContext.put((Object)"javax.xml.ws.wsdl.interface", (Object)portType);
                soapMessageContext.setScope("javax.xml.ws.wsdl.interface", MessageContext.Scope.APPLICATION);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("WSDL_INTERFACE :" + portType));
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Unable to read WSDL operation, port and interface properties");
        }
    }
}

