/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.core.controller;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.core.controller.InvocationPattern;
import org.apache.axis2.jaxws.core.util.MessageContextUtils;
import org.apache.axis2.jaxws.handler.HandlerChainProcessor;
import org.apache.axis2.jaxws.handler.HandlerInvokerUtils;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InvocationController {
    private static final Log log = LogFactory.getLog(InvocationController.class);

    public InvocationContext invoke(InvocationContext ic) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invocation pattern: synchronous");
        }
        if (ic == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICErr1"));
        }
        if (ic.getRequestMessageContext() == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICErr2"));
        }
        MessageContext request = ic.getRequestMessageContext();
        MessageContext response = null;
        request.getProperties().put("org.apache.axis2.jaxws.invocation.pattern", (Object)InvocationPattern.SYNC);
        boolean success = HandlerInvokerUtils.invokeOutboundHandlers(request, ic.getHandlers(), request.getEndpointDescription(), HandlerChainProcessor.MEP.REQUEST, false);
        if (success) {
            this.prepareRequest(request);
            response = this.doInvoke(request);
            this.prepareResponse(response);
            response.setEndpointDescription(request.getEndpointDescription());
            HandlerInvokerUtils.invokeInboundHandlers(response, ic.getHandlers(), request.getEndpointDescription(), HandlerChainProcessor.MEP.RESPONSE, false);
        } else {
            response = MessageContextUtils.createMinimalResponseMessageContext(request);
            response.setMessage(request.getMessage());
        }
        ic.setResponseMessageContext(response);
        return ic;
    }

    protected abstract MessageContext doInvoke(MessageContext var1);

    public void invokeOneWay(InvocationContext ic) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invocation pattern: one-way");
        }
        if (ic == null) {
            throw ExceptionFactory.makeWebServiceException((String)"ICErr1");
        }
        if (ic.getRequestMessageContext() == null) {
            throw ExceptionFactory.makeWebServiceException((String)"ICErr2");
        }
        MessageContext request = ic.getRequestMessageContext();
        request.getProperties().put("org.apache.axis2.jaxws.invocation.pattern", (Object)InvocationPattern.ONEWAY);
        boolean success = HandlerInvokerUtils.invokeOutboundHandlers(request, ic.getHandlers(), request.getEndpointDescription(), HandlerChainProcessor.MEP.REQUEST, false);
        if (success) {
            this.prepareRequest(request);
            this.doInvokeOneWay(request);
        }
    }

    protected abstract void doInvokeOneWay(MessageContext var1);

    public Response invokeAsync(InvocationContext ic) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invocation pattern: asynchronous(polling)");
        }
        if (ic == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICErr1"));
        }
        if (ic.getRequestMessageContext() == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICErr2"));
        }
        MessageContext request = ic.getRequestMessageContext();
        request.getProperties().put("org.apache.axis2.jaxws.invocation.pattern", (Object)InvocationPattern.ASYNC_POLLING);
        Response resp = null;
        boolean success = HandlerInvokerUtils.invokeOutboundHandlers(request, ic.getHandlers(), request.getEndpointDescription(), HandlerChainProcessor.MEP.REQUEST, false);
        if (success) {
            this.prepareRequest(request);
            resp = this.doInvokeAsync(request);
        }
        return resp;
    }

    public abstract Response doInvokeAsync(MessageContext var1);

    public Future<?> invokeAsync(InvocationContext ic, AsyncHandler asyncHandler) {
        ExecutorService es;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invocation pattern: asynchronous(callback)");
        }
        if (ic == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICErr1"));
        }
        if (ic.getRequestMessageContext() == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICErr2"));
        }
        if (ic.getExecutor() != null && ic.getExecutor() instanceof ExecutorService && (es = (ExecutorService)ic.getExecutor()).isShutdown()) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ExecutorShutdown"));
        }
        MessageContext request = ic.getRequestMessageContext();
        request.getProperties().put("org.apache.axis2.jaxws.invocation.pattern", (Object)InvocationPattern.ASYNC_CALLBACK);
        Future<?> future = null;
        boolean success = HandlerInvokerUtils.invokeOutboundHandlers(request, ic.getHandlers(), request.getEndpointDescription(), HandlerChainProcessor.MEP.REQUEST, false);
        if (!success) {
            throw ExceptionFactory.makeWebServiceException((String)"A client outbound handler cause a message flow direction reversal.  This case is not yet implemented.");
        }
        this.prepareRequest(request);
        future = this.doInvokeAsync(request, asyncHandler);
        return future;
    }

    public abstract Future<?> doInvokeAsync(MessageContext var1, AsyncHandler var2);

    protected abstract void prepareRequest(MessageContext var1);

    protected abstract void prepareResponse(MessageContext var1);
}

