/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerType;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.runtime.description.injection.ResourceInjectionServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.injection.impl.ResourceInjectionServiceRuntimeDescriptionBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerResolverImpl
implements HandlerResolver {
    static final Map<String, String> protocolBindingsMap = new HashMap<String, String>(5);
    private static Log log;
    private EndpointDescription endpointDesc;

    public HandlerResolverImpl(EndpointDescription ed) {
        this.endpointDesc = ed;
    }

    public ArrayList<Handler> getHandlerChain(PortInfo portinfo) {
        return this.resolveHandlers(portinfo);
    }

    private ArrayList<Handler> resolveHandlers(PortInfo portinfo) throws WebServiceException {
        Iterator it;
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        HandlerChainsType handlerCT = this.endpointDesc.getHandlerChain();
        Iterator iterator = it = handlerCT == null ? null : handlerCT.getHandlerChain().iterator();
        while (it != null && it.hasNext()) {
            HandlerChainType handlerChainType = (HandlerChainType)it.next();
            if (!HandlerResolverImpl.chainResolvesToPort(handlerChainType, portinfo)) continue;
            List handlerTypeList = handlerChainType.getHandler();
            for (HandlerType handlerType : handlerTypeList) {
                Handler handler;
                String portHandler = handlerType.getHandlerClass().getValue();
                try {
                    handler = (Handler)HandlerResolverImpl.loadClass(portHandler).newInstance();
                    HandlerResolverImpl.callHandlerPostConstruct(handler, this.endpointDesc.getServiceDescription());
                }
                catch (ClassNotFoundException e) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)e);
                }
                catch (InstantiationException ie) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)ie);
                }
                catch (IllegalAccessException e) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)e);
                }
                if (LogicalHandler.class.isAssignableFrom(handler.getClass())) {
                    handlers.add((Handler)((LogicalHandler)handler));
                    continue;
                }
                if (SOAPHandler.class.isAssignableFrom(handler.getClass())) {
                    handlers.add((Handler)((SOAPHandler)handler));
                    continue;
                }
                if (Handler.class.isAssignableFrom(handler.getClass())) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"handlerChainErr1", (String)handler.getClass().getName()));
                }
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"handlerChainErr2", (String)handler.getClass().getName()));
            }
        }
        return handlers;
    }

    private static Class loadClass(String clazz) throws ClassNotFoundException {
        return HandlerResolverImpl.forName(clazz, true, HandlerResolverImpl.getContextClassLoader());
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classLoader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className, initialize, classLoader);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e.getException());
        }
        return cl;
    }

    private static void callHandlerPostConstruct(Handler handler, ServiceDescription serviceDesc) throws WebServiceException {
        Method pcMethod;
        ResourceInjectionServiceRuntimeDescription resInj = ResourceInjectionServiceRuntimeDescriptionBuilder.create(serviceDesc, handler.getClass());
        if (resInj != null && (pcMethod = resInj.getPostConstructMethod()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invoking Method with @PostConstruct annotation");
            }
            HandlerResolverImpl.invokeMethod(handler, pcMethod, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Completed invoke on Method with @PostConstruct annotation");
            }
        }
    }

    private static void callHandlerPreDestroy(Handler handler, ServiceDescription serviceDesc) throws WebServiceException {
        Method pcMethod;
        ResourceInjectionServiceRuntimeDescription resInj = ResourceInjectionServiceRuntimeDescriptionBuilder.create(serviceDesc, handler.getClass());
        if (resInj != null && (pcMethod = resInj.getPreDestroyMethod()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invoking Method with @PostConstruct annotation");
            }
            HandlerResolverImpl.invokeMethod(handler, pcMethod, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Completed invoke on Method with @PostConstruct annotation");
            }
        }
    }

    private static void invokeMethod(Handler handlerInstance, Method m, Object[] params) throws WebServiceException {
        try {
            m.invoke((Object)handlerInstance, params);
        }
        catch (InvocationTargetException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    private static boolean chainResolvesToPort(HandlerChainType handlerChainType, PortInfo portinfo) {
        List protocolBindings = handlerChainType.getProtocolBindings();
        if (protocolBindings != null) {
            boolean match = true;
            Iterator it = protocolBindings.iterator();
            while (it.hasNext()) {
                match = false;
                String protocolBinding = (String)it.next();
                protocolBinding = protocolBinding.startsWith("##") ? protocolBindingsMap.get(protocolBinding) : protocolBinding;
                if (protocolBinding == null || !protocolBinding.equals(portinfo.getBindingID())) continue;
                match = true;
                break;
            }
            if (!match) {
                return match;
            }
        }
        if (!HandlerResolverImpl.doesPatternMatch(portinfo.getPortName(), handlerChainType.getPortNamePattern())) {
            return false;
        }
        return HandlerResolverImpl.doesPatternMatch(portinfo.getServiceName(), handlerChainType.getServiceNamePattern());
    }

    private static boolean doesPatternMatch(QName portInfoQName, QName pattern) {
        if (pattern == null) {
            return true;
        }
        String portInfoString = portInfoQName.toString();
        String patternString = pattern.toString();
        if (patternString.equals("*")) {
            return true;
        }
        if (patternString.contains("*")) {
            patternString = patternString.substring(0, patternString.length() - 1);
            return portInfoString.startsWith(patternString);
        }
        return portInfoString.equals(patternString);
    }

    static {
        protocolBindingsMap.put("##SOAP11_HTTP", "http://schemas.xmlsoap.org/wsdl/soap/http");
        protocolBindingsMap.put("##SOAP11_HTTP_MTOM", "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
        protocolBindingsMap.put("##SOAP12_HTTP", "http://www.w3.org/2003/05/soap/bindings/HTTP/");
        protocolBindingsMap.put("##SOAP12_HTTP_MTOM", "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
        protocolBindingsMap.put("##XML_HTTP", "http://www.w3.org/2004/08/wsdl/http");
        log = LogFactory.getLog(HandlerResolverImpl.class);
    }
}

