/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.LogicalMessage;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.databinding.JAXBBlockContext;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.factory.JAXBBlockFactory;
import org.apache.axis2.jaxws.message.factory.SourceBlockFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;

public class LogicalMessageImpl
implements LogicalMessage {
    private Message message;

    public LogicalMessageImpl(Message m) {
        this.message = m;
    }

    public Source getPayload() {
        SourceBlockFactory factory = (SourceBlockFactory)FactoryRegistry.getFactory(SourceBlockFactory.class);
        Source payload = (Source)this._getPayload(null, factory);
        return payload;
    }

    public Object getPayload(JAXBContext context) {
        JAXBBlockFactory factory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);
        JAXBBlockContext jbc = new JAXBBlockContext(context);
        Object payload = this._getPayload(jbc, factory);
        return payload;
    }

    private Object _getPayload(Object context, BlockFactory factory) {
        Object payload = null;
        try {
            Block block = this.message.getBodyBlock(context, factory);
            Object content = block.getBusinessObject(true);
            Payloads payloads = this.createPayloads(content);
            Block cacheBlock = factory.createFrom(payloads.CACHE_PAYLOAD, context, block.getQName());
            this.message.setBodyBlock(cacheBlock);
            payload = payloads.HANDLER_PAYLOAD;
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        return payload;
    }

    public void setPayload(Object obj, JAXBContext context) {
        JAXBBlockFactory factory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);
        JAXBBlockContext jbc = new JAXBBlockContext(context);
        this._setPayload(obj, jbc, factory);
    }

    public void setPayload(Source source) {
        SourceBlockFactory factory = (SourceBlockFactory)FactoryRegistry.getFactory(SourceBlockFactory.class);
        this._setPayload(source, null, factory);
    }

    private void _setPayload(Object object, Object context, BlockFactory factory) {
        Block block = factory.createFrom(object, context, null);
        if (this.message != null) {
            this.message.setBodyBlock(block);
        }
    }

    private Payloads createPayloads(Object content) {
        if (content == null) {
            return null;
        }
        Payloads payloads = new Payloads();
        if (Source.class.isAssignableFrom(content.getClass())) {
            try {
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                StreamResult result = new StreamResult(baos);
                Source source = (Source)content;
                trans.transform(source, result);
                trans.setOutputProperty("omit-xml-declaration", "yes");
                byte[] bytes = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                payloads.HANDLER_PAYLOAD = new StreamSource(bais);
                byte[] cacheBytes = new byte[bytes.length];
                System.arraycopy(bytes, 0, cacheBytes, 0, bytes.length);
                ByteArrayInputStream cacheBais = new ByteArrayInputStream(cacheBytes);
                payloads.CACHE_PAYLOAD = new StreamSource(cacheBais);
            }
            catch (TransformerConfigurationException e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
            catch (TransformerFactoryConfigurationError e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
            catch (TransformerException e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
        } else {
            payloads.HANDLER_PAYLOAD = content;
            payloads.CACHE_PAYLOAD = content;
        }
        return payloads;
    }

    class Payloads {
        Object HANDLER_PAYLOAD;
        Object CACHE_PAYLOAD;

        Payloads() {
        }
    }
}

