/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.attachments;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.message.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXBAttachmentMarshaller
extends AttachmentMarshaller {
    private static final Log log = LogFactory.getLog(JAXBAttachmentMarshaller.class);
    private Message message;
    private XMLStreamWriter writer;
    private final String APPLICATION_OCTET = "application/octet-stream";

    public JAXBAttachmentMarshaller(Message message, XMLStreamWriter writer) {
        this.message = message;
        this.writer = writer;
    }

    public boolean isXOPPackage() {
        boolean value = false;
        if (this.message != null) {
            value = this.message.isMTOMEnabled();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("isXOPPackage returns " + value));
        }
        return value;
    }

    public String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String namespace, String localPart) {
        String cid;
        if (mimeType == null || mimeType.length() == 0) {
            mimeType = "application/octet-stream";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding MTOM/XOP byte array attachment for element: {" + namespace + "}" + localPart));
        }
        try {
            InternetHeaders ih = new InternetHeaders();
            ih.setHeader("Content-Type", mimeType);
            MimeBodyPart mbp = new MimeBodyPart(ih, data);
            MimePartDataSource mpds = new MimePartDataSource((MimePart)mbp);
            DataHandler dataHandler = new DataHandler((DataSource)mpds);
            cid = this.addDataHandler(dataHandler);
            mbp.setHeader("Content-Id", cid);
        }
        catch (Throwable t) {
            throw ExceptionFactory.makeWebServiceException((Throwable)t);
        }
        return "cid:" + cid;
    }

    public String addMtomAttachment(DataHandler data, String namespace, String localPart) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding MTOM/XOP datahandler attachment for element: {" + namespace + "}" + localPart));
        }
        String cid = this.addDataHandler(data);
        return "cid:" + cid;
    }

    public String addSwaRefAttachment(DataHandler data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding SWAREF attachment");
        }
        String cid = this.addDataHandler(data);
        return "cid:" + cid;
    }

    private String addDataHandler(DataHandler dh) {
        String cid = null;
        OMTextImpl textNode = null;
        if (this.writer instanceof MTOMXMLStreamWriter) {
            textNode = new OMTextImpl((Object)dh, null);
            cid = textNode.getContentID();
            ((MTOMXMLStreamWriter)this.writer).writeOptimized((OMText)textNode);
        } else {
            cid = UUIDGenerator.getUUID();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("   content id=" + cid));
            log.debug((Object)("   dataHandler  =" + dh));
        }
        this.message.addDataHandler(dh, cid);
        return cid;
    }
}

