/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding;

import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.ws.Holder;
import org.apache.axis2.jaxws.message.databinding.JAXBUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBBlockContext {
    private static final Log log = LogFactory.getLog(JAXBBlockContext.class);
    private TreeSet<String> contextPackages;
    private String contextPackagesKey;
    private JAXBContext jaxbContext = null;
    private JAXBUtils.CONSTRUCTION_TYPE constructionType = JAXBUtils.CONSTRUCTION_TYPE.UNKNOWN;
    private Class processType = null;

    public JAXBBlockContext(TreeSet<String> packages, String packagesKey) {
        this.contextPackages = packages;
        this.contextPackagesKey = packagesKey;
    }

    public JAXBBlockContext(TreeSet<String> packages) {
        this(packages, packages.toString());
    }

    public JAXBBlockContext(String contextPackage) {
        this.contextPackages = new TreeSet();
        this.contextPackages.add(contextPackage);
        this.contextPackagesKey = this.contextPackages.toString();
    }

    public JAXBBlockContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public TreeSet<String> getContextPackages() {
        return this.contextPackages;
    }

    public JAXBContext getJAXBContext() throws JAXBException {
        if (this.jaxbContext == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"A JAXBContext did not exist, creating a new one with the context packages.");
            }
            Holder constructType = new Holder();
            this.jaxbContext = JAXBUtils.getJAXBContext(this.contextPackages, (Holder<JAXBUtils.CONSTRUCTION_TYPE>)constructType, this.contextPackagesKey);
            this.constructionType = (JAXBUtils.CONSTRUCTION_TYPE)((Object)constructType.value);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Using an existing JAXBContext");
        }
        return this.jaxbContext;
    }

    public Class getProcessType() {
        return this.processType;
    }

    public void setProcessType(Class type) {
        this.processType = type;
    }

    public JAXBUtils.CONSTRUCTION_TYPE getConstructionType() {
        return this.constructionType;
    }
}

