/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedAction;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.attachments.JAXBAttachmentMarshaller;
import org.apache.axis2.jaxws.message.attachments.JAXBAttachmentUnmarshaller;
import org.apache.axis2.jaxws.message.databinding.JAXBBlock;
import org.apache.axis2.jaxws.message.databinding.JAXBBlockContext;
import org.apache.axis2.jaxws.message.databinding.JAXBUtils;
import org.apache.axis2.jaxws.message.databinding.XSDListUtils;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.impl.BlockImpl;
import org.apache.axis2.jaxws.utility.XMLRootElementUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXBBlockImpl
extends BlockImpl
implements JAXBBlock {
    private static final Log log = LogFactory.getLog(JAXBBlockImpl.class);

    JAXBBlockImpl(Object busObject, JAXBBlockContext busContext, QName qName, BlockFactory factory) throws JAXBException {
        super(busObject, (Object)busContext, qName, factory);
    }

    JAXBBlockImpl(OMElement omElement, JAXBBlockContext busContext, QName qName, BlockFactory factory) {
        super(omElement, (Object)busContext, qName, factory);
    }

    protected Object _getBOFromReader(XMLStreamReader reader, Object busContext) throws XMLStreamException, WebServiceException {
        JAXBBlockContext ctx = (JAXBBlockContext)busContext;
        try {
            Unmarshaller u = JAXBUtils.getJAXBUnmarshaller(ctx.getJAXBContext());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding JAXBAttachmentUnmarshaller to Unmarshaller");
            }
            Message msg = this.getParent();
            JAXBAttachmentUnmarshaller aum = new JAXBAttachmentUnmarshaller(msg);
            u.setAttachmentUnmarshaller((AttachmentUnmarshaller)aum);
            Object jaxb = null;
            jaxb = ctx.getProcessType() == null ? JAXBBlockImpl.unmarshalByElement(u, reader) : JAXBBlockImpl.unmarshalByType(u, reader, ctx.getProcessType());
            JAXBUtils.releaseJAXBUnmarshaller(ctx.getJAXBContext(), u);
            reader.close();
            return jaxb;
        }
        catch (JAXBException je) {
            if (log.isDebugEnabled()) {
                try {
                    log.debug((Object)("JAXBContext for unmarshal failure:" + ctx.getJAXBContext()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)je);
        }
    }

    private byte[] _getBytesFromBO(Object busObj, Object busContext, String encoding) throws XMLStreamException, WebServiceException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriter writer = StAXUtils.createXMLStreamWriter((OutputStream)baos, (String)encoding);
        this._outputFromBO(busObj, busContext, writer);
        writer.flush();
        writer.close();
        return baos.toByteArray();
    }

    protected XMLStreamReader _getReaderFromBO(Object busObj, Object busContext) throws XMLStreamException, WebServiceException {
        ByteArrayInputStream baos = new ByteArrayInputStream(this._getBytesFromBO(busObj, busContext, "utf-8"));
        return StAXUtils.createXMLStreamReader((InputStream)baos, (String)"utf-8");
    }

    protected void _outputFromBO(Object busObject, Object busContext, XMLStreamWriter writer) throws XMLStreamException, WebServiceException {
        JAXBBlockContext ctx = (JAXBBlockContext)busContext;
        try {
            Marshaller m = JAXBUtils.getJAXBMarshaller(ctx.getJAXBContext());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding JAXBAttachmentMarshaller to Marshaller");
            }
            Message msg = this.getParent();
            JAXBAttachmentMarshaller am = new JAXBAttachmentMarshaller(msg, writer);
            m.setAttachmentMarshaller((AttachmentMarshaller)am);
            if (ctx.getProcessType() == null) {
                JAXBBlockImpl.marshalByElement(busObject, m, writer);
            } else {
                JAXBBlockImpl.marshalByType(busObject, m, writer, ctx.getProcessType());
            }
            JAXBUtils.releaseJAXBMarshaller(ctx.getJAXBContext(), m);
        }
        catch (JAXBException je) {
            if (log.isDebugEnabled()) {
                try {
                    log.debug((Object)("JAXBContext for marshal failure:" + ctx.getJAXBContext()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)je);
        }
    }

    private static QName getQName(Object jaxb, JAXBBlockContext ctx) throws JAXBException {
        JAXBIntrospector jbi = JAXBUtils.getJAXBIntrospector(ctx.getJAXBContext());
        QName qName = jbi.getElementName(jaxb);
        JAXBUtils.releaseJAXBIntrospector(ctx.getJAXBContext(), jbi);
        return qName;
    }

    private static void marshalByElement(Object b, Marshaller m, XMLStreamWriter writer) throws WebServiceException {
        try {
            m.marshal(b, writer);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    private static Object unmarshalByElement(final Unmarshaller u, final XMLStreamReader reader) throws WebServiceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invoking unMarshalByElement");
            }
            return AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    try {
                        return u.unmarshal(reader);
                    }
                    catch (Exception e) {
                        throw ExceptionFactory.makeWebServiceException((Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    private static void marshalByType(Object b, Marshaller m, XMLStreamWriter writer, Class type) throws WebServiceException {
        try {
            if (JAXBBlockImpl.isXSDList(type)) {
                QName qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(b);
                String text = XSDListUtils.toXSDListString(JAXBBlockImpl.getTypeEnabledObject(b));
                b = new JAXBElement(qName, String.class, (Object)text);
            }
            m.marshal(b, writer);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    private static Object unmarshalByType(Unmarshaller u, XMLStreamReader reader, Class type) throws WebServiceException {
        try {
            JAXBElement jaxb;
            if (!JAXBBlockImpl.isXSDList(type)) {
                jaxb = u.unmarshal(reader, type);
            } else {
                jaxb = u.unmarshal(reader, String.class);
                if (JAXBBlockImpl.getTypeEnabledObject(jaxb) instanceof String) {
                    QName qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(jaxb);
                    Object obj = XSDListUtils.fromXSDListString((String)JAXBBlockImpl.getTypeEnabledObject(jaxb), type);
                    jaxb = new JAXBElement(qName, type, obj);
                }
            }
            return jaxb;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    private static boolean isXSDList(Class t) {
        return t.isArray() || List.class.isAssignableFrom(t);
    }

    public boolean isElementData() {
        return true;
    }

    static Object getTypeEnabledObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JAXBElement) {
            return ((JAXBElement)obj).getValue();
        }
        return obj;
    }
}

