/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.attachments.AttachmentUtils;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageUtils {
    private static final Log log = LogFactory.getLog(MessageUtils.class);

    public static SOAPFactory getSOAPFactory(OMElement e) {
        OMFactory factory;
        StAXBuilder staxBuilder;
        OMDocument document;
        OMXMLParserWrapper builder = e.getBuilder();
        if (builder instanceof StAXBuilder && (document = (staxBuilder = (StAXBuilder)builder).getDocument()) != null && (factory = document.getOMFactory()) instanceof SOAPFactory) {
            return (SOAPFactory)factory;
        }
        while (e != null && !(e instanceof SOAPEnvelope)) {
            e = (OMElement)e.getParent();
        }
        if (e instanceof SOAPEnvelope) {
            if ("http://schemas.xmlsoap.org/soap/envelope/".equals(e.getNamespace().getNamespaceURI())) {
                return OMAbstractFactory.getSOAP11Factory();
            }
            return OMAbstractFactory.getSOAP12Factory();
        }
        return null;
    }

    public static AttachmentPart createAttachmentPart(String cid, DataHandler dh, SOAPMessage message) {
        AttachmentPart ap = message.createAttachmentPart(dh);
        ap.setContentId(cid);
        return ap;
    }

    public static Message getMessageFromMessageContext(MessageContext msgContext) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start getMessageFromMessageContext");
        }
        Message message = null;
        SOAPEnvelope soapEnv = msgContext.getEnvelope();
        if (soapEnv != null) {
            MessageFactory msgFactory = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            try {
                Protocol protocol = msgContext.isDoingREST() ? Protocol.rest : null;
                message = msgFactory.createFrom((OMElement)soapEnv, protocol);
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException((String)"Could not create new Message");
            }
            Object property = msgContext.getProperty("enableMTOM");
            if (property != null && JavaUtils.isTrueExplicitly((Object)property)) {
                message.setMTOMEnabled(true);
            }
            MimeHeaders mhs = message.getMimeHeaders();
            Map headerMap = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
            if (headerMap != null) {
                for (String key : headerMap.keySet()) {
                    String value = (String)headerMap.get(key);
                    mhs.addHeader(key, value);
                }
            }
        }
        return message;
    }

    public static void putMessageOnMessageContext(Message message, MessageContext msgContext) throws AxisFault, WebServiceException {
        SOAPEnvelope envelope = (SOAPEnvelope)message.getAsOMElement();
        msgContext.setEnvelope(envelope);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Iterator it = message.getMimeHeaders().getAllHeaders();
        while (it.hasNext()) {
            MimeHeader mh = (MimeHeader)it.next();
            headerMap.put(mh.getName(), mh.getValue());
        }
        msgContext.setProperty("TRANSPORT_HEADERS", headerMap);
        if (message.getProtocol() == Protocol.rest) {
            msgContext.setDoingREST(true);
        }
        if (message.isMTOMEnabled()) {
            Options opts = msgContext.getOptions();
            opts.setProperty("enableMTOM", (Object)"true");
        }
    }

    private static void makeBinaryNodes(Message msg) {
        SOAPEnvelope envelope;
        ArrayList<OMElement> xops;
        if (log.isDebugEnabled()) {
            log.debug((Object)"MTOM is enabled on the JAX-WS Message...look for XOP Includes");
        }
        if ((xops = AttachmentUtils.findXopElements((OMElement)(envelope = (SOAPEnvelope)msg.getAsOMElement()))) != null && xops.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found XOP:Include Elements");
            }
            QName href = new QName("", "href");
            for (OMElement xop : xops) {
                String cid = xop.getAttributeValue(href);
                DataHandler dh = msg.removeDataHandler(cid);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Create Binary OMNode for attachment:" + cid));
                }
                OMText binaryNode = AttachmentUtils.makeBinaryOMNode(xop, dh);
                xop.insertSiblingAfter((OMNode)binaryNode);
                xop.detach();
            }
        }
    }

    private static void makeXOPIncludeNodes(MessageContext msgContext, Message message) {
        Attachments as = (Attachments)msgContext.getProperty("Attachments");
        if (as != null) {
            ArrayList<OMText> binaryNodes;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found Axis MTOM Attachments");
            }
            if ((binaryNodes = AttachmentUtils.findBinaryNodes((SOAPEnvelope)message.getAsOMElement())) != null && binaryNodes.size() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found " + binaryNodes.size() + "MTOM Binary Nodes"));
                }
                for (OMText node : binaryNodes) {
                    OMElement xop = AttachmentUtils.makeXopElement(node);
                    node.getParent().addChild((OMNode)xop);
                    node.detach();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Create MTOM Message Attachment for " + node.getContentID()));
                    }
                    message.addDataHandler((DataHandler)node.getDataHandler(), node.getContentID());
                }
            }
        }
    }
}

