/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.util;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.jaxws.message.util.XMLStreamReaderFilter;

public class XMLStreamReaderSplitter
extends XMLStreamReaderFilter {
    int depth = 0;
    boolean start = true;

    public XMLStreamReaderSplitter(XMLStreamReader reader) {
        super(reader);
        this.init();
    }

    private void init() {
        this.depth = 0;
        this.start = true;
    }

    public int next() throws XMLStreamException {
        if (this.start) {
            this.start = false;
            this.depth = 1;
            int event = super.next();
            while (event != 1) {
                if (event == 1) {
                    return event;
                }
                if (this.hasNext()) {
                    event = super.next();
                    continue;
                }
                return event;
            }
            return event;
        }
        if (this.depth == 0) {
            return 8;
        }
        int event = super.next();
        if (event == 1) {
            ++this.depth;
        } else if (event == 2) {
            --this.depth;
        }
        return event;
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.depth == 0) {
            if (this.start) {
                return super.hasNext();
            }
            return false;
        }
        return super.hasNext();
    }

    public XMLStreamReader getNextReader() throws XMLStreamException {
        if (!this.hasNext()) {
            this.init();
            if (this.hasNext()) {
                return this;
            }
            return null;
        }
        return null;
    }

    public void close() throws XMLStreamException {
        if (!super.hasNext()) {
            super.close();
        }
    }
}

