/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server;

import javax.xml.ws.Binding;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.InvocationContextFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.util.MessageUtils;
import org.apache.axis2.jaxws.server.EndpointController;
import org.apache.axis2.util.ThreadContextMigratorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXWSMessageReceiver
implements MessageReceiver {
    private static final Log log = LogFactory.getLog(JAXWSMessageReceiver.class);
    private static String PARAM_SERVICE_CLASS = "ServiceClass";
    public static String PARAM_BINDING = "Binding";

    public void receive(MessageContext axisRequestMsgCtx) throws AxisFault {
        AxisFault faultToReturn = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"new request received");
        }
        AxisService service = axisRequestMsgCtx.getAxisService();
        AxisOperation operation = axisRequestMsgCtx.getAxisOperation();
        String mep = operation.getMessageExchangePattern();
        if (log.isDebugEnabled()) {
            log.debug((Object)("MEP: " + mep));
        }
        Parameter svcClassParam = service.getParameter(PARAM_SERVICE_CLASS);
        try {
            if (svcClassParam == null) {
                throw new RuntimeException(Messages.getMessage((String)"JAXWSMessageReceiverNoServiceClass"));
            }
            ThreadContextMigratorUtil.performMigrationToThread((String)"JAXWS-ThreadContextMigrator-List", (MessageContext)axisRequestMsgCtx);
            EndpointController endpointCtlr = new EndpointController();
            org.apache.axis2.jaxws.core.MessageContext requestMsgCtx = new org.apache.axis2.jaxws.core.MessageContext(axisRequestMsgCtx);
            Binding binding = (Binding)axisRequestMsgCtx.getProperty(PARAM_BINDING);
            InvocationContext ic = InvocationContextFactory.createInvocationContext(binding);
            ic.setRequestMessageContext(requestMsgCtx);
            ic = endpointCtlr.invoke(ic);
            org.apache.axis2.jaxws.core.MessageContext responseMsgCtx = ic.getResponseMessageContext();
            if (!this.isMepInOnly(mep) || this.hasFault(responseMsgCtx)) {
                MessageContext axisResponseMsgCtx = responseMsgCtx.getAxisMessageContext();
                MessageUtils.putMessageOnMessageContext(responseMsgCtx.getMessage(), axisResponseMsgCtx);
                OperationContext opCtx = axisResponseMsgCtx.getOperationContext();
                opCtx.addMessageContext(axisResponseMsgCtx);
                if (responseMsgCtx.getMessage().isFault()) {
                    faultToReturn = new AxisFault("An error was detected during JAXWS processing", axisResponseMsgCtx);
                } else {
                    ThreadContextMigratorUtil.performMigrationToContext((String)"JAXWS-ThreadContextMigrator-List", (MessageContext)axisResponseMsgCtx);
                    AxisEngine engine = new AxisEngine(axisResponseMsgCtx.getConfigurationContext());
                    engine.send(axisResponseMsgCtx);
                    ThreadContextMigratorUtil.performContextCleanup((String)"JAXWS-ThreadContextMigrator-List", (MessageContext)axisResponseMsgCtx);
                }
            }
        }
        catch (Exception e) {
            ThreadContextMigratorUtil.performThreadCleanup((String)"JAXWS-ThreadContextMigrator-List", (MessageContext)axisRequestMsgCtx);
            WebServiceException wse = ExceptionFactory.makeWebServiceException((Throwable)e);
            throw AxisFault.makeFault((Exception)((Object)wse));
        }
        ThreadContextMigratorUtil.performThreadCleanup((String)"JAXWS-ThreadContextMigrator-List", (MessageContext)axisRequestMsgCtx);
        if (faultToReturn != null) {
            throw faultToReturn;
        }
    }

    private boolean hasFault(org.apache.axis2.jaxws.core.MessageContext responseMsgCtx) {
        if (responseMsgCtx == null || responseMsgCtx.getMessage() == null) {
            return false;
        }
        return responseMsgCtx.getMessage().isFault();
    }

    private boolean isMepInOnly(String mep) {
        boolean inOnly = mep.equals("http://www.w3.org/2004/08/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2004/08/wsdl/in-only") || mep.equals("http://www.w3.org/ns/wsdl/in-only") || mep.equals("http://www.w3.org/ns/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2006/01/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2006/01/wsdl/in-only");
        return inOnly;
    }
}

