/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.endpoint.lifecycle.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.xml.ws.WebServiceContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.context.WebServiceContextImpl;
import org.apache.axis2.jaxws.context.factory.MessageContextFactory;
import org.apache.axis2.jaxws.context.utils.ContextUtils;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.handler.SoapMessageContext;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.runtime.description.injection.ResourceInjectionServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.injection.ResourceInjectionServiceRuntimeDescriptionFactory;
import org.apache.axis2.jaxws.server.endpoint.injection.ResourceInjector;
import org.apache.axis2.jaxws.server.endpoint.injection.WebServiceContextInjector;
import org.apache.axis2.jaxws.server.endpoint.injection.factory.ResourceInjectionFactory;
import org.apache.axis2.jaxws.server.endpoint.injection.impl.ResourceInjectionException;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.EndpointLifecycleException;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.EndpointLifecycleManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndpointLifecycleManagerImpl
implements EndpointLifecycleManager {
    public static final String WEBSERVICE_MESSAGE_CONTEXT = "javax.xml.ws.WebServiceContext";
    private static final Log log = LogFactory.getLog(EndpointLifecycleManagerImpl.class);
    private Object endpointInstance = null;
    private Class endpointClazz = null;

    public EndpointLifecycleManagerImpl(Object endpointInstance) {
        this.endpointInstance = endpointInstance;
        if (endpointInstance != null) {
            this.endpointClazz = endpointInstance.getClass();
        }
    }

    public EndpointLifecycleManagerImpl() {
    }

    public Object createServiceInstance(org.apache.axis2.jaxws.core.MessageContext mc, Class serviceImplClass) throws EndpointLifecycleException, ResourceInjectionException {
        ServiceContext serviceContext;
        Object serviceimpl;
        MessageContext msgContext = mc.getAxisMessageContext();
        ServiceDescription serviceDesc = mc.getEndpointDescription().getServiceDescription();
        ResourceInjectionServiceRuntimeDescription injectionDesc = null;
        if (serviceDesc != null) {
            injectionDesc = ResourceInjectionServiceRuntimeDescriptionFactory.get(serviceDesc, serviceImplClass);
        }
        if ((serviceimpl = (serviceContext = msgContext.getServiceContext()).getProperty("serviceObject")) != null) {
            this.endpointInstance = serviceimpl;
            this.endpointClazz = serviceImplClass;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Service Instance found in the service context, reusing the instance");
            }
            if (injectionDesc != null && injectionDesc.hasResourceAnnotation()) {
                javax.xml.ws.handler.MessageContext soapMessageContext = this.createSOAPMessageContext(mc);
                WebServiceContext ws = (WebServiceContext)serviceContext.getProperty(WEBSERVICE_MESSAGE_CONTEXT);
                if (ws != null) {
                    this.updateWebServiceContext(ws, soapMessageContext);
                }
            }
            return serviceimpl;
        }
        this.endpointInstance = serviceimpl = this.createServiceInstance(serviceImplClass);
        this.endpointClazz = serviceImplClass;
        if (log.isDebugEnabled()) {
            log.debug((Object)"New Service Instance created");
        }
        if (injectionDesc != null && injectionDesc.hasResourceAnnotation()) {
            javax.xml.ws.handler.MessageContext soapMessageContext = this.createSOAPMessageContext(mc);
            WebServiceContextImpl wsContext = new WebServiceContextImpl();
            wsContext.setSoapMessageContext(soapMessageContext);
            this.injectWebServiceContext(mc, wsContext, serviceimpl);
            serviceContext.setProperty(WEBSERVICE_MESSAGE_CONTEXT, (Object)wsContext);
        }
        if (injectionDesc != null && injectionDesc.getPostConstructMethod() != null) {
            this.invokePostConstruct(injectionDesc.getPostConstructMethod());
        }
        serviceContext.setProperty("serviceObject", serviceimpl);
        return serviceimpl;
    }

    public void invokePostConstruct() throws EndpointLifecycleException {
        if (this.endpointInstance == null) {
            throw new EndpointLifecycleException(Messages.getMessage((String)"EndpointLifecycleManagerImplErr1"));
        }
        Method method = this.getPostConstructMethod();
        if (method != null) {
            this.invokePostConstruct(method);
        }
    }

    private void invokePostConstruct(Method method) throws EndpointLifecycleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invoking Method with @PostConstruct annotation");
        }
        this.invokeMethod(method, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Completed invoke on Method with @PostConstruct annotation");
        }
    }

    public void invokePreDestroy() throws EndpointLifecycleException {
        if (this.endpointInstance == null) {
            throw new EndpointLifecycleException(Messages.getMessage((String)"EndpointLifecycleManagerImplErr1"));
        }
        Method method = this.getPreDestroyMethod();
        if (method != null) {
            this.invokePreDestroy(method);
        }
    }

    private void invokePreDestroy(Method method) throws EndpointLifecycleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invoking Method with @PreDestroy annotation");
        }
        this.invokeMethod(method, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Completed invoke on Method with @PreDestroy annotation");
        }
    }

    private void invokeMethod(Method m, Object[] params) throws EndpointLifecycleException {
        try {
            m.invoke(this.endpointInstance, params);
        }
        catch (InvocationTargetException e) {
            throw new EndpointLifecycleException(e);
        }
        catch (IllegalAccessException e) {
            throw new EndpointLifecycleException(e);
        }
    }

    private Method getPostConstructMethod() {
        if (this.endpointInstance != null) {
            Method[] methods;
            Class<?> endpointClazz = this.endpointInstance.getClass();
            for (Method method : methods = endpointClazz.getMethods()) {
                if (!this.isPostConstruct(method)) continue;
                return method;
            }
        }
        return null;
    }

    private Method getPreDestroyMethod() {
        if (this.endpointInstance != null) {
            Method[] methods;
            Class<?> endpointClazz = this.endpointInstance.getClass();
            for (Method method : methods = endpointClazz.getMethods()) {
                if (!this.isPreDestroy(method)) continue;
                return method;
            }
        }
        return null;
    }

    private boolean isPostConstruct(Method method) {
        int i$ = 0;
        Annotation[] annotations = method.getDeclaredAnnotations();
        Annotation[] arr$ = annotations;
        int len$ = arr$.length;
        if (i$ < len$) {
            Annotation annotation = arr$[i$];
            return PostConstruct.class.isAssignableFrom(annotation.annotationType());
        }
        return false;
    }

    private boolean isPreDestroy(Method method) {
        int i$ = 0;
        Annotation[] annotations = method.getDeclaredAnnotations();
        Annotation[] arr$ = annotations;
        int len$ = arr$.length;
        if (i$ < len$) {
            Annotation annotation = arr$[i$];
            return PreDestroy.class.isAssignableFrom(annotation.annotationType());
        }
        return false;
    }

    private Object createServiceInstance(Class serviceImplClass) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating new instance of service endpoint");
        }
        if (serviceImplClass == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"EndpointControllerErr5"));
        }
        Object instance = null;
        try {
            instance = serviceImplClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"EndpointControllerErr6", (String)serviceImplClass.getName()));
        }
        catch (InstantiationException e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"EndpointControllerErr6", (String)serviceImplClass.getName()));
        }
        return instance;
    }

    private javax.xml.ws.handler.MessageContext createSOAPMessageContext(org.apache.axis2.jaxws.core.MessageContext mc) {
        SoapMessageContext soapMessageContext = MessageContextFactory.createSoapMessageContext(mc);
        ContextUtils.addProperties(soapMessageContext, mc);
        return soapMessageContext;
    }

    private void injectWebServiceContext(org.apache.axis2.jaxws.core.MessageContext mc, WebServiceContext wsContext, Object serviceInstance) throws ResourceInjectionException {
        ResourceInjector ri = ResourceInjectionFactory.createResourceInjector(WebServiceContext.class);
        ri.inject(wsContext, serviceInstance);
    }

    private void updateWebServiceContext(WebServiceContext wsContext, javax.xml.ws.handler.MessageContext soapMessageContext) throws ResourceInjectionException {
        WebServiceContextInjector wci = (WebServiceContextInjector)ResourceInjectionFactory.createResourceInjector(WebServiceContext.class);
        wci.addMessageContext(wsContext, soapMessageContext);
    }
}

