/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.spi.migrator;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigrator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationContextMigratorUtil {
    private static final Log log = LogFactory.getLog(ApplicationContextMigrator.class);

    public static void addApplicationContextMigrator(ConfigurationContext configurationContext, String contextMigratorListID, ApplicationContextMigrator migrator) {
        LinkedList<ApplicationContextMigrator> migratorList = (LinkedList<ApplicationContextMigrator>)configurationContext.getProperty(contextMigratorListID);
        if (migratorList == null) {
            migratorList = new LinkedList<ApplicationContextMigrator>();
            configurationContext.setProperty(contextMigratorListID, migratorList);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding ApplicationContextMigrator: " + migrator.getClass().getName()));
        }
        migratorList.add(migrator);
    }

    public static void performMigrationToMessageContext(String contextMigratorListID, Map<String, Object> requestContext, MessageContext messageContext) {
        ConfigurationContext configCtx;
        List migratorList;
        if (messageContext == null) {
            throw ExceptionFactory.makeWebServiceException((String)"Null MessageContext");
        }
        ServiceDescription sd = messageContext.getEndpointDescription().getServiceDescription();
        if (sd != null && (migratorList = (List)(configCtx = sd.getAxisConfigContext()).getProperty(contextMigratorListID)) != null) {
            ListIterator itr = migratorList.listIterator();
            while (itr.hasNext()) {
                ApplicationContextMigrator cpm = (ApplicationContextMigrator)itr.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("migrator: " + cpm.getClass().getName() + ".migratePropertiesToMessageContext"));
                }
                cpm.migratePropertiesToMessageContext(requestContext, messageContext);
            }
        }
    }

    public static void performMigrationFromMessageContext(String contextMigratorListID, Map<String, Object> responseContext, MessageContext messageContext) {
        ConfigurationContext configCtx;
        List migratorList;
        if (messageContext == null) {
            throw ExceptionFactory.makeWebServiceException((String)"Null MessageContext");
        }
        ServiceDescription sd = messageContext.getEndpointDescription().getServiceDescription();
        if (sd != null && (migratorList = (List)(configCtx = sd.getAxisConfigContext()).getProperty(contextMigratorListID)) != null) {
            ListIterator itr = migratorList.listIterator();
            while (itr.hasNext()) {
                ApplicationContextMigrator cpm = (ApplicationContextMigrator)itr.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("migrator: " + cpm.getClass().getName() + ".migratePropertiesFromMessageContext"));
                }
                cpm.migratePropertiesFromMessageContext(responseContext, messageContext);
            }
        }
    }
}

