/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerType;
import org.apache.axis2.jaxws.handler.lifecycle.factory.HandlerLifecycleManager;
import org.apache.axis2.jaxws.handler.lifecycle.factory.HandlerLifecycleManagerFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerResolverImpl
implements HandlerResolver {
    static final Map<String, String> protocolBindingsMap = new HashMap<String, String>(5);
    private static Log log;
    private ServiceDescription serviceDesc;

    public HandlerResolverImpl(ServiceDescription sd) {
        this.serviceDesc = sd;
    }

    public ArrayList<Handler> getHandlerChain(PortInfo portinfo) {
        return this.resolveHandlers(portinfo);
    }

    private ArrayList<Handler> resolveHandlers(PortInfo portinfo) throws WebServiceException {
        Iterator it;
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        HandlerChainsType handlerCT = this.serviceDesc.getHandlerChain();
        EndpointDescription ed = null;
        if (portinfo != null) {
            ed = this.serviceDesc.getEndpointDescription(portinfo.getPortName());
        }
        if (ed != null) {
            HandlerChainsType handlerCT_fromEndpointDesc = ed.getHandlerChain();
            if (handlerCT == null) {
                handlerCT = handlerCT_fromEndpointDesc;
            }
        }
        Iterator iterator = it = handlerCT == null ? null : handlerCT.getHandlerChain().iterator();
        while (it != null && it.hasNext()) {
            HandlerChainType handlerChainType = (HandlerChainType)it.next();
            if (!HandlerResolverImpl.chainResolvesToPort(handlerChainType, portinfo)) continue;
            List handlerTypeList = handlerChainType.getHandler();
            for (HandlerType handlerType : handlerTypeList) {
                Handler handler;
                String portHandler = handlerType.getHandlerClass().getValue();
                MessageContext ctx = new MessageContext();
                ctx.setEndpointDescription(ed);
                HandlerLifecycleManager hlm = this.createHandlerlifecycleManager();
                try {
                    handler = hlm.createHandlerInstance(ctx, HandlerResolverImpl.loadClass(portHandler));
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)e);
                }
                if (LogicalHandler.class.isAssignableFrom(handler.getClass())) {
                    handlers.add((Handler)((LogicalHandler)handler));
                    continue;
                }
                if (SOAPHandler.class.isAssignableFrom(handler.getClass())) {
                    handlers.add((Handler)((SOAPHandler)handler));
                    continue;
                }
                if (Handler.class.isAssignableFrom(handler.getClass())) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"handlerChainErr1", (String)handler.getClass().getName()));
                }
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"handlerChainErr2", (String)handler.getClass().getName()));
            }
        }
        return handlers;
    }

    private HandlerLifecycleManager createHandlerlifecycleManager() {
        HandlerLifecycleManagerFactory elmf = (HandlerLifecycleManagerFactory)FactoryRegistry.getFactory(HandlerLifecycleManagerFactory.class);
        return elmf.createHandlerLifecycleManager();
    }

    private static Class loadClass(String clazz) throws ClassNotFoundException {
        return HandlerResolverImpl.forName(clazz, true, HandlerResolverImpl.getContextClassLoader());
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classLoader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("HandlerResolverImpl attempting to load Class: " + className));
                        }
                        return Class.forName(className, initialize, classLoader);
                    }
                    catch (Throwable e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("HandlerResolverImpl cannot load the following class Throwable Exception Occured: " + className));
                        }
                        throw new ClassNotFoundException("HandlerResolverImpl cannot load the following class Throwable Exception Occured:" + className);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e.getException());
        }
        return cl;
    }

    private static boolean chainResolvesToPort(HandlerChainType handlerChainType, PortInfo portinfo) {
        List protocolBindings = handlerChainType.getProtocolBindings();
        if (protocolBindings != null) {
            boolean match = true;
            Iterator it = protocolBindings.iterator();
            while (it.hasNext()) {
                match = false;
                String protocolBinding = (String)it.next();
                protocolBinding = protocolBinding.startsWith("##") ? protocolBindingsMap.get(protocolBinding) : protocolBinding;
                if (protocolBinding == null || !protocolBinding.equals(portinfo.getBindingID())) continue;
                match = true;
                break;
            }
            if (!match) {
                return match;
            }
        }
        if (!HandlerResolverImpl.doesPatternMatch(portinfo.getPortName(), handlerChainType.getPortNamePattern())) {
            return false;
        }
        return HandlerResolverImpl.doesPatternMatch(portinfo.getServiceName(), handlerChainType.getServiceNamePattern());
    }

    private static boolean doesPatternMatch(QName portInfoQName, QName pattern) {
        if (pattern == null) {
            return true;
        }
        String portInfoString = portInfoQName.toString();
        String patternString = pattern.toString();
        if (patternString.equals("*")) {
            return true;
        }
        if (patternString.contains("*")) {
            patternString = patternString.substring(0, patternString.length() - 1);
            return portInfoString.startsWith(patternString);
        }
        return portInfoString.equals(patternString);
    }

    static {
        protocolBindingsMap.put("##SOAP11_HTTP", "http://schemas.xmlsoap.org/wsdl/soap/http");
        protocolBindingsMap.put("##SOAP11_HTTP_MTOM", "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
        protocolBindingsMap.put("##SOAP12_HTTP", "http://www.w3.org/2003/05/soap/bindings/HTTP/");
        protocolBindingsMap.put("##SOAP12_HTTP_MTOM", "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
        protocolBindingsMap.put("##XML_HTTP", "http://www.w3.org/2004/08/wsdl/http");
        log = LogFactory.getLog(HandlerResolverImpl.class);
    }
}

