/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.impl;

import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.util.Reader2Writer;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BlockImpl
implements Block {
    private static Log log = LogFactory.getLog(BlockImpl.class);
    protected Object busObject;
    protected Object busContext;
    protected OMElement omElement = null;
    protected QName qName;
    protected BlockFactory factory;
    protected boolean consumed = false;
    protected Message parent;

    protected BlockImpl(Object busObject, Object busContext, QName qName, BlockFactory factory) {
        this.busObject = busObject;
        this.busContext = busContext;
        this.qName = qName;
        this.factory = factory;
    }

    protected BlockImpl(OMElement omElement, Object busContext, QName qName, BlockFactory factory) {
        this.omElement = omElement;
        this.busContext = busContext;
        this.qName = qName;
        this.factory = factory;
    }

    public BlockFactory getBlockFactory() {
        return this.factory;
    }

    public Object getBusinessContext() {
        return this.busContext;
    }

    public Message getParent() {
        return this.parent;
    }

    public void setParent(Message p) {
        this.parent = p;
    }

    public Object getBusinessObject(boolean consume) throws XMLStreamException, WebServiceException {
        if (this.consumed) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"BlockImplErr1", (String)this.getClass().getName()));
        }
        if (this.busObject != null) {
            this.busObject = this._getBOFromBO(this.busObject, this.busContext, consume);
        } else {
            XMLStreamReader reader = this.omElement.getBuilder() != null && !this.omElement.getBuilder().isCompleted() ? this.omElement.getXMLStreamReaderWithoutCaching() : this.omElement.getXMLStreamReader();
            this.busObject = this._getBOFromReader(reader, this.busContext);
            this.omElement = null;
        }
        Object newBusObject = this.busObject;
        this.setConsumed(consume);
        return newBusObject;
    }

    public QName getQName() throws WebServiceException {
        try {
            if (this.qName == null) {
                if (this.omElement == null) {
                    XMLStreamReader newReader = this._getReaderFromBO(this.busObject, this.busContext);
                    this.busObject = null;
                    StAXOMBuilder builder = new StAXOMBuilder(newReader);
                    this.omElement = builder.getDocumentElement();
                }
                this.qName = this.omElement.getQName();
            }
            return this.qName;
        }
        catch (Exception xse) {
            this.setConsumed(true);
            throw ExceptionFactory.makeWebServiceException((Throwable)xse);
        }
    }

    protected void setQName(QName qName) {
        this.qName = qName;
    }

    public XMLStreamReader getXMLStreamReader(boolean consume) throws XMLStreamException, WebServiceException {
        XMLStreamReader newReader = null;
        if (this.consumed) {
            if (this.getParent() != null && this.getParent().isPostPivot()) {
                return this._postPivot_getXMLStreamReader();
            }
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"BlockImplErr1", (String)this.getClass().getName()));
        }
        if (this.omElement != null) {
            if (consume) {
                newReader = this.omElement.getBuilder() != null && !this.omElement.getBuilder().isCompleted() ? this.omElement.getXMLStreamReaderWithoutCaching() : this.omElement.getXMLStreamReader();
                this.omElement = null;
            } else {
                newReader = this.omElement.getXMLStreamReader();
            }
        } else if (this.busObject != null) {
            this.busObject = this._getBOFromBO(this.busObject, this.busContext, consume);
            newReader = this._getReaderFromBO(this.busObject, this.busContext);
        }
        this.setConsumed(consume);
        return newReader;
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        return this.getXMLStreamReader(true);
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
        this.serialize((XMLStreamWriter)writer);
        writer.flush();
    }

    public void serialize(Writer writerTarget, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter((Writer)writerTarget));
        writer.setOutputFormat(format);
        this.serialize((XMLStreamWriter)writer);
        writer.flush();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        this.outputTo(writer, true);
    }

    public OMElement getOMElement() throws XMLStreamException, WebServiceException {
        OMElement newOMElement = null;
        boolean consume = true;
        if (this.consumed) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"BlockImplErr1", (String)this.getClass().getName()));
        }
        if (this.omElement != null) {
            newOMElement = this.omElement;
        } else if (this.busObject != null) {
            this.busObject = this._getBOFromBO(this.busObject, this.busContext, consume);
            XMLStreamReader newReader = this._getReaderFromBO(this.busObject, this.busContext);
            StAXOMBuilder builder = new StAXOMBuilder(newReader);
            newOMElement = builder.getDocumentElement();
        }
        this.setConsumed(consume);
        return newOMElement;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void setConsumed(boolean consume) {
        if (consume) {
            this.consumed = true;
            this.busObject = null;
            this.busContext = null;
            this.omElement = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Message Block Monitor: Action=Consumed");
                log.debug((Object)JavaUtils.stackToString());
            }
        } else {
            this.consumed = false;
        }
    }

    public boolean isQNameAvailable() {
        return this.qName != null;
    }

    public void outputTo(XMLStreamWriter writer, boolean consume) throws XMLStreamException, WebServiceException {
        if (this.consumed) {
            if (this.getParent() != null && this.getParent().isPostPivot()) {
                this._postPivot_outputTo(writer);
            }
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"BlockImplErr1", (String)this.getClass().getName()));
        }
        if (this.omElement != null) {
            if (consume) {
                this.omElement.serializeAndConsume(writer);
            } else {
                this.omElement.serialize(writer);
            }
        } else if (this.busObject != null) {
            this.busObject = this._getBOFromBO(this.busObject, this.busContext, consume);
            this._outputFromBO(this.busObject, this.busContext, writer);
        }
        this.setConsumed(consume);
    }

    protected void _postPivot_outputTo(XMLStreamWriter writer) throws XMLStreamException, WebServiceException {
        if (log.isDebugEnabled()) {
            QName theQName = this.isQNameAvailable() ? this.getQName() : new QName("unknown");
            log.debug((Object)("The Block for " + theQName + " is already consumed and therefore it is not written."));
            log.debug((Object)"If you need this block preserved, please set the org.apache.axis2.jaxws.spi.SAVE_REQUEST_MSG property on the MessageContext.");
        }
    }

    protected XMLStreamReader _postPivot_getXMLStreamReader() throws XMLStreamException, WebServiceException {
        if (log.isDebugEnabled()) {
            QName theQName = this.isQNameAvailable() ? this.getQName() : new QName("unknown");
            log.debug((Object)("The Block for " + theQName + " is already consumed and therefore it is only partially read."));
            log.debug((Object)"If you need this block preserved, please set the org.apache.axis2.jaxws.spi.SAVE_REQUEST_MSG property on the MessageContext.");
        }
        QName qName = this.getQName();
        String text = "";
        text = qName.getNamespaceURI().length() > 0 ? "<prefix:" + qName.getLocalPart() + " xmlns:prefix='" + qName.getNamespaceURI() + "'/>" : "<" + qName.getLocalPart() + "/>";
        StringReader sr = new StringReader(text);
        return StAXUtils.createXMLStreamReader((Reader)sr);
    }

    protected boolean isBusinessObject() {
        return this.busObject != null;
    }

    public String traceString(String indent) {
        return null;
    }

    protected Object _getBOFromBO(Object busObject, Object busContext, boolean consume) {
        return busObject;
    }

    protected abstract Object _getBOFromReader(XMLStreamReader var1, Object var2) throws XMLStreamException, WebServiceException;

    protected abstract XMLStreamReader _getReaderFromBO(Object var1, Object var2) throws XMLStreamException, WebServiceException;

    protected void _outputFromReader(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        Reader2Writer r2w = new Reader2Writer(reader);
        r2w.outputTo(writer);
    }

    protected abstract void _outputFromBO(Object var1, Object var2, XMLStreamWriter var3) throws XMLStreamException, WebServiceException;
}

