/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.endpoint.lifecycle.impl;

import java.lang.reflect.Method;
import javax.xml.ws.WebServiceContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.context.WebServiceContextImpl;
import org.apache.axis2.jaxws.context.factory.MessageContextFactory;
import org.apache.axis2.jaxws.context.utils.ContextUtils;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.handler.SoapMessageContext;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.injection.ResourceInjectionException;
import org.apache.axis2.jaxws.lifecycle.BaseLifecycleManager;
import org.apache.axis2.jaxws.lifecycle.LifecycleException;
import org.apache.axis2.jaxws.runtime.description.injection.ResourceInjectionServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.injection.ResourceInjectionServiceRuntimeDescriptionFactory;
import org.apache.axis2.jaxws.server.endpoint.injection.ResourceInjector;
import org.apache.axis2.jaxws.server.endpoint.injection.WebServiceContextInjector;
import org.apache.axis2.jaxws.server.endpoint.injection.factory.ResourceInjectionFactory;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.EndpointLifecycleManager;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndpointLifecycleManagerImpl
extends BaseLifecycleManager
implements EndpointLifecycleManager {
    public static final String WEBSERVICE_MESSAGE_CONTEXT = "javax.xml.ws.WebServiceContext";
    private static final Log log = LogFactory.getLog(EndpointLifecycleManagerImpl.class);

    public EndpointLifecycleManagerImpl(Object endpointInstance) {
        this.instance = endpointInstance;
    }

    public EndpointLifecycleManagerImpl() {
    }

    public Object createServiceInstance(org.apache.axis2.jaxws.core.MessageContext mc, Class serviceImplClass) throws LifecycleException, ResourceInjectionException {
        ServiceContext serviceContext;
        Object serviceimpl;
        MessageContext msgContext = mc.getAxisMessageContext();
        ServiceDescription serviceDesc = mc.getEndpointDescription().getServiceDescription();
        ResourceInjectionServiceRuntimeDescription injectionDesc = null;
        if (serviceDesc != null) {
            injectionDesc = ResourceInjectionServiceRuntimeDescriptionFactory.get(serviceDesc, serviceImplClass);
        }
        if ((serviceimpl = (serviceContext = msgContext.getServiceContext()).getProperty("serviceObject")) != null) {
            this.instance = serviceimpl;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Service Instance found in the service context, reusing the instance");
            }
            if (injectionDesc != null && injectionDesc.hasResourceAnnotation()) {
                javax.xml.ws.handler.MessageContext soapMessageContext = this.createSOAPMessageContext(mc);
                WebServiceContext ws = (WebServiceContext)serviceContext.getProperty(WEBSERVICE_MESSAGE_CONTEXT);
                if (ws != null) {
                    this.updateWebServiceContext(ws, soapMessageContext);
                }
            }
            return serviceimpl;
        }
        this.instance = serviceimpl = this.createServiceInstance(msgContext.getAxisService(), serviceImplClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)"New Service Instance created");
        }
        if (injectionDesc != null && injectionDesc.hasResourceAnnotation()) {
            javax.xml.ws.handler.MessageContext soapMessageContext = this.createSOAPMessageContext(mc);
            WebServiceContextImpl wsContext = new WebServiceContextImpl();
            wsContext.setSoapMessageContext(soapMessageContext);
            this.injectWebServiceContext(mc, wsContext, serviceimpl);
            serviceContext.setProperty(WEBSERVICE_MESSAGE_CONTEXT, (Object)wsContext);
        }
        if (injectionDesc != null && injectionDesc.getPostConstructMethod() != null) {
            this.invokePostConstruct(injectionDesc.getPostConstructMethod());
        }
        serviceContext.setProperty("serviceObject", serviceimpl);
        return serviceimpl;
    }

    private Object createServiceInstance(AxisService service, Class serviceImplClass) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating new instance of service endpoint");
        }
        if (serviceImplClass == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"EndpointControllerErr5"));
        }
        Object instance = null;
        try {
            Parameter serviceObjectParam;
            ClassLoader classLoader;
            Class serviceObjectMaker;
            Method method;
            if (service != null && service.getParameter("ServiceObjectSupplier") != null && (method = (serviceObjectMaker = Loader.loadClass((ClassLoader)(classLoader = service.getClassLoader()), (String)((String)(serviceObjectParam = service.getParameter("ServiceObjectSupplier")).getValue()).trim())).getMethod("getServiceObject", AxisService.class)) != null) {
                return method.invoke(serviceObjectMaker.newInstance(), service);
            }
            instance = serviceImplClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"EndpointControllerErr6", (String)serviceImplClass.getName()));
        }
        catch (InstantiationException e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"EndpointControllerErr6", (String)serviceImplClass.getName()));
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"EndpointControllerErr6", (String)serviceImplClass.getName()));
        }
        return instance;
    }

    private javax.xml.ws.handler.MessageContext createSOAPMessageContext(org.apache.axis2.jaxws.core.MessageContext mc) {
        SoapMessageContext soapMessageContext = MessageContextFactory.createSoapMessageContext(mc);
        ContextUtils.addProperties(soapMessageContext, mc);
        return soapMessageContext;
    }

    private void injectWebServiceContext(org.apache.axis2.jaxws.core.MessageContext mc, WebServiceContext wsContext, Object serviceInstance) throws ResourceInjectionException {
        ResourceInjector ri = ResourceInjectionFactory.createResourceInjector(WebServiceContext.class);
        ri.inject(wsContext, serviceInstance);
    }

    private void updateWebServiceContext(WebServiceContext wsContext, javax.xml.ws.handler.MessageContext soapMessageContext) throws ResourceInjectionException {
        WebServiceContextInjector wci = (WebServiceContextInjector)ResourceInjectionFactory.createResourceInjector(WebServiceContext.class);
        wci.addMessageContext(wsContext, soapMessageContext);
    }
}

