/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerType;
import org.apache.axis2.jaxws.description.xml.handler.String;
import org.apache.axis2.jaxws.handler.lifecycle.factory.HandlerLifecycleManager;
import org.apache.axis2.jaxws.handler.lifecycle.factory.HandlerLifecycleManagerFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.spi.handler.BaseHandlerResolver;
import org.apache.axis2.util.LoggingControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerResolverImpl
extends BaseHandlerResolver {
    private static Log log = LogFactory.getLog(HandlerResolverImpl.class);
    private ServiceDescription serviceDesc;
    private Object serviceDelegateKey;

    public HandlerResolverImpl(ServiceDescription sd) {
        this(sd, null);
    }

    public HandlerResolverImpl(ServiceDescription sd, Object serviceDelegateKey) {
        this.serviceDesc = sd;
        this.serviceDelegateKey = serviceDelegateKey;
    }

    public List<Handler> getHandlerChain(PortInfo portinfo) {
        ArrayList<Class> handlerClasses = null;
        if (this.serviceDelegateKey == null) {
            handlerClasses = this.serviceDesc.getHandlerChainClasses(portinfo);
        }
        if (handlerClasses == null) {
            handlerClasses = this.resolveHandlers(portinfo);
            if (this.serviceDelegateKey == null) {
                this.serviceDesc.setHandlerChainClasses(portinfo, handlerClasses);
            }
        }
        if (handlerClasses.size() == 0) {
            return new ArrayList<Handler>();
        }
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        MessageContext ctx = new MessageContext();
        ctx.setEndpointDescription(this.serviceDesc.getEndpointDescription(portinfo.getPortName()));
        HandlerLifecycleManager hlm = this.createHandlerlifecycleManager();
        for (Class aClass : handlerClasses) {
            try {
                handlers.add(hlm.createHandlerInstance(ctx, aClass));
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
            if (!LoggingControl.debugLoggingAllowed || !log.isDebugEnabled()) continue;
            log.debug((Object)("Successfully instantiated the class: " + aClass));
        }
        return handlers;
    }

    public List<java.lang.String> getRoles(PortInfo portInfo) {
        ArrayList<java.lang.String> handlerRoles = new ArrayList<java.lang.String>();
        this.resolveHandlers(portInfo, handlerRoles);
        return handlerRoles;
    }

    private ArrayList<Class> resolveHandlers(PortInfo portinfo) throws WebServiceException {
        return this.resolveHandlers(portinfo, null);
    }

    private ArrayList<Class> resolveHandlers(PortInfo portinfo, List<java.lang.String> handlerRoles) throws WebServiceException {
        Iterator it;
        ArrayList<Class> handlers = new ArrayList<Class>();
        this.handlerChainsType = this.serviceDesc.getHandlerChain(this.serviceDelegateKey);
        EndpointDescription ed = null;
        if (portinfo != null) {
            ed = this.serviceDesc.getEndpointDescription(portinfo.getPortName());
        }
        if (ed != null) {
            HandlerChainsType hct_includingComposite = ed.getHandlerChain(this.serviceDelegateKey);
            HandlerChainsType hct_noComposite = ed.getHandlerChain();
            if (this.handlerChainsType == null || hct_includingComposite != hct_noComposite) {
                this.handlerChainsType = hct_includingComposite;
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The PortInfo object did not match any ports; returning an empty list of handlers.  PortInfo QName: " + portinfo.getPortName()));
            }
            return handlers;
        }
        Iterator iterator = it = this.handlerChainsType == null ? null : this.handlerChainsType.getHandlerChain().iterator();
        while (it != null && it.hasNext()) {
            HandlerChainType handlerChainType = (HandlerChainType)it.next();
            if (!HandlerResolverImpl.chainResolvesToPort(handlerChainType, portinfo)) continue;
            List handlerTypeList = handlerChainType.getHandler();
            for (HandlerType handlerType : handlerTypeList) {
                Class aClass;
                java.lang.String portHandler = handlerType.getHandlerClass().getValue();
                try {
                    aClass = HandlerResolverImpl.loadClass(portHandler);
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)e);
                }
                if (LogicalHandler.class.isAssignableFrom(aClass)) {
                    handlers.add(aClass);
                } else if (SOAPHandler.class.isAssignableFrom(aClass)) {
                    handlers.add(aClass);
                } else {
                    if (Handler.class.isAssignableFrom(aClass)) {
                        throw ExceptionFactory.makeWebServiceException((java.lang.String)Messages.getMessage((java.lang.String)"handlerChainErr1", (java.lang.String)aClass.getName()));
                    }
                    throw ExceptionFactory.makeWebServiceException((java.lang.String)Messages.getMessage((java.lang.String)"handlerChainErr2", (java.lang.String)aClass.getName()));
                }
                if (handlerRoles == null) continue;
                List soapRolesList = handlerType.getSoapRole();
                for (String soapRoleElement : soapRolesList) {
                    java.lang.String addSoapRole = soapRoleElement.getValue();
                    handlerRoles.add(addSoapRole);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Adding soap role " + addSoapRole));
                }
            }
        }
        return handlers;
    }

    private HandlerLifecycleManager createHandlerlifecycleManager() {
        HandlerLifecycleManagerFactory elmf = (HandlerLifecycleManagerFactory)FactoryRegistry.getFactory(HandlerLifecycleManagerFactory.class);
        return elmf.createHandlerLifecycleManager();
    }
}

