/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class JAXBXMLStreamWriterFilter
implements XMLStreamWriter {
    private static final Log log = LogFactory.getLog(JAXBXMLStreamWriterFilter.class);
    XMLStreamWriter delegate;
    int numElements = 0;
    int numDefaultNS = 0;

    public JAXBXMLStreamWriterFilter(XMLStreamWriter delegate) {
        this.delegate = delegate;
    }

    public void close() throws XMLStreamException {
        this.delegate.close();
    }

    public void flush() throws XMLStreamException {
        this.delegate.flush();
    }

    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    public String getPrefix(String arg0) throws XMLStreamException {
        return this.delegate.getPrefix(arg0);
    }

    public Object getProperty(String arg0) throws IllegalArgumentException {
        return this.delegate.getProperty(arg0);
    }

    public void setDefaultNamespace(String namespaceURI) throws XMLStreamException {
        if (this.numElements == 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  default namespaceURI=" + namespaceURI));
            }
            ++this.numDefaultNS;
            if (this.numDefaultNS > 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"    WHY IS THE DEFAULT NAMESPACE WRITTEN TWICE?");
                    log.debug((Object)JavaUtils.stackToString());
                }
                return;
            }
        }
        this.delegate.setDefaultNamespace(namespaceURI);
    }

    public void setNamespaceContext(NamespaceContext arg0) throws XMLStreamException {
        this.delegate.setNamespaceContext(arg0);
    }

    public void setPrefix(String arg0, String arg1) throws XMLStreamException {
        this.delegate.setPrefix(arg0, arg1);
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this.numElements == 1 && log.isDebugEnabled()) {
            log.debug((Object)("  prefix=" + prefix + " namespace=" + namespaceURI + " localName=" + localName + " value=" + value));
        }
        this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this.numElements == 1 && log.isDebugEnabled()) {
            log.debug((Object)("  namespace=" + namespaceURI + " localName=" + localName + " value=" + value));
        }
        this.delegate.writeAttribute(namespaceURI, localName, value);
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (this.numElements == 1 && log.isDebugEnabled()) {
            log.debug((Object)("  localName=" + localName + " value=" + value));
        }
        this.delegate.writeAttribute(localName, value);
    }

    public void writeCData(String arg0) throws XMLStreamException {
        this.delegate.writeCData(arg0);
    }

    public void writeCharacters(char[] arg0, int arg1, int arg2) throws XMLStreamException {
        this.delegate.writeCharacters(arg0, arg1, arg2);
    }

    public void writeCharacters(String arg0) throws XMLStreamException {
        this.delegate.writeCharacters(arg0);
    }

    public void writeComment(String arg0) throws XMLStreamException {
        this.delegate.writeComment(arg0);
    }

    public void writeDefaultNamespace(String arg0) throws XMLStreamException {
        this.delegate.writeDefaultNamespace(arg0);
    }

    public void writeDTD(String arg0) throws XMLStreamException {
        this.delegate.writeDTD(arg0);
    }

    public void writeEmptyElement(String arg0, String arg1, String arg2) throws XMLStreamException {
        this.delegate.writeEmptyElement(arg0, arg1, arg2);
    }

    public void writeEmptyElement(String arg0, String arg1) throws XMLStreamException {
        this.delegate.writeEmptyElement(arg0, arg1);
    }

    public void writeEmptyElement(String arg0) throws XMLStreamException {
        this.delegate.writeEmptyElement(arg0);
    }

    public void writeEndDocument() throws XMLStreamException {
        this.delegate.writeEndDocument();
    }

    public void writeEndElement() throws XMLStreamException {
        this.delegate.writeEndElement();
    }

    public void writeEntityRef(String arg0) throws XMLStreamException {
        this.delegate.writeEntityRef(arg0);
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (this.numElements == 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  prefix=" + prefix + " namespaceURI=" + namespaceURI));
            }
            if ("xmlns".equals(prefix)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"    INVALID XMLNS attribute is removed prefix=");
                    log.debug((Object)JavaUtils.stackToString());
                }
                return;
            }
        }
        this.delegate.writeNamespace(prefix, namespaceURI);
    }

    public void writeProcessingInstruction(String arg0, String arg1) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(arg0, arg1);
    }

    public void writeProcessingInstruction(String arg0) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(arg0);
    }

    public void writeStartDocument() throws XMLStreamException {
        this.delegate.writeStartDocument();
    }

    public void writeStartDocument(String arg0, String arg1) throws XMLStreamException {
        this.delegate.writeStartDocument(arg0, arg1);
    }

    public void writeStartDocument(String arg0) throws XMLStreamException {
        this.delegate.writeStartDocument(arg0);
    }

    public void writeStartElement(String prefix, String namespaceURI, String localName) throws XMLStreamException {
        ++this.numElements;
        if (this.numElements == 1 && log.isDebugEnabled()) {
            log.debug((Object)("  prefix=" + prefix + " namespace=" + namespaceURI + " localName=" + localName));
        }
        this.delegate.writeStartElement(prefix, namespaceURI, localName);
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        ++this.numElements;
        if (this.numElements == 1 && log.isDebugEnabled()) {
            log.debug((Object)("  namespace=" + namespaceURI + " localName=" + localName));
        }
        this.delegate.writeStartElement(namespaceURI, localName);
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        ++this.numElements;
        if (this.numElements == 1 && log.isDebugEnabled()) {
            log.debug((Object)("  localName=" + localName));
        }
        this.delegate.writeStartElement(localName);
    }
}

